/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xmb.dc;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class Parser {
    public static BankResponse parserMsgHead(String content) throws EBServiceException {
        if (StringUtils.isEmpty((String)content)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u6d88\u606f\u5934\u9519\u8bef\uff0c\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a\u3002", (String)"Parser_0", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]));
        }
        BankResponse response = new BankResponse();
        try {
            String msg = content.substring(0, content.indexOf("#"));
            String[] contents = msg.split("\\|");
            response.setResponseCode(contents[1]);
            if (contents.length >= 3) {
                response.setResponseMessage(contents[2]);
            }
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u6790\u6d88\u606f\u5934\u5f02\u5e38, \u5f02\u5e38\u4fe1\u606f\uff1a%s", (String)"Parser_10", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        return response;
    }

    public static String parserSessionID(String content) throws EBServiceException {
        String sessionId = "";
        try {
            String msg = content.substring(0, content.indexOf("#"));
            String[] contents = msg.split("\\|");
            sessionId = contents[0];
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u6790\u6d88\u606f\u5934\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%s\u3002", (String)"Parser_11", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        if (StringUtils.isEmpty((String)sessionId)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u767b\u5f55\u5931\u8d25, \u767b\u5f55\u65f6\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u7684\u4f1a\u8bdd\u7f16\u53f7\uff08sessionId\uff09\u4e3a\u7a7a.", (String)"Parser_3", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]));
        }
        return sessionId;
    }

    public static Element getXmlRoot(String content) throws EBServiceException {
        if (StringUtils.isEmpty((String)(content = content.substring(content.indexOf("#") + 1)))) {
            return null;
        }
        return JDomUtils.string2Root((String)content, (String)RequestContextUtils.getCharset());
    }

    public static void parsePayRsp(PaymentInfo[] paymentInfos, String rspStr) throws EBServiceException {
        BankResponse response = Parser.parserMsgHead(rspStr);
        if (!"0000".equalsIgnoreCase(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"Parser_4", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            return;
        }
        Element root = Parser.getXmlRoot(rspStr);
        if (root == null) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"Parser_4", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), (String)"", (String)"");
            return;
        }
        Element opRep = root.getChild("opRep");
        Element opResult = opRep.getChild("opResult");
        String JYZT = opResult.getChildTextTrim("JYZT");
        String SBYY = opResult.getChildTextTrim("SBYY");
        if ("90".equalsIgnoreCase(JYZT)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"Parser_5", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), (String)"", (String)SBYY);
        } else if ("99".equalsIgnoreCase(JYZT)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"Parser_4", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), (String)JYZT, (String)SBYY);
        } else if ("91".equalsIgnoreCase(JYZT)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"Parser_5", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), (String)JYZT, (String)SBYY);
        } else if ("50".equalsIgnoreCase(JYZT)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"Parser_5", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), (String)JYZT, (String)SBYY);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"Parser_4", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), (String)JYZT, (String)SBYY);
        }
    }

    public static void parseQueryPayRsp(PaymentInfo[] paymentInfos, String rspStr) throws EBServiceException {
        BankResponse response = Parser.parserMsgHead(rspStr);
        if (!"0000".equalsIgnoreCase(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"Parser_4", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            return;
        }
        Element root = Parser.getXmlRoot(rspStr);
        if (root == null) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"Parser_4", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), (String)"", (String)"");
            return;
        }
        Element opRep = root.getChild("opRep");
        Element opResult = opRep.getChild("opResult");
        String JYZT = opResult.getChildTextTrim("JYZT");
        String SBYY = opResult.getChildTextTrim("SBYY");
        if ("90".equalsIgnoreCase(JYZT)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"Parser_6", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), (String)"", (String)SBYY);
        } else if ("99".equalsIgnoreCase(JYZT)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"Parser_4", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), (String)JYZT, (String)SBYY);
        } else if ("91".equalsIgnoreCase(JYZT)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"Parser_7", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), (String)JYZT, (String)SBYY);
        } else if ("50".equalsIgnoreCase(JYZT)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"Parser_5", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), (String)JYZT, (String)SBYY);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"Parser_4", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), (String)JYZT, (String)SBYY);
        }
    }

    public static PaymentInfo findPaymentInfo(PaymentInfo[] paymentInfos, String recAccount, String amount) throws EBServiceException {
        amount = BigDecimalHelper.plain2((BigDecimal)BigDecimalHelper.str2BigDecimal((String)amount));
        for (PaymentInfo pay : paymentInfos) {
            if (!pay.getIncomeAccNo().equalsIgnoreCase(recAccount) || !pay.getAmount().toString().equalsIgnoreCase(amount)) continue;
            return pay;
        }
        return null;
    }

    public static BankResponse parserHead(String content) throws EBServiceException {
        if (StringUtils.isEmpty((String)content)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u9519\u8bef\uff0c\u94f6\u884c\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a\u3002", (String)"Parser_8", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]));
        }
        BankResponse response = new BankResponse();
        Element root = Parser.getXmlRoot(content);
        if (root == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u6d88\u606f\u5934\u5f02\u5e38\uff0c\u62a5\u6587\u4e3a\u7a7a\u3002", (String)"Parser_9", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]));
        }
        Element opRep = root.getChild("opRep");
        Element opResult = opRep.getChild("opResult");
        try {
            String msg = opResult.getChildText("hostErrorMessage");
            String code = opResult.getChildText("hostReturnCode");
            response.setResponseCode(code);
            response.setResponseMessage(msg);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u6790\u6d88\u606f\u5934\u5f02\u5e38, \u5f02\u5e38\u4fe1\u606f\uff1a%s", (String)"Parser_10", (String)"ebg-aqap-banks-xmb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        return response;
    }
}

