/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.xmb.dc.service.payment.individual.salary;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.ebg.aqap.banks.xmb.dc.Packer;
import kd.ebg.aqap.banks.xmb.dc.Parser;
import kd.ebg.aqap.banks.xmb.dc.service.loginout.LoginAndOut;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImplWithPage;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.util.CommonPayStatusMatchUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.business.util.pojo.BankResPaymentInfo;
import kd.ebg.aqap.business.util.pojo.MatchPayStatusModel;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayImpl
extends AbstractQueryPayImplWithPage
implements IQueryPay {
    public int getBatchSize() {
        return 500;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setHttpHeader("Content-Type", "application/xml;charset=GBK");
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        Element XCCBEBankData = new Element("XCCBEBankData");
        Element opReq = JDomUtils.addChild((Element)XCCBEBankData, (String)"opReq");
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)DateUtil.formatDateTime((Date)new Date()));
        Element ReqParam = JDomUtils.addChild((Element)opReq, (String)"ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"batchNo", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"orderFlowNo", (String)paymentInfo.getPackageId());
        String currentPage = this.getCurrentPage();
        if ("0".equals(currentPage)) {
            this.setCurrentPage(currentPage);
        }
        JDomUtils.addChild((Element)ReqParam, (String)"QSBS", (String)this.getCurrentPage());
        JDomUtils.addChild((Element)ReqParam, (String)"CXBS", (String)String.valueOf(15));
        String xmlMessage = Packer.packFormatXmlMsg(XCCBEBankData, "GBK");
        String sessionId = LoginAndOut.getLoginAndOut().getLoginSessionId();
        return Packer.packAll(sessionId, "CBE014", xmlMessage);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        this.setLastPage(true);
        BankResponse response = Parser.parserMsgHead(rspStr);
        if (!"0000".equalsIgnoreCase(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)response.getResponseCode(), (String)response.getResponseMessage()));
        }
        Element root = Parser.getXmlRoot(rspStr);
        Element opRep = root.getChild("opRep");
        Element opResult = opRep.getChild("opResult");
        String hostReturnCode = opResult.getChildTextTrim("hostReturnCode");
        String hostErrorMessage = opResult.getChildTextTrim("hostErrorMessage");
        String turnPageTotalNum = opResult.getChildTextTrim("turnPageTotalNum");
        Element listElement = opResult.getChild("list");
        List rowList = listElement.getChildren("row");
        int totalNum = Integer.parseInt(turnPageTotalNum);
        int len = 0;
        if (null != rowList) {
            len = rowList.size();
        }
        this.handlePage(totalNum);
        if (!"0000".equalsIgnoreCase(hostReturnCode)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)hostReturnCode, (String)hostErrorMessage));
        }
        ArrayList<BankResPaymentInfo> bankResPaymentInfos = new ArrayList<BankResPaymentInfo>(16);
        for (int i = 0; i < len; ++i) {
            Element row = (Element)rowList.get(i);
            String recAccount = row.getChildTextTrim("recAccount");
            String recAccName = row.getChildTextTrim("recAccName");
            String amount = row.getChildTextTrim("amount");
            String state = row.getChildTextTrim("state");
            String bankRem = row.getChildTextTrim("bankRem");
            BankResPaymentInfo bankResPaymentInfo = new BankResPaymentInfo(recAccount, amount);
            bankResPaymentInfo.setBankStatus(state);
            bankResPaymentInfo.setBankMsg(bankRem);
            if ("0".equalsIgnoreCase(state)) {
                bankResPaymentInfo.setPaymentState(PaymentState.SUCCESS);
            } else if ("1".equalsIgnoreCase(state)) {
                bankResPaymentInfo.setPaymentState(PaymentState.FAIL);
            } else if ("2".equalsIgnoreCase(state)) {
                bankResPaymentInfo.setPaymentState(PaymentState.SUBMITED);
            } else {
                bankResPaymentInfo.setPaymentState(PaymentState.UNKNOWN);
            }
            bankResPaymentInfos.add(bankResPaymentInfo);
        }
        MatchPayStatusModel matchPayStatusModel = new MatchPayStatusModel();
        matchPayStatusModel.setMatchRule("ACCOUNT_AMOUNT");
        matchPayStatusModel.setBankResPaymentInfoList(bankResPaymentInfos);
        List allPaymentInfo = CommonPayStatusMatchUtil.getAllPaymentInfoByBankBatchNo((String)((PaymentInfo)bankPayRequest.getPaymentInfos().get(0)).getBankBatchSeqID());
        List paymentInfos = CommonPayStatusMatchUtil.HandlePayStatus((MatchPayStatusModel)matchPayStatusModel, (List)allPaymentInfo);
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CBE014";
    }

    public String getBizDesc() {
        return null;
    }

    public Boolean SupportPage() {
        return true;
    }

    public void handlePage(int totalNum) {
        String currentPage = this.getCurrentPage();
        if (totalNum <= 15) {
            this.setLastPage(true);
            return;
        }
        int nextPage = Integer.parseInt(currentPage) + 15;
        if (totalNum >= nextPage) {
            this.setCurrentPage(nextPage);
            this.setLastPage(false);
            return;
        }
        this.setLastPage(true);
    }
}

