/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.hk.services.payment;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.ebg.aqap.banks.cmb.hk.services.utils.JsonUtil;
import kd.ebg.aqap.banks.cmb.hk.services.utils.MsgPacker;
import kd.ebg.aqap.banks.cmb.hk.services.utils.MsgParser;
import kd.ebg.aqap.banks.cmb.hk.services.utils.PostUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;

public class QueryTransType
extends AbstractQueryPayImpl
implements IQueryPay {
    EBGLogger logger = EBGLogger.getInstance().getLogger(QueryTransType.class);

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        LocalDateTime submitSuccessTime = paymentInfo.getSubmitSuccessTime();
        JSONObject hkmultiinfox = new JSONObject();
        hkmultiinfox.put("startDate", (Object)submitSuccessTime.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        hkmultiinfox.put("endDate", (Object)submitSuccessTime.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        hkmultiinfox.put("dateType", (Object)"N");
        hkmultiinfox.put("transCode", (Object)paymentInfo.getBiz("transCode"));
        hkmultiinfox.put("pageSize", (Object)"100");
        hkmultiinfox.put("pageNum", (Object)this.getCurrentPage());
        JSONObject body = new JSONObject();
        body.put("hkmultiinfox", (Object)hkmultiinfox);
        JSONObject head = JsonUtil.getHead(this.getBizCode(), Sequence.genSequence());
        JSONObject requestJson = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(requestJson, this.getBizCode());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        int totalCount;
        int currentCount;
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        String res = MsgParser.getReceMsg(rspStr);
        MsgParser.checkResponse(res);
        JSONObject response = JSONObject.parseObject((String)res);
        JSONObject resp = response.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONObject result = body.getJSONObject("result");
        String total = result.getString("total");
        String currentPage = this.getCurrentPage();
        if (StringUtils.isNotEmpty((String)total) && StringUtils.isNotEmpty((String)currentPage) && (currentCount = Integer.parseInt(currentPage)) * 100 < (totalCount = Integer.parseInt(total))) {
            int nextPage = currentCount + 1;
            this.setCurrentPage(nextPage);
            this.setLastPage(false);
        }
        JSONArray list = result.getJSONArray("list");
        for (Object o : list) {
            JSONObject detail = (JSONObject)o;
            String serNo = detail.getString("serNo");
            String transType = detail.getString("transType");
            if (!serNo.equals(paymentInfo.getBankRefID())) continue;
            this.logger.info("===\u83b7\u53d6\u4ea4\u6613\u7c7b\u578b\u6210\u529f===");
            paymentInfo.setBiz("transType", transType);
            this.setLastPage(true);
            return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
        }
        this.logger.info("\u5f53\u524d\u9875{}\u6ca1\u6709\u67e5\u8be2\u5230\u4ea4\u6613\u7c7b\u578b", (Object)this.getCurrentPage());
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public EBBankPayResponse doBiz(BankPayRequest bankPayRequest) {
        EBBankPayResponse response;
        this.setLastPage(true);
        this.setCurrentPage(1);
        do {
            try {
                String rqstStr = this.pack(bankPayRequest);
                String rspStr = PostUtil.sendMsg(rqstStr);
                response = this.parse(bankPayRequest, rspStr);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        } while (!this.isLastPage());
        return response;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "hkmultiinfo";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u7efc\u5408\u4ea4\u6613\u67e5\u8be2", (String)"QueryTransType_0", (String)"ebg-aqap-banks-cmb-hk", (Object[])new Object[0]);
    }
}

