/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.hk.services.payment.hkintrabank;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.hk.services.payment.BusModUtil;
import kd.ebg.aqap.banks.cmb.hk.services.payment.PayPreCheck;
import kd.ebg.aqap.banks.cmb.hk.services.payment.QueryPaymentImpl;
import kd.ebg.aqap.banks.cmb.hk.services.utils.JsonUtil;
import kd.ebg.aqap.banks.cmb.hk.services.utils.MatchUtil;
import kd.ebg.aqap.banks.cmb.hk.services.utils.MsgPacker;
import kd.ebg.aqap.banks.cmb.hk.services.utils.MsgParser;
import kd.ebg.aqap.banks.cmb.hk.services.utils.PostUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PayPreCheck.PayCheckForIntraBank(bankPayRequest);
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        paymentInfo.setBiz("transCode", "AT");
        String feeType = paymentInfo.getFeeType();
        JSONObject hkintrabank = new JSONObject();
        String busMod = BusModUtil.getBusModByAccNo(paymentInfo.getAccNo());
        hkintrabank.put("bmId", (Object)busMod);
        hkintrabank.put("costBear", (Object)MatchUtil.payeeTypeMap.get(feeType));
        hkintrabank.put("debitAccount", (Object)paymentInfo.getAccNo());
        hkintrabank.put("debitAmount", (Object)paymentInfo.getAmount().toString());
        hkintrabank.put("debitCurrency", (Object)paymentInfo.getPayCurrency());
        boolean diffCurrency = paymentInfo.isDiffCurrency();
        if (!diffCurrency) {
            LocalDateTime bookingTime = paymentInfo.getBookingTime() != null ? paymentInfo.getBookingTime() : paymentInfo.getSubmitSuccessTime();
            String valueDate = bookingTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            hkintrabank.put("valueDate", (Object)valueDate);
            hkintrabank.put("valueTime", (Object)"10");
        }
        hkintrabank.put("creditAccount", (Object)paymentInfo.getIncomeAccNo());
        if (paymentInfo.isDiffCurrency()) {
            hkintrabank.put("creditCurrency", (Object)paymentInfo.getExchangeCurrency());
        } else {
            hkintrabank.put("creditCurrency", (Object)paymentInfo.getPayCurrency());
        }
        String incomeAccName = paymentInfo.getIncomeAccName();
        List<String> arrayList = MatchUtil.splitByLimitLength(incomeAccName, 33);
        int i = 1;
        for (String split : arrayList) {
            hkintrabank.put("creditNameAndAddress" + i++, (Object)split);
        }
        JSONObject body = new JSONObject();
        body.put("hkintrabankx", (Object)hkintrabank);
        JSONObject head = JsonUtil.getHead(this.getBizCode(), Sequence.genSequence());
        JSONObject requestJson = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(requestJson, this.getBizCode());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        String res = MsgParser.getReceMsg(rspStr);
        MsgParser.checkResponse(res);
        JSONObject response = JSONObject.parseObject((String)res);
        JSONObject resp = response.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONObject result = body.getJSONObject("result");
        String flag = result.getString("flag");
        String serNo = result.getString("serNo");
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        paymentInfo.setBankRefID(serNo);
        if ("SUCCESS".equals(flag)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)"", (String)"");
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)"", (String)"");
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public EBBankPayResponse doBiz(BankPayRequest bankPayRequest) {
        try {
            String rqstStr = this.pack(bankPayRequest);
            String rspStr = PostUtil.sendMsg(rqstStr);
            return this.parse(bankPayRequest, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "hkintrabank";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u884c\u5185\u8f6c\u8d26", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-cmb-hk", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

