/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.hk.services.payment.hkremitto;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.hk.services.payment.BusModUtil;
import kd.ebg.aqap.banks.cmb.hk.services.payment.QueryPaymentImpl;
import kd.ebg.aqap.banks.cmb.hk.services.utils.JsonUtil;
import kd.ebg.aqap.banks.cmb.hk.services.utils.MatchUtil;
import kd.ebg.aqap.banks.cmb.hk.services.utils.MsgPacker;
import kd.ebg.aqap.banks.cmb.hk.services.utils.MsgParser;
import kd.ebg.aqap.banks.cmb.hk.services.utils.PostUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        paymentInfo.setBiz("transCode", "TO");
        String feeType = paymentInfo.getFeeType();
        JSONObject hkremittox = new JSONObject();
        String busMod = BusModUtil.getBusModByAccNo(paymentInfo.getAccNo());
        hkremittox.put("bmId", (Object)busMod);
        hkremittox.put("costBear", (Object)MatchUtil.payeeTypeMap.get(feeType));
        hkremittox.put("debitAccount", (Object)paymentInfo.getAccNo());
        hkremittox.put("debitAmount", (Object)paymentInfo.getAmount().toString());
        hkremittox.put("debitCurrency", (Object)paymentInfo.getPayCurrency());
        LocalDateTime bookingTime = paymentInfo.getBookingTime() != null ? paymentInfo.getBookingTime() : paymentInfo.getSubmitSuccessTime();
        String valueDate = bookingTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        hkremittox.put("valueDate", (Object)valueDate);
        hkremittox.put("valueTime", (Object)"10");
        hkremittox.put("creditAccount", (Object)paymentInfo.getIncomeAccNo());
        CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfoByName(paymentInfo.getAccCountry());
        if (code == null) {
            code = ISOCountryUtils.getInstance().getCountryInfo(paymentInfo.getAccCountry());
        }
        hkremittox.put("creditCountryRegion", (Object)code.geteChart2());
        if (paymentInfo.isDiffCurrency()) {
            hkremittox.put("creditCurrency", (Object)paymentInfo.getExchangeCurrency());
        } else {
            hkremittox.put("creditCurrency", (Object)paymentInfo.getPayCurrency());
        }
        String incomeAccName = paymentInfo.getIncomeAccName();
        List<String> arrayList = MatchUtil.splitByLimitLength(incomeAccName, 33);
        int i = 1;
        for (String split : arrayList) {
            hkremittox.put("creditNameAndAddress" + i++, (Object)split);
        }
        hkremittox.put("creditBankCode", (Object)paymentInfo.getIncomeSwiftCode());
        List<String> arrayList1 = MatchUtil.splitByLimitLength(paymentInfo.getIncomeBankName(), 33);
        int n = 1;
        for (String split : arrayList1) {
            hkremittox.put("creditBankNameAndAddress" + n++, (Object)split);
        }
        JSONObject body = new JSONObject();
        body.put("hkremittox", (Object)hkremittox);
        JSONObject head = JsonUtil.getHead(this.getBizCode(), Sequence.genSequence());
        JSONObject requestJson = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(requestJson, this.getBizCode());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        String res = MsgParser.getReceMsg(rspStr);
        MsgParser.checkResponse(res);
        JSONObject response = JSONObject.parseObject((String)res);
        JSONObject resp = response.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONObject result = body.getJSONObject("result");
        String flag = result.getString("flag");
        String serNo = result.getString("serNo");
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        paymentInfo.setBankRefID(serNo);
        if ("SUCCESS".equals(flag)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)"", (String)"");
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)"", (String)"");
        }
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public EBBankPayResponse doBiz(BankPayRequest bankPayRequest) {
        try {
            String rqstStr = this.pack(bankPayRequest);
            String rspStr = PostUtil.sendMsg(rqstStr);
            return this.parse(bankPayRequest, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "hkremitto";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6d77\u5916\u6c47\u6b3e", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-cmb-hk", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

