/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bosh.dc.service.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bosh.dc.service.payment.PayTypeHelper;
import kd.ebg.aqap.banks.bosh.dc.service.payment.newcrossbank.PaymentImpl;
import kd.ebg.aqap.banks.bosh.dc.service.payment.salary.SalaryPaymentImpl;
import kd.ebg.aqap.banks.bosh.dc.service.payment.single.other.OtherBankPayImpl;
import kd.ebg.aqap.banks.bosh.dc.service.payment.single.same.SameBankPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.BusiImplInfo;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.atomic.PretreatmentTrace;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.route.PayRouteEnum;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PretreatmentImpl
extends PretreatmentTrace
implements IPretreat {
    public void appendData(PaymentInfo paymentInfo) {
        this.setPayRouteTrace(paymentInfo, this.getBusiImplInfo(paymentInfo));
    }

    public BusiImplInfo getBusiImplInfo(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = new BusiImplInfo();
        busiImplInfo.setPackageKey("");
        if (this.isPay(paymentInfo)) {
            if (this.isAuthorize()) {
                if (this.isSameBank(paymentInfo)) {
                    this.setImplClassName(paymentInfo, SameBankPayImpl.class.getName());
                } else {
                    this.setImplClassName(paymentInfo, OtherBankPayImpl.class.getName());
                }
            } else if (this.isSameBank(paymentInfo)) {
                if (this.isCrossUsedBySameBank()) {
                    this.setImplClassName(paymentInfo, PaymentImpl.class.getName());
                } else {
                    this.setImplClassNameCustom(paymentInfo, kd.ebg.aqap.banks.bosh.dc.service.payment.PaymentImpl.class.getName());
                }
            } else if (this.newOrOld()) {
                this.setImplClassName(paymentInfo, PaymentImpl.class.getName());
            } else {
                this.setImplClassNameCustom(paymentInfo, kd.ebg.aqap.banks.bosh.dc.service.payment.PaymentImpl.class.getName());
            }
        } else if (this.isPay_for_salary(paymentInfo)) {
            this.setImplClassName(paymentInfo, SalaryPaymentImpl.class.getName());
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u5b9e\u73b0\u8be5\u79cd\u4e1a\u52a1\u7c7b\u578b%s, \u8bf7\u68c0\u67e5\u8be5\u4e1a\u52a1\u7c7b\u578b\u662f\u5426\u6b63\u786e\u3002", (String)"PretreatmentImpl_0", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]), paymentInfo.getSubBizType()));
        }
        return busiImplInfo;
    }

    public boolean isCrossUsedBySameBank() {
        return this.assertBusinessConfig("BOSH_DC_PAYMENT_CHOOSE", "cross");
    }

    public boolean newOrOld() {
        return this.assertBusinessConfig("bosh_dc_cross_bank_pay", "new");
    }

    public boolean isAuthorize() {
        return this.assertBusinessConfig("bosh_dc_payment_type", "authorize");
    }

    public EBBankPayResponse doBiz(BankPayRequest bankPayRequest) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public void setImplClassNameCustom(PaymentInfo paymentInfo, String className) {
        if (StringUtils.isNotEmpty((String)className)) {
            String payBizCode = this.getTransferTypeOP(paymentInfo);
            paymentInfo.setImplClassName(className);
            this.addRoute(false, PayRouteEnum.IMPL.getDesc(), className);
            try {
                AbstractPayImpl pay = (AbstractPayImpl)Class.forName(className).newInstance();
                this.addRoute(false, PayRouteEnum.BANK_PAY_CODE.getDesc(), payBizCode);
                paymentInfo.setQueryImplClassName(pay.defaultQueryClass().getName());
                className = pay.defaultQueryClass().getName();
                this.addRoute(false, PayRouteEnum.QUERY_IMPL.getDesc(), className);
                try {
                    AbstractQueryPayImpl queryPay = (AbstractQueryPayImpl)Class.forName(className).newInstance();
                    String bankQueryPayCode = queryPay.getBizCode();
                    this.addRoute(false, PayRouteEnum.BANK_QUERY_PAY_CODE.getDesc(), StringUtils.isEmpty((String)bankQueryPayCode) ? "" : bankQueryPayCode);
                }
                catch (Exception var5) {
                    EBExceiptionUtil.serviceException((String)("QueryPayImpl = " + className + " is not found"), (Throwable)var5);
                }
            }
            catch (Exception var5) {
                EBExceiptionUtil.serviceException((String)("PayImpl = " + className + " is not found"), (Throwable)var5);
            }
        }
    }

    private String getTransferTypeOP(PaymentInfo paymentInfo) {
        if (this.isSameBank(paymentInfo)) {
            if (this.isIndividual(paymentInfo)) {
                return "transferPersonal1_1Op";
            }
            return "transferInner1_1Op";
        }
        if (this.isSameCity(paymentInfo)) {
            if (this.isShangHaiSameCity(paymentInfo)) {
                return "transferSHCity1_1Op";
            }
            return "transferSameCity1_1Op";
        }
        return "transferDiffCity1_1Op";
    }

    public boolean isShangHaiSameCity(PaymentInfo paymentInfo) {
        boolean result = PayTypeHelper.isShangHaiSameCity(paymentInfo);
        this.addRoute(false, ResManager.loadKDString((String)"\u4e0a\u6d77\u540c\u57ce ", (String)"", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]), String.valueOf(result));
        return result;
    }
}

