/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bosh.dc.service.payment.salary;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bosh.dc.service.login.LoginAndOut;
import kd.ebg.aqap.banks.bosh.dc.service.proxy.FileDownLoad;
import kd.ebg.aqap.banks.bosh.dc.utils.CommonUtil;
import kd.ebg.aqap.banks.bosh.dc.utils.Packer;
import kd.ebg.aqap.banks.bosh.dc.utils.Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.util.CommonPayStatusMatchUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(QueryPaymentImpl.class);

    public String getDeveloper() {
        return "jiashu_xie";
    }

    public String getBizCode() {
        return "APIDownLoadUNFileServlet";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5de5\u8d44\u67e5\u8be2\u63a5\u53e3", (String)"QueryPaymentImpl_1", (String)"ebg-aqap-banks-bosh-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        String session = LoginAndOut.login4GetSession();
        StringBuilder localStringBuilder = new StringBuilder();
        String batchNo = ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID();
        String serialNo = Sequence.gen16Sequence();
        localStringBuilder.append("http://").append(RequestContextUtils.getBankParameterValue((String)"ip")).append(":").append(RequestContextUtils.getBankParameterValue((String)"exchangePort")).append("/CM/APIDownLoadUNFileServlet?dse_sessionId=").append(session).append("&").append("batchNo").append("=").append(batchNo).append("&").append("type").append("=").append("012").append("&").append("serialNo").append("=").append(serialNo);
        Element reqParam = new Element("ReqParam");
        String split = "_";
        String bankBatchSeqId = ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId();
        String customerId = RequestContextUtils.getBankParameterValue((String)"USER_ID");
        String fileName = customerId + split + "012" + split + bankBatchSeqId + split + "ret.txt";
        JDomUtils.addChild((Element)reqParam, (String)"fileName", (String)fileName);
        JDomUtils.addChild((Element)reqParam, (String)"URL", (String)localStringBuilder.toString());
        JDomUtils.addChild((Element)reqParam, (String)"bizType", (String)"downloadFile");
        JDomUtils.addChild((Element)reqParam, (String)"serialNo", (String)serialNo);
        return Packer.packAllInOne(((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqID(), reqParam);
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        FileDownLoad fileDownload = new FileDownLoad();
        fileDownload.setRequestPacketStr(this.pack(request));
        String res = fileDownload.doBiz();
        return this.parse(request, res);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List paymentInfos = request.getPaymentInfos();
        BankResponse rsp = Parser.parseResponse(responseStr);
        if ("0".equals(rsp.getResponseCode())) {
            Element root = JDomUtils.string2Root((String)responseStr, (String)EBContext.getContext().getCharsetName());
            Element opRep = root.getChild("opRep");
            String fileContent = opRep.getChildText("fileContent");
            this.downLoadAndParseFile(request, fileContent);
        } else if ("0004".equals(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)PaymentState.SUBMITED.getCnName(), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)PaymentState.UNKNOWN.getCnName(), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        EBBankPayResponse response = new EBBankPayResponse();
        response.setPaymentInfos(paymentInfos);
        return response;
    }

    private void downLoadAndParseFile(BankPayRequest request, String fileContent) {
        log.info("\u5f00\u59cb\u89e3\u6790\u6587\u4ef6\u5185\u5bb9==" + fileContent);
        List paymentInfos = request.getPaymentInfos();
        String newLine = "\n";
        String separator = "|";
        HashMap<String, PaymentInfo> paymentInfoMap = new HashMap<String, PaymentInfo>(16);
        for (PaymentInfo paymentInfo : paymentInfos) {
            String serialNo = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"bosh_serialNo");
            paymentInfoMap.put(serialNo, paymentInfo);
        }
        String[] lineStr = StringUtils.split((String)fileContent, (String)newLine);
        for (int i = 1; i < lineStr.length; ++i) {
            String[] payStatusArray = StringUtils.split((String)lineStr[i], (String)separator);
            String serialNo = payStatusArray[0];
            String status = payStatusArray[6];
            String msg = payStatusArray[7];
            String incomeName = payStatusArray[1];
            String incomeNo = payStatusArray[2];
            String amount = payStatusArray[3];
            PaymentInfo paymentInfo = (PaymentInfo)paymentInfoMap.get(serialNo);
            if (paymentInfo == null) {
                log.info("serialNo\u7f16\u53f7\u4e3a{}\u4e0d\u5b58\u5728", (Object)serialNo);
                continue;
            }
            if ("0000".equals(status)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)PaymentState.SUCCESS.getCnName(), (String)status, (String)msg);
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)PaymentState.FAIL.getCnName(), (String)status, (String)msg);
            }
            CommonPayStatusMatchUtil.checkPayStatusWith3Factor((PaymentInfo)paymentInfo, (String)incomeNo, (String)incomeName, (String)amount);
        }
    }

    public int getBatchSize() {
        return 1000;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/CM/APIReqServlet");
        factory.setHttpHeader("User-Agent", "MSIE");
        if (CommonUtil.isCFCA().booleanValue()) {
            factory.setHttpHeader("Content-Type-CFCA", "123456");
        }
    }
}

