/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.arcu.dc.services.payment.batchcollection;

import java.util.List;
import kd.ebg.aqap.banks.arcu.dc.services.payment.MainQryPaymentImpl;
import kd.ebg.aqap.banks.arcu.dc.services.payment.common.CommonParser;
import kd.ebg.aqap.banks.arcu.dc.services.utils.ARCU_DC_Packer;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BtcCollectPaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 100;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return MainQryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = ARCU_DC_Packer.getCommonHeader("B2EGroupBatchUp", paymentInfo.getBankBatchSeqId(), paymentInfo.getRequestTime());
        Element body = JDomUtils.addChild((Element)root, (String)"Body");
        JDomUtils.addChild((Element)body, (String)"PayeeAcNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"PayeeAcName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"Currency", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"TotalCount", (String)paymentInfo.getTotalAmount().toString());
        Element list = JDomUtils.addChild((Element)body, (String)"List");
        for (int i = 0; i < paymentInfos.size(); ++i) {
            Element map = JDomUtils.addChild((Element)list, (String)"Map");
            paymentInfo = (PaymentInfo)paymentInfos.get(i);
            JDomUtils.addChild((Element)map, (String)"PayerAcNo", (String)paymentInfo.getIncomeAccNo());
            JDomUtils.addChild((Element)map, (String)"PayerAcName", (String)paymentInfo.getIncomeAccName());
            JDomUtils.addChild((Element)map, (String)"CollectionTyp", (String)"");
            JDomUtils.addChild((Element)map, (String)"Amount");
            JDomUtils.addChild((Element)map, (String)"Percent");
            JDomUtils.addChild((Element)map, (String)"Remark", (String)paymentInfo.getExplanation());
        }
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        CommonParser.parserCommonInfo(paymentInfo, s);
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EGroupBatchUp";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
        factory.setUri(ARCU_DC_Packer.getURI(true));
        this.configFactory(factory);
        return factory;
    }
}

