/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.arcu.dc.services.payment.batchpay;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.arcu.dc.services.payment.common.CommonParser;
import kd.ebg.aqap.banks.arcu.dc.services.payment.common.CommonQueryPayPacker;
import kd.ebg.aqap.banks.arcu.dc.services.utils.ARCU_DC_Packer;
import kd.ebg.aqap.banks.arcu.dc.services.utils.ARCU_DC_Parser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.util.CommonPayStatusMatchUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.business.util.pojo.BankResPaymentInfo;
import kd.ebg.aqap.business.util.pojo.MatchPayStatusModel;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BtcQryPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 0;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        Element root = CommonQueryPayPacker.getCommonHeader(paymentInfo.getBankBatchSeqId(), paymentInfo.getRequestTime());
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)root, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = ARCU_DC_Parser.parserCommonHeader(root);
        if (!"000000".equals(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage()));
        }
        Element body = JDomUtils.getChildElement((Element)root, (String)"Body");
        Element list = JDomUtils.getChildElement((Element)body, (String)"List");
        List mapsList = list.getChildren("Map");
        if (mapsList.size() <= 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u94f6\u884c\u660e\u7ec6\u4e3a\u7a7a\u3002", (String)"CommonQueryPayParser_1", (String)"ebg-aqap-banks-arcu-dc", (Object[])new Object[0]));
        }
        ArrayList<BankResPaymentInfo> bankResPaymentInfos = new ArrayList<BankResPaymentInfo>(16);
        for (int i = 0; i < mapsList.size(); ++i) {
            String payeeAcNo = JDomUtils.getChildText((Element)((Element)mapsList.get(i)), (String)"PayeeAcNo");
            String amout = JDomUtils.getChildText((Element)((Element)mapsList.get(i)), (String)"Amount");
            String payeeAcName = JDomUtils.getChildText((Element)((Element)mapsList.get(i)), (String)"PayeeAcName");
            String status = JDomUtils.getChildText((Element)((Element)mapsList.get(i)), (String)"Status");
            BankResPaymentInfo bankResPaymentInfo = new BankResPaymentInfo(payeeAcNo, payeeAcName, amout);
            bankResPaymentInfo.setBankStatus(status);
            bankResPaymentInfo.setBankMsg(CommonParser.getBankMsg(status));
            if ("0".equals(status)) {
                bankResPaymentInfo.setPaymentState(PaymentState.SUCCESS);
            } else if ("1".equals(status) || "2".equals(status) || "7".equals(status)) {
                bankResPaymentInfo.setPaymentState(PaymentState.FAIL);
            } else {
                bankResPaymentInfo.setPaymentState(PaymentState.UNKNOWN);
            }
            bankResPaymentInfos.add(bankResPaymentInfo);
        }
        MatchPayStatusModel matchPayStatusModel = new MatchPayStatusModel();
        matchPayStatusModel.setMatchRule("ACCOUNT_NAME_AMOUNT");
        matchPayStatusModel.setBankResPaymentInfoList(bankResPaymentInfos);
        List allPaymentInfo = CommonPayStatusMatchUtil.getAllPaymentInfoByBankBatchNo((String)((PaymentInfo)bankPayRequest.getPaymentInfos().get(0)).getBankBatchSeqID());
        EBBankPayResponse response = new EBBankPayResponse(CommonPayStatusMatchUtil.HandlePayStatus((MatchPayStatusModel)matchPayStatusModel, (List)allPaymentInfo));
        return response;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2ETransResultQry";
    }

    public String getBizDesc() {
        return null;
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
        factory.setUri(ARCU_DC_Packer.getURI());
        this.configFactory(factory);
        return factory;
    }
}

