/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.citic.amh.services.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.services.MappingAcctService;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    static final int PAGE_SIZE = 10;

    public String pack(BankDetailRequest request) {
        String accno;
        MappingAcctService service = MappingAcctService.getInstance();
        if (service.isExist(accno = request.getHeader().getAcnt().getAccNo())) {
            String iso = CurrencyUtils.convert2Iso((String)request.getBankCurrency(), (String)request.getHeader().getBankVersionID(), (String)request.getHeader().getCustomerID());
            accno = service.mapping(accno, iso);
        }
        Element root = JDomUtils.createRoot((String)"stream");
        JDomUtils.addChild((Element)root, (String)"action", (String)"DLMTCQRY");
        JDomUtils.addChild((Element)root, (String)"userName", (String)RequestContextUtils.getBankParameterValue((String)"username"));
        JDomUtils.addChild((Element)root, (String)"accNo", (String)accno);
        JDomUtils.addChild((Element)root, (String)"pageNumber", (String)"10");
        String currentPage = this.getCurrentPage();
        if ("0".equals(currentPage) || StringUtils.isEmpty((String)currentPage)) {
            currentPage = "1";
            this.setCurrentPage(currentPage);
        }
        JDomUtils.addChild((Element)root, (String)"startRecord", (String)currentPage);
        JDomUtils.addChild((Element)root, (String)"cryType", (String)request.getBankCurrency());
        if (request.getStartDate().isEqual(LocalDate.now())) {
            JDomUtils.addChild((Element)root, (String)"msgType", (String)"AMH942");
            JDomUtils.addChild((Element)root, (String)"startDate", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)root, (String)"endDate", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        } else {
            long dayOff = ChronoUnit.DAYS.between(request.getStartDate(), request.getEndDate());
            if (dayOff > 6L) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u67e5\u8be2\u65f6\u95f4\u95f4\u96947\u5929\u5185\u7684\u660e\u7ec6", (String)"DetailImpl_5", (String)"ebg-aqap-banks-citic-amh", (Object[])new Object[0]));
            }
            JDomUtils.addChild((Element)root, (String)"startDate", (String)request.getStartDate().plusDays(1L).format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)root, (String)"endDate", (String)request.getEndDate().plusDays(1L).format(DateTimeFormatter.ofPattern("yyyyMMdd")));
            JDomUtils.addChild((Element)root, (String)"msgType", (String)"AMH940");
        }
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)root, (String)encoding);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        String accno = request.getHeader().getAcnt().getAccNo();
        String status = root.getChildText("status");
        String statusText = root.getChildText("statusText");
        if (!"AAAAAAA".equalsIgnoreCase(status)) {
            if ("PBRA001".equalsIgnoreCase(status)) {
                this.setLastPage(true);
                return new EBBankDetailResponse(detailList);
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u8fd4\u56de\u975e\u6210\u529f\u4ea4\u6613\u7801\u3002\u94f6\u884c\u8fd4\u56de:%1$s,%2$s", (String)"DetailImpl_4", (String)"ebg-aqap-banks-citic-amh", (Object[])new Object[0]), status, statusText));
        }
        int totalRecords = Integer.parseInt(root.getChildText("totalNum"));
        int intPageTag = Integer.parseInt(this.getCurrentPage());
        if (totalRecords == 0 || intPageTag + 10 - 1 >= totalRecords) {
            this.setLastPage(true);
        } else {
            this.setCurrentPage(intPageTag + 10);
        }
        Element list = root.getChild("list");
        List rows = list.getChildren("row");
        for (int i = 0; i < rows.size(); ++i) {
            DetailInfo detail = new DetailInfo();
            Element row = (Element)rows.get(i);
            String refNum = row.getChildText("refNum");
            String cryType = row.getChildText("cryType");
            String foreignDCFlag = row.getChildText("foreignDCFlag");
            String tranAmount = ParserUtils.getUnNullElementTextValue((Element)row, (String)"tranAmt", (String)ResManager.loadKDString((String)"\u4ea4\u6613\u91d1\u989d", (String)"DetailImpl_2", (String)"ebg-aqap-banks-citic-amh", (Object[])new Object[0]));
            String valueDate = row.getChildText("valueDate");
            String memo = row.getChildText("memo");
            String intorTranSenum = row.getChildText("intorTranSenum");
            detail.setAccNo(accno);
            detail.setOppAccNo("");
            detail.setCurrency(cryType);
            if ("D".equals(foreignDCFlag)) {
                detail.setDebitAmount(new BigDecimal(tranAmount));
                detail.setCreditAmount(new BigDecimal("0.00"));
            } else {
                if (!"C".equals(foreignDCFlag)) continue;
                detail.setDebitAmount(new BigDecimal("0.00"));
                detail.setCreditAmount(new BigDecimal(tranAmount));
            }
            LocalDateTime transTime = LocalDateTime.parse(valueDate + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            detail.setTransTime(transTime);
            detail.setTransDate(LocalDate.parse(valueDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
            detail.setPayBankDetailSeqID(refNum);
            DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)refNum);
            detail.setExplanation(memo);
            String finalBalance = row.getChildText("finalBalance");
            if (!StringUtils.isEmpty((String)finalBalance)) {
                detail.setBalance(new BigDecimal(finalBalance));
            }
            detail.setBankDetailNo(intorTranSenum);
            String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
            detail.setJsonMap(jsonStr);
            detailList.add(detail);
        }
        return new EBBankDetailResponse(detailList);
    }

    public String getDeveloper() {
        return "sk";
    }

    public String getBizCode() {
        return "DLMTCQRY";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6d77\u5916\u8d26\u6237\u67e5\u8be2\u2014\u5f52\u96c6\u8d26\u5355\u67e5\u8be2", (String)"DetailImpl_6", (String)"ebg-aqap-banks-citic-amh", (Object[])new Object[0]);
    }

    public boolean isSupportPage() {
        return true;
    }
}

