/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.opa.services.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.opa.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.opa.utils.CMBCBankResponse;
import kd.ebg.aqap.banks.cmbc.opa.utils.CmbcPacker;
import kd.ebg.aqap.banks.cmbc.opa.utils.CmbcParser;
import kd.ebg.aqap.banks.cmbc.opa.utils.CmbcRequest;
import kd.ebg.aqap.banks.cmbc.opa.utils.OpenIDUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;

public class DetailImpl
extends AbstractDetailImpl
implements IHisDetail,
IDetail {
    private static final int DIFF_COUNT = 200;
    private static final String DC_DEBIT = "1";
    private static final String DC_CREDIT = "2";

    public EBBankDetailResponse detail(BankDetailRequest request) {
        return this.detailWithPage(request);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        return this.detailWithPage(request);
    }

    private EBBankDetailResponse detailWithPage(BankDetailRequest request) {
        ArrayList result = new ArrayList(1);
        this.setCurrentPage(DC_DEBIT);
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankDetailResponse detailResponse = this.doBiz(request);
            result.addAll(detailResponse.getDetails());
            int nextIndex = Integer.parseInt(this.getCurrentPage()) + 200;
            this.setCurrentPage(nextIndex);
        }
        return new EBBankDetailResponse(result);
    }

    public String pack(BankDetailRequest request) {
        CmbcRequest cmbcRequest = new CmbcRequest("account.transinfo.detail_query");
        HashMap<String, Object> busiParamMap = new HashMap<String, Object>();
        busiParamMap.put("acct_no", request.getAcnt().getAccNo());
        busiParamMap.put("date_from", request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        busiParamMap.put("date_to", request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        busiParamMap.put("start_index", this.getCurrentPage());
        busiParamMap.put("end_index", String.valueOf(Integer.valueOf(this.getCurrentPage()) + 200));
        busiParamMap.put("service_group", BankBusinessConfig.getCmbcServiceGroup());
        busiParamMap.put("open_id", OpenIDUtil.getOpenId(request.getAcnt().getAccNo()));
        cmbcRequest.setBusiParamMap(busiParamMap);
        return CmbcPacker.prepareParams(cmbcRequest);
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        Map responseMap = (Map)JSON.parseObject((String)responseStr, Map.class);
        CMBCBankResponse bankResponse = CmbcParser.getBankResponse(responseMap);
        if ("false".equals(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)bankResponse.getResponseMessage());
        }
        JSONObject busiJson = JSONObject.parseObject((String)bankResponse.getResponseBusi());
        int currentCount = busiJson.getIntValue("item_num");
        if (currentCount < 200) {
            this.setLastPage(true);
        } else {
            int totalCount = busiJson.getIntValue("total_num");
            int currentIndex = Integer.parseInt(this.getCurrentPage());
            if (currentIndex + 200 - 1 >= totalCount) {
                this.setLastPage(true);
            }
        }
        JSONArray detailJson = busiJson.getJSONArray("result_list");
        int count = detailJson == null ? 0 : detailJson.size();
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        HashMap<String, String> currencyMap = new HashMap<String, String>();
        for (int i = 0; i < count; ++i) {
            JSONObject obj = detailJson.getJSONObject(i);
            String dc = obj.getString("dc_flag");
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setBankDetailNo(obj.getString("trans_seq_no"));
            detailInfo.setAccNo(obj.getString("acct_no"));
            detailInfo.setAccName(obj.getString("acct_name"));
            String bankCurrency = obj.getString("currency");
            if (currencyMap.containsKey(bankCurrency)) {
                detailInfo.setCurrency((String)currencyMap.get(bankCurrency));
            } else {
                String isoCurrency = CurrencyUtils.convert2Iso((String)bankCurrency);
                currencyMap.put(bankCurrency, isoCurrency);
                detailInfo.setCurrency(isoCurrency);
            }
            detailInfo.setOppAccNo(obj.getString("cp_acct_no"));
            detailInfo.setOppAccName(obj.getString("cp_acct_name"));
            detailInfo.setOppBankName(obj.getString("cp_bank_name"));
            detailInfo.setDebitAmount(DC_DEBIT.equals(dc) ? obj.getBigDecimal("amount") : BigDecimal.ZERO);
            detailInfo.setCreditAmount(DC_CREDIT.equals(dc) ? obj.getBigDecimal("amount") : BigDecimal.ZERO);
            detailInfo.setBalance(obj.getBigDecimal("balance"));
            detailInfo.setExplanation(obj.getString("explain"));
            String date = obj.getString("enter_acct_date");
            detailInfo.setTransDate(LocalDate.parse(date, DateTimeFormatter.ofPattern("yyyy-MM-dd")));
            detailInfo.setTransTime(this.toLocalDateTime(obj.getString("timestamp"), date));
            String id = obj.getString("rec_seq");
            StringBuilder uniqueSeq = new StringBuilder();
            uniqueSeq.append(detailInfo.getAccNo()).append("|").append(date).append("|").append(id);
            detailInfo.setReceiptNo(uniqueSeq.toString());
            detailInfo.setJsonMap(obj.toJSONString());
            detailList.add(detailInfo);
        }
        return new EBBankDetailResponse(detailList);
    }

    private LocalDateTime toLocalDateTime(String timestamp, String date) {
        return LocalDateTime.parse(String.format("%s %s", date, timestamp), DateTimeFormatter.ofPattern("yyyy-MM-dd HHmmss"));
    }

    public String getDeveloper() {
        return "kylin";
    }

    public String getBizCode() {
        return "detail_query";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u67e5\u8be2", (String)"DetailImpl_0", (String)"ebg-aqap-banks-cmbc-opa", (Object[])new Object[0]);
    }
}

