/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.banklogin;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.control.events.ClickListener;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ButtonAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.aqap.common.framework.services.BankConfigService;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.constant.CertSource;
import kd.ebg.aqap.common.model.repository.UserCertRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.plugin.util.CertTypeUtil;
import kd.ebg.aqap.formplugin.plugin.util.ControlUtil;
import kd.ebg.aqap.formplugin.pojo.bizinfo.BankLoginInfo;
import kd.ebg.aqap.formplugin.repository.ConnectionsInfoRepository;
import kd.ebg.aqap.formplugin.repository.EbcBankAcntRepository;
import kd.ebg.aqap.formplugin.repository.EbcBankLoginRepository;
import kd.ebg.aqap.formplugin.repository.EbcBankVersionRepository;
import kd.ebg.aqap.formplugin.service.info.InfoService;
import kd.ebg.aqap.formplugin.util.ConfigProperty;
import kd.ebg.aqap.formplugin.util.FieldType;
import kd.ebg.aqap.formplugin.util.FieldUtil;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.aqap.formplugin.util.StringUtils;
import kd.ebg.egf.common.constant.ConfigInputType;
import kd.ebg.egf.common.framework.meta.MetaDataConfigType;
import kd.ebg.egf.common.framework.service.BankLoginConfigService;
import kd.ebg.egf.common.model.bank.ShowByFieldAndVal;
import kd.ebg.egf.common.repository.bank.login.BankLoginConfigRepository;
import kd.ebg.egf.common.repository.bank.login.BankLoginRelRepository;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;

public class BankLoginFromParentPlugin
extends AbstractBillPlugIn
implements ClickListener {
    static final String ENTITY_KEY = "aqap_bank_login_config";
    static final String ENTITY_WHITE_LIST = "aqap_white_list";
    List<BankLoginInfo> myBankLoginInfoList = new ArrayList<BankLoginInfo>(16);
    public static final String HIDD_PREX = "hidd_";
    static final String CONTAINER_KEY_CONTAINER = "conentpanel";
    InfoService infoService = (InfoService)SpringContextUtil.getBean(InfoService.class);
    EbcBankLoginRepository ebcBankLoginRepository = (EbcBankLoginRepository)SpringContextUtil.getBean(EbcBankLoginRepository.class);
    EbcBankVersionRepository ebcBankVersionRepository = (EbcBankVersionRepository)SpringContextUtil.getBean(EbcBankVersionRepository.class);
    BankLoginConfigService bankLoginConfigService = (BankLoginConfigService)SpringContextUtil.getBean(BankLoginConfigService.class);
    UserCertRepository userCertRepository = (UserCertRepository)SpringContextUtil.getBean(UserCertRepository.class);
    BankLoginConfigRepository bankLoginConfigRepository = (BankLoginConfigRepository)SpringContextUtil.getBean(BankLoginConfigRepository.class);
    BankLoginRelRepository bankLoginRelRepository = (BankLoginRelRepository)SpringContextUtil.getBean(BankLoginRelRepository.class);
    EbcBankAcntRepository ebcBankAcntRepository = (EbcBankAcntRepository)SpringContextUtil.getBean(EbcBankAcntRepository.class);
    BankConfigService bankConfigService = (BankConfigService)SpringContextUtil.getBean(BankConfigService.class);
    static final String pdMask = "******";
    static final String cacheKeyPre = "password_";

    void showCmbOpaCloudType(String bankVersion) {
        if ("CMB_OPA".equalsIgnoreCase(bankVersion)) {
            this.getModel().getDataEntity().set("CLOUD_TYPE", (Object)this.bankConfigService.getCmbOpaCloudTypeName());
        } else if ("CMB_ECNY".equalsIgnoreCase(bankVersion)) {
            this.getModel().getDataEntity().set("CLOUD_TYPE", (Object)this.bankConfigService.getCmbEcnyCloudTypeName());
        } else if ("KDCBS_DC".equalsIgnoreCase(bankVersion)) {
            this.getModel().getDataEntity().set("CLOUD_TYPE", (Object)this.bankConfigService.getCloudTypeName("KDCBS_DC"));
        }
    }

    public void setFieldShowOrHide() {
        String typeName;
        String bankVersion = this.getModel().getDataEntity().getString("group.number");
        DynamicObject[] dynamicObjects = this.ebcBankLoginRepository.getEnableBankLoginByBankVersionID(bankVersion);
        boolean notShowFlex = dynamicObjects == null || dynamicObjects.length == 0 || dynamicObjects.length == 1 && ((String)this.getModel().getValue("number")).equals(dynamicObjects[0].getString("number"));
        this.getView().setVisible(Boolean.valueOf(!notShowFlex), new String[]{MetaDataConfigType.EXCLUSIVE_CONFIG.getName()});
        if (!notShowFlex) {
            String isExclusive = "";
            try {
                isExclusive = (String)this.getModel().getValue("exclusive");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.getView().setVisible(Boolean.valueOf("true".equals(isExclusive)), new String[]{"business_type", "master_number"});
        }
        HashMap data = new HashMap();
        ArrayList<String> collapsibleFields = new ArrayList<String>(16);
        collapsibleFields.add("business_type");
        collapsibleFields.add("master_number");
        collapsibleFields.add("exclusive");
        data.put("cf", collapsibleFields);
        this.getView().updateControlMetadata(MetaDataConfigType.EXCLUSIVE_CONFIG.getName(), data);
        List<BankLoginInfo> bankLoginInfos = this.getBankLoginInfoList(bankVersion);
        List<Object> newBankLoginInfos = new ArrayList<BankLoginInfo>(16);
        newBankLoginInfos.addAll(bankLoginInfos);
        newBankLoginInfos = newBankLoginInfos.stream().filter(b -> b.getShowByFieldAndVal() != null).collect(Collectors.toList());
        if (newBankLoginInfos != null) {
            for (BankLoginInfo bankLoginInfo : newBankLoginInfos) {
                String val = "";
                try {
                    String[] filters;
                    boolean showResult;
                    ShowByFieldAndVal showByFieldAndVal = bankLoginInfo.getShowByFieldAndVal();
                    val = (String)this.getModel().getValue(showByFieldAndVal.getFieldName());
                    String showVal = showByFieldAndVal.getFieldVal();
                    if (showVal.startsWith("!")) {
                        showResult = !val.equals(showVal = showVal.replaceFirst("!", ""));
                    } else if (showVal.contains("'||'")) {
                        filters = showVal.split("'\\|\\|'");
                        showResult = this.getOrValue(filters, val);
                    } else if (showVal.contains("'&&'")) {
                        filters = showVal.split("'&&'");
                        showResult = this.getAndValue(filters, val);
                    } else {
                        showResult = val.equals(showVal);
                    }
                    this.getView().setVisible(Boolean.valueOf(showResult), new String[]{bankLoginInfo.getBankConfigId()});
                    if (!"upload".equalsIgnoreCase(bankLoginInfo.getInputType()) && !"password".equalsIgnoreCase(bankLoginInfo.getInputType()) && !"text".equalsIgnoreCase(bankLoginInfo.getInputType())) continue;
                    this.getView().getPageCache().put(HIDD_PREX + bankLoginInfo.getBankConfigId(), String.valueOf(!showResult));
                    this.getView().setVisible(Boolean.valueOf(showResult), new String[]{"btn_" + bankLoginInfo.getBankConfigId()});
                }
                catch (Exception exception) {}
            }
        }
        if ("CMB_OPA".equals(bankVersion)) {
            typeName = this.bankConfigService.getCmbOpaCloudTypeName();
            this.getView().setVisible(Boolean.valueOf(!BankPropertyConfig.CLOUD_TYPE_KEY_Y.loadKDString().equals(typeName)), new String[]{MetaDataConfigType.PGP_CONFIG.getName()});
        } else if ("CMB_ECNY".equals(bankVersion)) {
            typeName = this.bankConfigService.getCmbEcnyCloudTypeName();
            this.getView().setVisible(Boolean.valueOf(!BankPropertyConfig.CLOUD_TYPE_KEY_Y.loadKDString().equals(typeName)), new String[]{MetaDataConfigType.PGP_CONFIG.getName()});
        }
        if ("KDCBS_DC".equals(bankVersion)) {
            typeName = this.bankConfigService.getCloudTypeName("KDCBS_DC");
            this.getView().setVisible(Boolean.valueOf(!BankPropertyConfig.CLOUD_TYPE_KEY_F.loadKDString().equals(typeName)), new String[]{MetaDataConfigType.BANKS_CONFIG.getName()});
        }
        this.getView().setVisible(Boolean.valueOf(((ConnectionsInfoRepository)SpringContextUtil.getBean(ConnectionsInfoRepository.class)).exitsByGroupNumber(this.getBankVersion())), new String[]{"baritemap1"});
    }

    boolean getOrValue(String[] filters, String val) {
        for (int i = 0; i < filters.length; ++i) {
            boolean result = val.equals(filters[i]);
            if (!result) continue;
            return true;
        }
        return false;
    }

    boolean getAndValue(String[] filters, String val) {
        for (int i = 0; i < filters.length; ++i) {
            boolean result = val.equals(filters[i]);
            if (result) continue;
            return false;
        }
        return true;
    }

    List<BankLoginInfo> getBankLoginInfoList(String bankVersion) {
        if (!CollectionUtil.isEmpty(this.myBankLoginInfoList)) {
            return this.myBankLoginInfoList;
        }
        List<BankLoginInfo> bankLoginInfos = this.infoService.getBankLoginInfoList(bankVersion);
        if (CollectionUtil.isEmpty(bankLoginInfos)) {
            return null;
        }
        this.myBankLoginInfoList = bankLoginInfos.stream().filter(c -> !"receipt".equalsIgnoreCase(MetaDataConfigType.getTypeByName((String)c.getType()))).collect(Collectors.toList());
        return this.myBankLoginInfoList;
    }

    public String getBankVersion() {
        if (this.getView() == null) {
            return "";
        }
        BaseShowParameter baseShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        JSONObject jsonObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("tree_parent_id");
        if (jsonObject == null) {
            Long bankLoginid = (Long)baseShowParameter.getPkId();
            if (bankLoginid != null) {
                return this.ebcBankLoginRepository.getBankVersionByBankLoginID(bankLoginid);
            }
            return (String)baseShowParameter.getCustomParam("bankVersion");
        }
        return this.getBankVersion(jsonObject);
    }

    public String getBankVersion(JSONObject jsonObject) {
        String groupKey = jsonObject.getString("value");
        return this.ebcBankVersionRepository.getBankVersionByID(groupKey);
    }

    List<String> getCanSelectBankLoginIDs() {
        String businessType;
        ArrayList<String> result = new ArrayList<String>();
        String bankVersion = this.getBankVersion();
        List<String> bankLoginIDs = this.ebcBankLoginRepository.getEnableMasterBankLoginIDsByBankVersionID(bankVersion);
        if (CollectionUtil.isEmpty(bankLoginIDs)) {
            return result;
        }
        String bankLoginID = bankVersion + "-" + this.getMaxVersionValue(bankVersion);
        bankLoginIDs.remove(bankLoginID);
        try {
            businessType = (String)this.getModel().getValue("business_type");
        }
        catch (Exception ex) {
            return bankLoginIDs;
        }
        DynamicObjectCollection dynamicObjects = this.bankLoginRelRepository.findByConfigTypeAndMasterNumberIn(businessType, bankLoginIDs);
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                if (dynamicObject.getString("exclusive_number").equals(bankLoginID)) continue;
                bankLoginIDs.remove(dynamicObject.getString("master_number"));
            }
        }
        return bankLoginIDs;
    }

    String getExclusive() {
        String exclusive = "";
        try {
            exclusive = (String)this.getModel().getValue("exclusive");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exclusive;
    }

    public String getMaxVersionValue(String bankVersion) {
        String result = this.getPageCache().get("maxVersionValue");
        if (!StringUtil.isNullOrEmpty(result)) {
            return result;
        }
        Long pkId = (Long)((BaseShowParameter)this.getView().getFormShowParameter()).getPkId();
        if (pkId == null) {
            Integer maxVersionValue = this.bankLoginConfigService.getMaxVersionValue(bankVersion, RequestContext.get().getTenantId());
            result = maxVersionValue + "";
        } else {
            result = this.ebcBankLoginRepository.getBankLoginNumberByID(pkId);
        }
        this.getPageCache().put("maxVersionValue", result);
        return result;
    }

    boolean isAddBankLoginRepeat() {
        String bankLoginID;
        DynamicObject bankLogin;
        String statusName = this.getView().getFormShowParameter().getStatus().name();
        return "ADDNEW".equalsIgnoreCase(statusName) && (bankLogin = this.ebcBankLoginRepository.getBankLoginByBankLoginID(bankLoginID = (String)this.getModel().getValue("number"))) != null;
    }

    void deleteBankLogin(String bankLogin, String configType) {
        this.bankLoginConfigRepository.delete(bankLogin, configType);
        this.bankLoginRelRepository.deleteByExclusiveNumber(bankLogin);
    }

    void savebankLoginRel(String bankLogin) {
        String business_type = (String)this.getModel().getValue("business_type");
        String master_number = (String)this.getModel().getValue("master_number");
        String[] masters = master_number.split(",");
        for (int i = 0; i < masters.length; ++i) {
            if (!StringUtils.isNotEmpty(masters[i])) continue;
            this.bankLoginRelRepository.save(masters[i], business_type, bankLogin);
        }
    }

    DynamicObject[] getCerDatas() {
        String bankLoginID = (String)this.getModel().getValue("number");
        String customID = RequestContext.get().getTenantId();
        return this.userCertRepository.getBankLoginCerDatas(bankLoginID, customID);
    }

    Map<String, DynamicObject> getCerDataMap() {
        DynamicObject[] cerDatas = this.getCerDatas();
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        if (cerDatas != null && cerDatas.length > 0) {
            for (DynamicObject cerData : cerDatas) {
                map.put((String)cerData.get("bank_config_id"), cerData);
            }
        }
        return map;
    }

    OperationResult addCer(BankLoginInfo bankLoginInfo, String bankVersion, String bankLogin, String customID, CertInfo certInfo, String fileName) {
        certInfo.setCertType(CertTypeUtil.getCertType(bankVersion) + "");
        certInfo.setCertSource(CertSource.SYSTEM.getSource() + "");
        String bankConfigName = bankLoginInfo.getBankConfigName();
        if (bankLoginInfo.getMlBankConfigName() != null) {
            bankConfigName = JsonUtil.toJsonLine((Object)bankLoginInfo.getMlBankConfigName());
        }
        return this.userCertRepository.addBankLoginCert(bankLoginInfo.getBankConfigId(), bankConfigName, bankVersion, bankLogin, customID, certInfo.getFileContent(), fileName, certInfo.isAlert(), certInfo.getAlertDay(), certInfo.getExpireTime(), certInfo.getCertPassword(), certInfo.getCertSource(), certInfo.getCertType());
    }

    void updateCer(DynamicObject cerData, BankLoginInfo bankLoginInfo, String bankVersion, String bankLogin, String customID, CertInfo certInfo, String fileName) {
        certInfo.setCertType(CertTypeUtil.getCertType(bankVersion) + "");
        certInfo.setCertSource(CertSource.SYSTEM.getSource() + "");
        certInfo.setAlert(cerData.getBoolean("is_alert"));
        certInfo.setAlertDay(cerData.getString("alert_day"));
        String bankConfigName = bankLoginInfo.getBankConfigName();
        if (bankLoginInfo.getMlBankConfigName() != null) {
            bankConfigName = JsonUtil.toJsonLine((Object)bankLoginInfo.getMlBankConfigName());
        }
        this.userCertRepository.updateBankLoginCert(cerData, bankLoginInfo.getBankConfigId(), bankConfigName, bankVersion, bankLogin, customID, certInfo.getFileContent(), fileName, certInfo.isAlert(), certInfo.getAlertDay(), certInfo.getExpireTime(), certInfo.getCertPassword(), certInfo.getCertSource(), certInfo.getCertType());
    }

    public FlexPanelAp createFlexPanelAp(String type) {
        FlexPanelAp flex = new FlexPanelAp();
        flex.setKey(type);
        flex.setCollapsible(true);
        flex.setName(new LocaleString("default".equalsIgnoreCase(type) ? ResManager.loadKDString((String)"\u57fa\u7840\u914d\u7f6e", (String)"BankLoginFormPlugin_5", (String)"ebg-aqap-formplugin", (Object[])new Object[0]) : MetaDataConfigType.getDescByName((String)type)));
        flex.setGrow(1);
        flex.setShrink(0);
        Style style = new Style();
        Border border = new Border();
        border.setTop("10px #E2E7EF solid");
        style.setBorder(border);
        flex.setStyle(style);
        if (!StringUtils.isEmpty(MetaDataConfigType.getRemarkByName((String)type))) {
            Tips tips = new Tips();
            tips.setType("text");
            tips.setTitle(new LocaleString(ResManager.loadKDString((String)"\u8bf4\u660e", (String)"BankLoginFormPlugin_6", (String)"ebg-aqap-formplugin", (Object[])new Object[0])));
            String remark = MetaDataConfigType.getRemarkByName((String)type);
            tips.setContent(new LocaleString(remark));
            tips.setLink(false);
            flex.setCtlTips(tips);
        }
        return flex;
    }

    public void addFieldsetPanelApItems(FlexPanelAp flex, List<BankLoginInfo> bankLoginInfos) {
        for (BankLoginInfo bankLoginInfo : bankLoginInfos) {
            FieldAp fieldAp;
            FieldAp fieldAp2;
            List<String> sourceNames;
            List<String> sourceVlues;
            boolean isPassword = false;
            String key = bankLoginInfo.getBankConfigId().toLowerCase(Locale.ENGLISH);
            String name = FieldUtil.getName(bankLoginInfo.getMlBankConfigName(), bankLoginInfo.getBankConfigName());
            String desc = FieldUtil.getDesc(bankLoginInfo.getMlDesc(), bankLoginInfo.getMlDescs(), bankLoginInfo.getDesc());
            if (ConfigInputType.SELECT.getInputType().equalsIgnoreCase(bankLoginInfo.getInputType())) {
                sourceVlues = bankLoginInfo.getSourceValues();
                sourceNames = FieldUtil.getSourceNames(bankLoginInfo.getMlSourceNames(), bankLoginInfo.getSourceNames());
                fieldAp2 = FieldUtil.createComboField(name, key, bankLoginInfo.isReadOnly(), !bankLoginInfo.isNullable(), desc, sourceVlues, sourceNames);
                fieldAp2.setHidden(bankLoginInfo.isHidden());
                flex.getItems().add(fieldAp2);
                continue;
            }
            if (ConfigInputType.MUL_SELECT.getInputType().equalsIgnoreCase(bankLoginInfo.getInputType())) {
                sourceVlues = bankLoginInfo.getSourceValues();
                sourceNames = FieldUtil.getSourceNames(bankLoginInfo.getMlSourceNames(), bankLoginInfo.getSourceNames());
                if ("master_number".equals(key)) {
                    sourceVlues.clear();
                    sourceNames.clear();
                    List<String> sources = this.getCanSelectBankLoginIDs();
                    sourceVlues.addAll(sources);
                    sourceNames.addAll(sources);
                }
                fieldAp2 = FieldUtil.createMulComboField(name, key, bankLoginInfo.isReadOnly(), !bankLoginInfo.isNullable(), desc, sourceVlues, sourceNames);
                fieldAp2.setHidden(bankLoginInfo.isHidden());
                flex.getItems().add(fieldAp2);
                continue;
            }
            if (ConfigInputType.SWITCH.getInputType().equals(bankLoginInfo.getInputType())) {
                fieldAp = FieldUtil.createDynamicFieldBase(name, key, !bankLoginInfo.isNullable(), bankLoginInfo.isReadOnly(), FieldType.SWITCH, desc);
                fieldAp.setHidden(bankLoginInfo.isHidden());
                flex.getItems().add(fieldAp);
                continue;
            }
            if (ConfigInputType.INTEGER.getInputType().equalsIgnoreCase(bankLoginInfo.getInputType())) {
                fieldAp = FieldUtil.createDynamicFieldBase(name, key, !bankLoginInfo.isNullable(), bankLoginInfo.isReadOnly(), FieldType.INTEGER, desc);
                fieldAp.setHidden(bankLoginInfo.isHidden());
                FieldUtil.setIntegerFieldApDataScope(fieldAp, bankLoginInfo.getMinValueNum(), bankLoginInfo.getMaxValueNum());
                flex.getItems().add(fieldAp);
                continue;
            }
            if (ConfigInputType.DATE.getInputType().equalsIgnoreCase(bankLoginInfo.getInputType())) {
                fieldAp = FieldUtil.createDynamicFieldBase(name, key, !bankLoginInfo.isNullable(), bankLoginInfo.isReadOnly(), FieldType.DATE, desc);
                fieldAp.setHidden(bankLoginInfo.isHidden());
                flex.getItems().add(fieldAp);
                continue;
            }
            if (ConfigInputType.DATE8.getInputType().equalsIgnoreCase(bankLoginInfo.getInputType())) {
                fieldAp = FieldUtil.createDynamicFieldBase(name, key, !bankLoginInfo.isNullable(), bankLoginInfo.isReadOnly(), FieldType.DATE8, desc);
                fieldAp.setHidden(bankLoginInfo.isHidden());
                flex.getItems().add(fieldAp);
                continue;
            }
            if (ConfigInputType.PASSWORD.getInputType().equalsIgnoreCase(bankLoginInfo.getInputType())) {
                isPassword = true;
                String cacheKey = this.getPwdCacheKey(key);
                if (this.getView().getPageCache().get(cacheKey) == null) {
                    this.getView().getPageCache().put(cacheKey, "");
                }
            } else if (ConfigInputType.TEXTAREA.getInputType().equalsIgnoreCase(bankLoginInfo.getInputType())) {
                fieldAp = FieldUtil.createDynamicFieldBase(name, key, !bankLoginInfo.isNullable(), bankLoginInfo.isReadOnly(), FieldType.TEXTAREA, desc);
                fieldAp.setHidden(bankLoginInfo.isHidden());
                flex.getItems().add(fieldAp);
                continue;
            }
            if (bankLoginInfo.getBankConfigId().equalsIgnoreCase("ip") || bankLoginInfo.getBankConfigId().equalsIgnoreCase("front_proxy_ip")) {
                fieldAp = FieldUtil.createBasedataField(name, key, !bankLoginInfo.isNullable(), bankLoginInfo.isReadOnly(), bankLoginInfo.getBankConfigValue(), isPassword);
                FieldUtil.setFieldApTips(fieldAp, desc);
                fieldAp.setHidden(bankLoginInfo.isHidden());
                flex.getItems().add(fieldAp);
                continue;
            }
            ConfigProperty configProperty = new ConfigProperty();
            configProperty.setName(name);
            configProperty.setKey(key);
            configProperty.setMustInput(!bankLoginInfo.isNullable());
            configProperty.setReadOnly(bankLoginInfo.isReadOnly());
            configProperty.setDefValue(bankLoginInfo.getBankConfigValue());
            configProperty.setPassword(isPassword);
            configProperty.setHidden(false);
            FieldAp fieldAp3 = FieldUtil.createTextField(configProperty);
            fieldAp3.setHidden(bankLoginInfo.isHidden());
            if ("upload".equalsIgnoreCase(bankLoginInfo.getInputType())) {
                fieldAp3.setLock("new,edit,view,submit,audit");
            }
            FieldUtil.setFieldApTips(fieldAp3, desc);
            FieldUtil.setFieldApMaxLength((TextField)fieldAp3.getField(), bankLoginInfo.getMaxLength());
            flex.getItems().add(fieldAp3);
            if (!"upload".equalsIgnoreCase(bankLoginInfo.getInputType())) continue;
            ButtonAp buttonAp = FieldUtil.createButtonAp(key);
            flex.getItems().add(buttonAp);
        }
    }

    public String getPwdCacheKey(String key) {
        StringBuilder sb = new StringBuilder();
        sb.append(cacheKeyPre).append(key.toLowerCase(Locale.ENGLISH));
        return sb.toString();
    }

    void registDynamicProps(MainEntityType newMainType) {
        List<BankLoginInfo> bankLoginInfos = this.getBankLoginInfoList(this.getBankVersion());
        if (CollectionUtil.isEmpty(bankLoginInfos)) {
            return;
        }
        bankLoginInfos.stream().forEach(bankLoginInfo -> {
            String key = bankLoginInfo.getBankConfigId().toLowerCase(Locale.ENGLISH);
            if (ConfigInputType.SWITCH.getInputType().equals(bankLoginInfo.getInputType())) {
                TextProp prop = new TextProp();
                prop.setName(key);
                prop.setDisplayName(new LocaleString(bankLoginInfo.getBankConfigName()));
                prop.setDbIgnore(true);
                prop.setAlias("");
                newMainType.registerSimpleProperty((DynamicSimpleProperty)prop);
            } else if (ConfigInputType.DATE.getInputType().equals(bankLoginInfo.getInputType()) || ConfigInputType.DATE8.getInputType().equals(bankLoginInfo.getInputType())) {
                DateProp prop = new DateProp();
                prop.setName(key);
                prop.setDisplayName(new LocaleString(bankLoginInfo.getBankConfigName()));
                prop.setDbIgnore(true);
                prop.setAlias("");
                newMainType.registerSimpleProperty((DynamicSimpleProperty)prop);
            } else if (key.equalsIgnoreCase("ip")) {
                this.buildBaseDataProp(newMainType, key, bankLoginInfo.getBankConfigName());
                HashMap<String, Serializable> prop = new HashMap<String, Serializable>(2);
                prop.put("qan", Boolean.valueOf(false));
                HashMap<String, Boolean> editor = new HashMap<String, Boolean>(1);
                editor.put("qan", false);
                prop.put("item", editor);
                this.getView().updateControlMetadata("ip", prop);
            } else if (key.equalsIgnoreCase("front_proxy_ip")) {
                this.buildBaseDataProp(newMainType, key, bankLoginInfo.getBankConfigName());
                HashMap<String, Serializable> prop = new HashMap<String, Serializable>(2);
                prop.put("qan", Boolean.valueOf(false));
                HashMap<String, Boolean> editor = new HashMap<String, Boolean>(1);
                editor.put("qan", false);
                prop.put("item", editor);
                this.getView().updateControlMetadata("front_proxy_ip", prop);
            } else {
                String inputType = bankLoginInfo.getInputType();
                String bankConfigId = key;
                TextProp textProp = ControlUtil.buildTextPorp(bankConfigId, bankLoginInfo.getBankConfigName());
                if (ConfigInputType.PASSWORD.getInputType().equalsIgnoreCase(inputType)) {
                    textProp.setPassword(true);
                }
                newMainType.registerSimpleProperty((DynamicSimpleProperty)textProp);
            }
        });
    }

    private void buildBaseDataProp(MainEntityType mainEntityType, String key, String name) {
        BasedataProp basedataProp = new BasedataProp();
        basedataProp.setName(key);
        basedataProp.setDisplayName(new LocaleString(name));
        basedataProp.setDbIgnore(true);
        basedataProp.setAlias("");
        basedataProp.setBaseEntityId(ENTITY_WHITE_LIST);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)ENTITY_WHITE_LIST);
        basedataProp.setComplexType((IDataEntityType)dataEntityType);
        basedataProp.setDisplayProp("number");
        String key_ref = key + "_id";
        DynamicSimpleProperty refIdProp = basedataProp.createRefIDProp();
        refIdProp.setPrimaryKey(false);
        refIdProp.setName(key_ref);
        refIdProp.setDbIgnore(true);
        basedataProp.setRefIdProp((IDataEntityProperty)refIdProp);
        basedataProp.setRefIdPropName(key_ref);
        mainEntityType.registerComplexProperty((DynamicComplexProperty)basedataProp);
        mainEntityType.addProperty((DynamicProperty)refIdProp);
    }
}

