/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.cacert;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Button;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.common.model.constant.CertSource;
import kd.ebg.aqap.common.model.constant.CertTypeEnum;
import kd.ebg.aqap.common.model.repository.CertRepository;
import kd.ebg.aqap.common.utils.CMBCCertificateUtil;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.util.StringUtils;
import kd.ebg.egf.common.constant.CertType;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.collect.CollectionUtil;

public class BankPlateFormCertPlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    private static String ENTITY_KEY = "aqap_platform_cert_page";
    private static String ENTITY_KEY_BASE = "aqap_bd_cert";
    private String PRIVATE_CERTINFO = "eb_private_certInfo";
    private String PUBLIC_CERTINFO = "eb_public_certInfo";
    private String PRIVATE_KEY = "private_key";
    private String PUBLIC_KEY = "public_key";
    private String PLATEFORM_PRIVATE_CERTINFO = "plateForm_private_certInfo";
    private String PLATEFORM_PUBLIC_CERTINFO = "plateForm_public_certInfo";
    private CertRepository certRepository = (CertRepository)SpringContextUtil.getBean(CertRepository.class);

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        if ("bank_version".equalsIgnoreCase(fieldKey)) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
            ArrayList<String> bankVersionIdList = new ArrayList<String>(0);
            bankVersionIdList.add("CMB_OPA");
            bankVersionIdList.add("CMB_ECNY");
            bankVersionIdList.add("PAB_OPA");
            bankVersionIdList.add("GDB_OPB");
            bankVersionIdList.add("GDB_OPA");
            bankVersionIdList.add("CMBC_OPA");
            bankVersionIdList.add("BOCOM_OPA");
            bankVersionIdList.add("CMBC_OPENBANK");
            bankVersionIdList.add("BOC_OPA");
            bankVersionIdList.add("CIB_OPA");
            QFilter qFilter = new QFilter("number", "in", bankVersionIdList);
            qFilters.add(qFilter);
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().setQFilters(qFilters);
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit bankVersionFieldEdit;
        Button publicViewButton;
        Button privateViewButton;
        Button publicUploadButton;
        Button privateUploadButton;
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getView().getControl("tbmain");
        if (toolbar != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
        if ((privateUploadButton = (Button)this.getView().getControl("button_private_upload")) != null) {
            privateUploadButton.addClickListener((ClickListener)this);
        }
        if ((publicUploadButton = (Button)this.getView().getControl("button_public_upload")) != null) {
            publicUploadButton.addClickListener((ClickListener)this);
        }
        if ((privateViewButton = (Button)this.getView().getControl("button_private_view")) != null) {
            privateViewButton.addClickListener((ClickListener)this);
        }
        if ((publicViewButton = (Button)this.getView().getControl("button_public_view")) != null) {
            publicViewButton.addClickListener((ClickListener)this);
        }
        if ((bankVersionFieldEdit = (BasedataEdit)this.getView().getControl("bank_version")) != null) {
            bankVersionFieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    private boolean checkBankVer() {
        Object bank = this.getModel().getValue("bank_version");
        if (bank == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u94f6\u884c\u7248\u672c", (String)"BankPlateFormCertPlugin_14", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals("upload_private_cert", formOperate.getOperateKey())) {
            if (this.checkBankVer()) {
                this.showUploadPage(ResManager.loadKDString((String)"\u4e0a\u4f20\u79c1\u94a5\u8bc1\u4e66", (String)"BankPlateFormCertPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), this.PRIVATE_KEY, true);
            }
        } else if (StringUtils.equals("upload_public_cert", formOperate.getOperateKey())) {
            if (this.checkBankVer()) {
                this.showUploadPage(ResManager.loadKDString((String)"\u4e0a\u4f20\u516c\u94a5\u8bc1\u4e66", (String)"BankPlateFormCertPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), this.PUBLIC_KEY, true);
            }
        } else if (StringUtils.equals("view_private_cert", formOperate.getOperateKey())) {
            this.showUploadPage(ResManager.loadKDString((String)"\u67e5\u770b\u79c1\u94a5\u8bc1\u4e66", (String)"BankPlateFormCertPlugin_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), this.PRIVATE_KEY, false);
        } else if (StringUtils.equals("view_public_cert", formOperate.getOperateKey())) {
            this.showUploadPage(ResManager.loadKDString((String)"\u67e5\u770b\u516c\u94a5\u8bc1\u4e66", (String)"BankPlateFormCertPlugin_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), this.PUBLIC_KEY, false);
        } else if (StringUtils.equals("save", formOperate.getOperateKey())) {
            String publicKeyName;
            String statusName = ((BaseShowParameter)this.getView().getFormShowParameter()).getBillStatus().name();
            QFilter[] qFilters = new QFilter[]{new QFilter("bank_version.number", "=", (Object)this.getModel().getDataEntity().getString("bank_version.number"))};
            DynamicObjectCollection bankBusinessDatas = QueryServiceHelper.query((String)ENTITY_KEY, (String)"", (QFilter[])qFilters);
            if ("ADDNEW".equalsIgnoreCase(statusName) && CollectionUtil.isNotEmpty((Collection)bankBusinessDatas)) {
                this.cancel(ResManager.loadKDString((String)"\u5f53\u524d\u94f6\u884c\u7248\u672c\u5df2\u7ecf\u5b58\u5728\u5e73\u53f0\u8bc1\u4e66\u8bb0\u5f55\uff0c\u8bf7\u52ff\u91cd\u590d\u65b0\u589e\u3002", (String)"BankPlateFormCertPlugin_4", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), args);
                return;
            }
            String privateKeyName = (String)this.getModel().getValue("private_key");
            String bankVersionID = this.getModel().getDataEntity().getString("bank_version.number");
            String bankVersionName = this.getModel().getDataEntity().getString("bank_version.name");
            if (StringUtils.isEmpty(privateKeyName)) {
                if ("PAB_OPA".equalsIgnoreCase(bankVersionID)) {
                    this.cancel(String.format(ResManager.loadKDString((String)"%s\u79c1\u94a5\u8bc1\u4e66\u5fc5\u586b\u3002", (String)"BankPlateFormCertPlugin_11", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), bankVersionName), args);
                    return;
                }
                if ("CMB_OPA".equalsIgnoreCase(bankVersionID) && !"private".equalsIgnoreCase(System.getProperty("ebg.server.type"))) {
                    this.cancel(String.format(ResManager.loadKDString((String)"SAAS\u6a21\u5f0f%s\u79c1\u94a5\u8bc1\u4e66\uff08\u5e73\u53f0\u7ea7\u522bRSA\u79c1\u94a5\uff09\u5fc5\u586b\u3002", (String)"BankPlateFormCertPlugin_12", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), bankVersionName), args);
                    return;
                }
                if ("CMB_ECNY".equalsIgnoreCase(bankVersionID) && !"private".equalsIgnoreCase(System.getProperty("ebg.server.type"))) {
                    this.cancel(String.format(ResManager.loadKDString((String)"SAAS\u6a21\u5f0f%s\u79c1\u94a5\u8bc1\u4e66\uff08\u5e73\u53f0\u7ea7\u522bRSA\u79c1\u94a5\uff09\u5fc5\u586b\u3002", (String)"BankPlateFormCertPlugin_12", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), bankVersionName), args);
                    return;
                }
            }
            if (StringUtils.isEmpty(publicKeyName = (String)this.getModel().getValue("public_key")) && ("CMB_OPA".equalsIgnoreCase(bankVersionID) || "CMB_ECNY".equalsIgnoreCase(bankVersionID))) {
                this.cancel(String.format(ResManager.loadKDString((String)"%s\u516c\u94a5\u8bc1\u4e66\uff08\u94f6\u884c\u516c\u94a5\u8bc1\u4e66\uff09\u5fc5\u586b\u3002", (String)"BankPlateFormCertPlugin_13", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), bankVersionName), args);
                return;
            }
        }
        this.getModel().putContextVariable("updOrAdd_cancel", (Object)false);
    }

    void cancel(String message, BeforeDoOperationEventArgs args) {
        this.getView().showTipNotification(message);
        args.setCancel(true);
        this.getModel().putContextVariable("updOrAdd_cancel", (Object)true);
    }

    void showUploadPage(String pageCaption, String fieldKey, boolean isUpload) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("aqap_cert_parse");
        StyleCss style = new StyleCss();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("bankVersionID", (Object)this.getModel().getDataEntity().getString("bank_version.number"));
        if (!isUpload) {
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setCustomParam("type", (Object)CertType.PLATEFORM_CER.getType());
            showParameter.setCustomParam("bank_config_id", (Object)(this.PRIVATE_KEY.endsWith(fieldKey) ? this.PLATEFORM_PRIVATE_CERTINFO : this.PLATEFORM_PUBLIC_CERTINFO));
        }
        showParameter.getOpenStyle().setInlineStyleCss(style);
        showParameter.setCaption(pageCaption);
        showParameter.setCustomParam("fieldKey", (Object)fieldKey);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() != null) {
            CertInfo certInfo = (CertInfo)JSONObject.parseObject((String)((String)closedCallBackEvent.getReturnData()), CertInfo.class);
            if (this.PRIVATE_KEY.equalsIgnoreCase(closedCallBackEvent.getActionId())) {
                this.getPageCache().put(this.PRIVATE_CERTINFO, JSONObject.toJSONString((Object)certInfo));
                this.getModel().setValue(this.PRIVATE_KEY, (Object)certInfo.getFileName());
            } else if (this.PUBLIC_KEY.equalsIgnoreCase(closedCallBackEvent.getActionId())) {
                this.getPageCache().put(this.PUBLIC_CERTINFO, JSONObject.toJSONString((Object)certInfo));
                this.getModel().setValue(this.PUBLIC_KEY, (Object)certInfo.getFileName());
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (StringUtils.equals("bar_save", evt.getItemKey()) && !((Boolean)this.getModel().getContextVariable("updOrAdd_cancel")).booleanValue()) {
            String statusName = ((BaseShowParameter)this.getView().getFormShowParameter()).getBillStatus().name();
            String bankVersionID = this.getModel().getDataEntity().getString("bank_version.number");
            Map<String, DynamicObject> cerMap = this.getCerDataMap();
            if (this.getPageCache().get(this.PRIVATE_CERTINFO) != null) {
                MultiLangEnumBridge privateKeyBridge = new MultiLangEnumBridge("\u79c1\u94a5\u8bc1\u4e66", "BankPlateFormCertPlugin_9", "ebg-aqap-formplugin");
                if (cerMap.get(this.PLATEFORM_PRIVATE_CERTINFO) != null) {
                    this.updateCert(cerMap.get(this.PLATEFORM_PRIVATE_CERTINFO), this.PLATEFORM_PRIVATE_CERTINFO, JsonUtil.toJsonLine((Object)privateKeyBridge), bankVersionID, (CertInfo)JSONObject.parseObject((String)this.getPageCache().get(this.PRIVATE_CERTINFO), CertInfo.class));
                } else {
                    this.addCert(this.PLATEFORM_PRIVATE_CERTINFO, JsonUtil.toJsonLine((Object)privateKeyBridge), bankVersionID, (CertInfo)JSONObject.parseObject((String)this.getPageCache().get(this.PRIVATE_CERTINFO), CertInfo.class));
                }
            }
            if (this.getPageCache().get(this.PUBLIC_CERTINFO) != null) {
                MultiLangEnumBridge publicKeyBridge = new MultiLangEnumBridge("\u516c\u94a5\u8bc1\u4e66", "BankPlateFormCertPlugin_10", "ebg-aqap-formplugin");
                if (cerMap.get(this.PLATEFORM_PUBLIC_CERTINFO) != null) {
                    this.updateCert(cerMap.get(this.PLATEFORM_PUBLIC_CERTINFO), this.PLATEFORM_PUBLIC_CERTINFO, JsonUtil.toJsonLine((Object)publicKeyBridge), bankVersionID, (CertInfo)JSONObject.parseObject((String)this.getPageCache().get(this.PUBLIC_CERTINFO), CertInfo.class));
                } else {
                    this.addCert(this.PLATEFORM_PUBLIC_CERTINFO, JsonUtil.toJsonLine((Object)publicKeyBridge), bankVersionID, (CertInfo)JSONObject.parseObject((String)this.getPageCache().get(this.PUBLIC_CERTINFO), CertInfo.class));
                }
            }
            if ("CMBC_OPA".equals(bankVersionID) || "CIB_OPA".equals(bankVersionID)) {
                CMBCCertificateUtil.checkOrCreateFile((boolean)false);
            }
        }
    }

    Map<String, DynamicObject> getCerDataMap() {
        DynamicObject[] cerDatas = this.getCerDatas();
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        if (cerDatas != null && cerDatas.length > 0) {
            for (DynamicObject cerData : cerDatas) {
                map.put((String)cerData.get("bank_config_id"), cerData);
            }
        }
        return map;
    }

    DynamicObject[] getCerDatas() {
        String bankVersionID = this.getModel().getDataEntity().getString("bank_version.number");
        return this.certRepository.loadCertByTypeAndBankVersion(CertType.PLATEFORM_CER.getType(), bankVersionID);
    }

    void updateCert(DynamicObject cerData, String key, String name, String bankVersionID, CertInfo certInfo) {
        this.initEBContext();
        certInfo.setCertType(CertTypeEnum.PLATEFORM.getType() + "");
        certInfo.setCertSource(CertSource.SYSTEM.getSource() + "");
        certInfo.setAlert(cerData.getBoolean("is_alert"));
        certInfo.setAlertDay(cerData.getString("alert_day"));
        this.certRepository.updateCert(cerData, key, name, bankVersionID, certInfo, CertType.PLATEFORM_CER.getType());
        this.removeEBContext();
    }

    void addCert(String key, String name, String bankVersionID, CertInfo certInfo) {
        this.initEBContext();
        certInfo.setCertType(CertTypeEnum.PLATEFORM.getType() + "");
        certInfo.setCertSource(CertSource.SYSTEM.getSource() + "");
        this.certRepository.addCert(key, name, bankVersionID, certInfo, CertType.PLATEFORM_CER.getType());
        this.removeEBContext();
    }

    private void initEBContext() {
        EBContext ebContext = EBContext.getContext();
        if (ebContext == null) {
            ebContext = EBContext.builder().build();
            EBContext.setContext((EBContext)ebContext);
        }
        String formId = this.getView().getFormShowParameter().getFormId();
        ebContext.setFormId(formId);
    }

    private void removeEBContext() {
        EBContext.destroy();
    }
}

