/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.cacert;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.ebg.aqap.common.model.constant.CertSource;
import kd.ebg.aqap.common.model.constant.CertTypeEnum;
import kd.ebg.aqap.formplugin.ca.bean.KeyStoreInfo;
import kd.ebg.aqap.formplugin.ca.util.DigitalCertificateGenerator;
import kd.ebg.aqap.formplugin.ca.util.PKCSToJKS;
import kd.ebg.aqap.formplugin.plugin.util.ShowPageUtil;
import kd.ebg.aqap.formplugin.util.CertUtil;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.egf.common.cache.CosmicCache;
import kd.ebg.egf.common.constant.CertType;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.model.tenant.TenantAuth;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.egf.common.utils.JsonUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.file.FileCommonUtils;

public class CAUploadPlugin
extends AbstractFormPlugin
implements ClickListener,
UploadListener {
    private static final String KEY_ATTACHMENTPANEL = "ebc_attachmentpanelap";
    private static final String KEY_CODEEDITER = "ebc_codeeditap";
    private static final String KEY_CERTNAME = "ebc_cert_name";
    private static final String KEY_CERTPD = "cert_password";
    private static final String KEY_IMPORTTIME = "import_time";
    private static final String KEY_DOWNLOADPATH = "download_path";
    private static final String KEY_EXPIRETIME = "ebc_expire_time";
    private static final String KEY_ORGANIZATION = "ebc_organization";
    private static final String KEY_CHECKDAY = "ebc_check_day";
    private static final String KEY_CHECKSWITCH = "ebc_check_switch";
    private static final String AUTH_ENTITY = "aqap_bd_cert";
    private static final String ENTITY_KEY_CERT_MANAGE = "aqap_cert_manage";
    private static final String EB_UPLOAD = "eb_CAUploadPlugin_isUpload";
    private static final String ebPrefix = "eb_cert_";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String FILE_P12NAME = "ebgCer.p12";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(KEY_ATTACHMENTPANEL);
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.showCertContent(null, true);
    }

    public void upload(UploadEvent evt) {
        String tenantId = RequestContext.get().getTenantId();
        ArrayList<String> fileUrls = new ArrayList<String>(1);
        for (Object url : evt.getUrls()) {
            fileUrls.add((String)((Map)url).get("url"));
        }
        for (String fileUrl : fileUrls) {
            TenantAuth tenantAuth = this.loadCertFile(fileUrl);
            this.showCertContent(tenantAuth, false);
        }
    }

    private void showCertContent(TenantAuth tenantAuth, boolean isFromDB) {
        String certName = "";
        String expireTime = "";
        String organization = "";
        String publicKey = "";
        String importTime = "";
        String downloadPath = "";
        if (isFromDB) {
            QFilter filter = QFilter.of((String)"custom_id=? and type=?", (Object[])new Object[]{RequestContext.get().getTenantId(), CertType.CA_CER.getType()});
            DynamicObjectCollection collections = QueryServiceHelper.query((String)AUTH_ENTITY, (String)"file_name, organization, bank_config_value_tag, expire_time, alert_day, is_alert, modifytime, download_path", (QFilter[])filter.toArray());
            if (collections.size() > 0) {
                certName = ((DynamicObject)collections.get(0)).getString("file_name");
                expireTime = ((DynamicObject)collections.get(0)).getString("expire_time");
                organization = ((DynamicObject)collections.get(0)).getString("organization");
                publicKey = ((DynamicObject)collections.get(0)).getString("bank_config_value_tag");
                downloadPath = ((DynamicObject)collections.get(0)).getString(KEY_DOWNLOADPATH);
                importTime = DateUtil.formatDate((Date)((DynamicObject)collections.get(0)).getDate("modifytime"), (String)DATE_FORMAT);
                if (StringUtil.isNotNil(publicKey)) {
                    this.getPageCache().put(EB_UPLOAD, "true");
                    this.getModel().setValue(KEY_CERTPD, (Object)"******");
                }
                Timestamp timestamp = Timestamp.valueOf(expireTime);
                expireTime = new SimpleDateFormat(DATE_FORMAT).format(timestamp);
            }
        } else {
            certName = tenantAuth.getCertificateName();
            expireTime = DateTimeFormatter.ofPattern(DATE_FORMAT).format(tenantAuth.getExpireTime());
            importTime = DateTimeFormatter.ofPattern(DATE_FORMAT).format(LocalDateTime.now());
            organization = tenantAuth.getOrganization();
            publicKey = tenantAuth.getPublicKey();
        }
        this.getModel().setValue(KEY_CERTNAME, (Object)certName);
        this.getModel().setValue(KEY_IMPORTTIME, (Object)importTime);
        this.getModel().setValue(KEY_EXPIRETIME, (Object)expireTime);
        this.getModel().setValue(KEY_ORGANIZATION, (Object)organization);
        this.getModel().setValue(KEY_DOWNLOADPATH, (Object)downloadPath);
        StringBuilder StringBuilder2 = new StringBuilder();
        int len = 50;
        for (int i = 0; i < publicKey.length(); i += len) {
            if (i + len < publicKey.length()) {
                StringBuilder2.append(publicKey.substring(i, i + len));
                StringBuilder2.append("\r\n");
                continue;
            }
            StringBuilder2.append(publicKey.substring(i, publicKey.length()));
            StringBuilder2.append("\r\n");
        }
        CodeEdit codeEdit = (CodeEdit)this.getControl(KEY_CODEEDITER);
        codeEdit.setText(StringBuilder2.toString());
    }

    private void deleteCert() {
        this.getPageCache().put(EB_UPLOAD, "false");
        this.getModel().setValue(KEY_CERTNAME, (Object)"");
        this.getModel().setValue(KEY_IMPORTTIME, (Object)"");
        this.getModel().setValue(KEY_EXPIRETIME, (Object)"");
        this.getModel().setValue(KEY_ORGANIZATION, (Object)"");
        this.getModel().setValue(KEY_CERTNAME, (Object)"");
        this.getModel().setValue(KEY_CERTPD, (Object)"");
        this.getModel().setValue(KEY_DOWNLOADPATH, (Object)"");
        CodeEdit codeEdit = (CodeEdit)this.getControl(KEY_CODEEDITER);
        codeEdit.setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TenantAuth loadCertFile(String fileUrl) {
        TenantAuth tenantAuth = null;
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream inStream = null;
        try {
            String[] queryParams = new URL(fileUrl).getQuery().split("&");
            HashMap<String, String> downloadFileParams = new HashMap<String, String>(16);
            for (String queryParam : queryParams) {
                String[] p = queryParam.split("=");
                downloadFileParams.put(p[0], p[1]);
            }
            TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
            inStream = content.getInputStream();
            tenantAuth = CertUtil.parse(inStream);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return tenantAuth;
    }

    public void afterUpload(UploadEvent evt) {
        this.getPageCache().put(EB_UPLOAD, "true");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String tenantId = RequestContext.get().getTenantId();
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"new_ca", (CharSequence)formOperate.getOperateKey())) {
            this.newCaAndUpload(args);
        } else if (StringUtils.equals((CharSequence)"delete_ca", (CharSequence)formOperate.getOperateKey())) {
            this.deleteCert();
        } else if (StringUtils.equals((CharSequence)"show_ca_settring", (CharSequence)formOperate.getOperateKey())) {
            HashMap<String, Object> customParams = new HashMap<String, Object>(2);
            customParams.put("fileName", FILE_P12NAME);
            customParams.put("downloadPath", this.getModel().getValue(KEY_DOWNLOADPATH));
            ShowPageUtil.showFormPage("t_aqap_yqhl_setting", customParams, this.getView());
        } else if (StringUtils.equals((CharSequence)"save", (CharSequence)formOperate.getOperateKey())) {
            if (!Boolean.parseBoolean(this.getPageCache().get(EB_UPLOAD))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6210\u4e0a\u4f20\u8bc1\u4e66\u540e\uff0c\u518d\u8fdb\u884c\u4fdd\u5b58\u3002", (String)"CAUploadPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                return;
            }
            String certName = this.getModel().getValue(KEY_CERTNAME).toString();
            String dateTimeStr = this.getModel().getValue(KEY_EXPIRETIME).toString();
            if (StringUtil.isNil(dateTimeStr)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u8bc1\u4e66\u8fc7\u671f\u65f6\u95f4\u4e0d\u5b58\u5728\u3002", (String)"CAUploadPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                return;
            }
            LocalDateTime expireTime = DTFactoryUtil.parseDateTime((String)dateTimeStr);
            Date expireDate = Date.from(expireTime.atZone(ZoneId.systemDefault()).toInstant());
            if (LocalDateTime.now().isAfter(expireTime)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u8bc1\u4e66\u5df2\u7ecf\u8d85\u8fc7\u6709\u6548\u65e5\u671f\u3002", (String)"CAUploadPlugin_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                return;
            }
            String org = this.getModel().getValue(KEY_ORGANIZATION).toString();
            CodeEdit codeEdit = (CodeEdit)this.getControl(KEY_CODEEDITER);
            String publicKey = "";
            if (StringUtil.isNotNil(codeEdit.getText())) {
                publicKey = codeEdit.getText().replace("\r\n", "");
                if (StringUtil.isNil(publicKey)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u8bc1\u4e66\u516c\u94a5\u4e0d\u5b58\u5728\u3002", (String)"CAUploadPlugin_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6210\u4e0a\u4f20\u8bc1\u4e66\u540e\uff0c\u518d\u8fdb\u884c\u4fdd\u5b58\u3002", (String)"CAUploadPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean isUpdate = false;
            DynamicObject authDO = null;
            String selectProps = "bank_config_name, bank_config_id, file_name, organization, bank_config_value_tag, expire_time, custom_id, alert_day, is_alert, type, cert_source, cert_type, modifytime,download_path,source";
            QFilter filter = QFilter.of((String)"custom_id=? and type=?", (Object[])new Object[]{RequestContext.get().getTenantId(), CertType.CA_CER.getType()});
            DynamicObject collection = BusinessDataServiceHelper.loadSingle((String)AUTH_ENTITY, (String)selectProps, (QFilter[])filter.toArray());
            isUpdate = collection != null;
            authDO = isUpdate ? collection : BusinessDataServiceHelper.newDynamicObject((String)AUTH_ENTITY);
            authDO.set("bank_config_name", (Object)JsonUtil.toJsonLine((Object)new MultiLangEnumBridge("CA\u8bc1\u4e66", "CAUploadPlugin_4", "ebg-aqap-formplugin")));
            authDO.set("bank_config_id", (Object)"public_key");
            authDO.set("file_name", (Object)certName);
            authDO.set("organization", (Object)org);
            authDO.set("expire_time", (Object)expireDate);
            authDO.set("bank_config_value_tag", (Object)publicKey);
            authDO.set("custom_id", (Object)RequestContext.get().getTenantId());
            String importTime = (String)this.getModel().getValue(KEY_IMPORTTIME);
            if (StringUtil.isNotNil(importTime)) {
                authDO.set("modifytime", (Object)DateUtil.string2Date((String)importTime, (String)DATE_FORMAT));
            }
            authDO.set("type", (Object)CertType.CA_CER.getType());
            authDO.set(KEY_DOWNLOADPATH, this.getModel().getValue(KEY_DOWNLOADPATH));
            authDO.set("cert_source", (Object)CertSource.SYSTEM.getSource());
            authDO.set("cert_type", (Object)CertTypeEnum.CA.getType());
            String formId = this.getView().getFormShowParameter().getFormId();
            if (StringUtil.isNotNil(formId)) {
                authDO.set("source", (Object)formId);
            }
            try {
                if (isUpdate) {
                    SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{authDO});
                } else {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{authDO});
                }
            }
            catch (Exception e) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c%s\u3002", (String)"CAUploadPlugin_14", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002\u5efa\u8bae\u5230\u3010\u94f6\u4f01\u76d1\u63a7\u3011-\u3010\u8bc1\u4e66\u9884\u8b66\u76d1\u63a7\u3011\u4e2d\u8fdb\u884c\u201c\u8fc7\u671f\u9884\u8b66\u8bbe\u7f6e\u201d\uff0c\u4ee5\u514d\u672c\u8bc1\u4e66\u5230\u671f\u540e\u5f71\u54cd\u4e1a\u52a1\u3002", (String)"BankLoginProxyPlugin_14", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), Integer.valueOf(7000));
            String key = ebPrefix + tenantId;
            CosmicCache.delete((String)key);
        }
    }

    public void remove(UploadEvent evt) {
        this.getPageCache().put(EB_UPLOAD, "false");
        this.deleteCert();
    }

    public boolean newCaAndUpload(BeforeDoOperationEventArgs args) {
        if (Boolean.parseBoolean(this.getPageCache().get(EB_UPLOAD))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5df2\u5b58\u5728CA\u8bc1\u4e66\u8bb0\u5f55\uff0c\u8bf7\u5220\u9664\u8bc1\u4e66\u540e\u518d\u64cd\u4f5c\u3002", (String)"CAUploadPlugin_6", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        String certName = (String)this.getModel().getValue(KEY_CERTNAME);
        String certOrgan = (String)this.getModel().getValue(KEY_ORGANIZATION);
        String certPassword = (String)this.getModel().getValue(KEY_CERTPD);
        String certAlias = "kingdee";
        if (StringUtil.isNullOrEmpty(certName)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bc1\u4e66\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CAUploadPlugin_7", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        if (StringUtil.isNullOrEmpty(certOrgan)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bc1\u4e66\u62e5\u6709\u8005\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CAUploadPlugin_8", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        String pattern = "(?!^(\\d+|[a-zA-Z]+|[~!@#$%^&*()_.]+)$)^[\\w~!@#$%^&*()_.]{8,16}$";
        if (StringUtil.isNullOrEmpty(certPassword)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bc1\u4e66\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CAUploadPlugin_9", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        if (!Pattern.matches(pattern, certPassword)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bc1\u4e66\u5bc6\u7801\u590d\u6742\u5ea6\u4e0d\u7b26\u5408\u89c4\u5219\uff0c\u5177\u4f53\u89c4\u5219\u89c1\u8bc1\u4e66\u5bc6\u7801\u7684tips\u3002", (String)"CAUploadPlugin_10", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return false;
        }
        String fileDir = System.getProperty("user.dir") + File.separator + "CA" + File.separator + RequestContext.get().getTenantId() + File.separator + RequestContext.get().getAccountId() + File.separator;
        File file = FileCommonUtils.getFileByPath((String)fileDir);
        if (!file.exists()) {
            file.mkdirs();
        }
        String keystorePath = fileDir + "ebg.keystore";
        String caPath = fileDir + "ebg.cer";
        String p12Path = fileDir + FILE_P12NAME;
        int days = 365;
        KeyStoreInfo certInfo = new KeyStoreInfo(certAlias, certPassword, certPassword, certName, certOrgan, certOrgan, "ShenZhen", "GuangDong", "CN", new Date(), days, keystorePath);
        DigitalCertificateGenerator.generateJKS(certInfo);
        DigitalCertificateGenerator.exportJKSPublicKeyCertificate(keystorePath, certPassword, certAlias, caPath);
        new PKCSToJKS().JSKToPKCS12(keystorePath, certPassword, p12Path, certPassword);
        this.upload(caPath, p12Path);
        FileCommonUtils.getFileByPath((String)keystorePath).delete();
        FileCommonUtils.getFileByPath((String)caPath).delete();
        FileCommonUtils.getFileByPath((String)p12Path).delete();
        this.getPageCache().put(EB_UPLOAD, "true");
        return true;
    }

    public boolean upload(String caPath, String p12Path) {
        File file = FileCommonUtils.getFileByPath((String)caPath);
        if (!file.exists()) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0a\u4f20ca\u8bc1\u4e66\u5931\u8d25\uff0c\u672a\u627e\u5230\u5bf9\u5e94ca\u8bc1\u4e66\u3002", (String)"CAUploadPlugin_11", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        }
        try (FileInputStream inputStream = new FileInputStream(file);){
            TenantAuth tenantAuth = CertUtil.parse(inputStream);
            this.showCertContent(tenantAuth, false);
        }
        catch (IOException ex) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0a\u4f20ca\u8bc1\u4e66\u5931\u8d25\u3002", (String)"CAUploadPlugin_12", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), (Throwable)ex);
        }
        FileService fs = FileServiceFactory.getAttachmentFileService();
        String path = FileNameUtils.getAttachmentFileName((String)RequestContext.get().getTenantId(), (String)RequestContext.get().getAccountId(), (Object)"p12", (String)FILE_P12NAME);
        try (FileItem fi = null;
             FileInputStream inputStream = new FileInputStream(FileCommonUtils.checkPath((String)p12Path));){
            fi = new FileItem(FILE_P12NAME, path, (InputStream)inputStream);
            fi.setCreateNewFileWhenExists(true);
            String resultPath = fs.upload(fi);
            this.getModel().setValue(KEY_DOWNLOADPATH, (Object)resultPath);
        }
        return true;
    }
}

