/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.cacert;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.formplugin.lang.MultiLang;
import kd.ebg.egf.common.utils.string.StringUtils;

public class CertAlertSettingPlugin
extends AbstractFormPlugin {
    private static final String selectProperties = "mobiles, is_alert, alert_day, alert_type";
    private String EB_SAVE = "eb_CertAlertSettingPlugin_isSave";

    public void beforeBindData(EventObject e) {
        DynamicObject dynamicObject;
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        List ids = (List)paramMap.get("ids");
        if (ids.size() == 1 && (dynamicObject = QueryServiceHelper.queryOne((String)"aqap_bd_cert", (String)selectProperties, (QFilter[])new QFilter("id", "=", ids.get(0)).toArray())) != null) {
            this.getModel().setValue("mobiles", (Object)dynamicObject.getString("mobiles"));
            this.getModel().setValue("alert_day", (Object)dynamicObject.getLong("alert_day"));
            String alertType = dynamicObject.getString("alert_type");
            if (StringUtils.isNotEmpty((String)alertType)) {
                this.getModel().setValue("alert_type", (Object)alertType);
            }
            this.getModel().setValue("is_alert", (Object)dynamicObject.getBoolean("is_alert"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((String)"save", (String)operateKey)) {
            String mobiles = (String)this.getModel().getValue("mobiles");
            boolean isAlert = (Boolean)this.getModel().getValue("is_alert");
            if (isAlert && StringUtils.isEmpty((String)mobiles)) {
                this.getView().showTipNotification(MultiLang.getMobileNotEmptyTip());
                args.setCancel(true);
            } else {
                String[] res = mobiles.split("\\;");
                HashMap<String, Integer> checkRepeatMap = new HashMap<String, Integer>(16);
                for (int i = 0; i < res.length; ++i) {
                    String mobile = res[i];
                    if (StringUtils.isEmpty((String)mobile)) continue;
                    if (!StringUtils.isChinaPhoneLegal((String)mobile)) {
                        this.getView().showTipNotification(MultiLang.getPhoneNumberFormatTip(i + 1));
                        args.setCancel(true);
                        return;
                    }
                    if (checkRepeatMap.get(mobile) != null) {
                        int beforeIndex = (Integer)checkRepeatMap.get(mobile) + 1;
                        this.getView().showTipNotification(MultiLang.getPhoneNumberRepeatTip(beforeIndex, i + 1));
                        args.setCancel(true);
                        return;
                    }
                    checkRepeatMap.put(mobile, i);
                }
                this.save();
            }
        }
    }

    public void save() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map paramMap = formShowParameter.getCustomParams();
        String mobiles = (String)this.getModel().getValue("mobiles");
        int alertDay = (Integer)this.getModel().getValue("alert_day");
        String alertType = (String)this.getModel().getValue("alert_type");
        boolean isAlert = (Boolean)this.getModel().getValue("is_alert");
        List ids = (List)paramMap.get("ids");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"aqap_bd_cert", (String)selectProperties, (QFilter[])new QFilter("id", "in", (Object)ids).toArray());
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (int i = 0; i < dynamicObjects.length; ++i) {
                dynamicObjects[i].set("is_alert", (Object)isAlert);
                dynamicObjects[i].set("alert_type", (Object)alertType);
                dynamicObjects[i].set("alert_day", (Object)alertDay);
                dynamicObjects[i].set("mobiles", (Object)mobiles);
            }
            SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8bc1\u4e66\u8fc7\u671f\u9884\u8b66\u8bbe\u7f6e\u6210\u529f\u3002", (String)"CertAlertSettingPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            this.getPageCache().put(this.EB_SAVE, "true");
            this.getView().invokeOperation("close");
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8bc1\u4e66\u8bb0\u5f55\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002", (String)"CertAlertSettingPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
        }
    }

    public void update() {
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if ("true".equalsIgnoreCase(this.getPageCache().get(this.EB_SAVE))) {
            this.getView().returnDataToParent((Object)true);
        }
    }
}

