/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.cacert;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.common.model.CertInfo;
import kd.ebg.aqap.formplugin.lang.MultiLang;
import kd.ebg.aqap.formplugin.plugin.cacert.FileHandler;
import kd.ebg.aqap.formplugin.util.CertUtil;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.egf.common.constant.CertType;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.egf.common.utils.DesUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;

public class CertParsePlugin
extends AbstractFormPlugin
implements ClickListener,
UploadListener {
    private String KEY_ATTACHMENTPANEL = "ebc_attachmentpanelap";
    private String KEY_EXPIRETIME = "ebc_expire_time";
    private String KEY_CHECKDAY = "ebc_check_day";
    private String KEY_PD = "ebc_password";
    private String KEY_CHECKSWITCH = "ebc_check_switch";
    private String CERT_ENTITY = "aqap_bd_cert";
    private String EB_UPLOAD = "eb_CertParsePlugin_isUpload";
    private String EB_SAVE = "eb_CertParsePlugin_isSave";
    private static final String EB_CERTINFO = "eb_CertParsePlugin_certInfo";
    private EBGLogger logger = EBGLogger.getInstance().getLogger(CertParsePlugin.class);

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(this.KEY_ATTACHMENTPANEL);
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void click(EventObject evt) {
    }

    public void afterCreateNewData(EventObject e) {
        String statusName;
        super.afterCreateNewData(e);
        HashMap<String, String> fieldMap = new HashMap<String, String>(16);
        fieldMap.put("bc", "white");
        this.getView().updateControlMetadata("ebc_flexpanelap1", fieldMap);
        this.getView().updateControlMetadata("ebc_flexpanelap", fieldMap);
        this.getView().updateControlMetadata("ebc_flexpanelap3", fieldMap);
        this.getView().updateControlMetadata("ebc_advconap", fieldMap);
        this.getView().updateControlMetadata("ebc_attachmentpanelap", fieldMap);
        this.getView().updateControlMetadata("ebc_ebc_ebc_flexpanelap2", fieldMap);
        String source = (String)this.getView().getFormShowParameter().getCustomParam("source");
        if (StringUtil.isNotNil(source) && "proxy".equalsIgnoreCase(source)) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("ext", ".jks,.keystore");
            this.getView().updateControlMetadata("ebc_attachmentpanelap", data);
        }
        if ("VIEW".equalsIgnoreCase(statusName = this.getView().getFormShowParameter().getStatus().name())) {
            this.showCertContent(null, true);
        }
    }

    public void upload(UploadEvent evt) {
        String password = (String)this.getModel().getValue("ebc_password");
        String tenantId = RequestContext.get().getTenantId();
        ArrayList<String> fileUrls = new ArrayList<String>(1);
        for (Object url : evt.getUrls()) {
            fileUrls.add((String)((Map)url).get("url"));
        }
        for (String fileUrl : fileUrls) {
            CertInfo certInfo = this.loadCertFile(fileUrl);
            if (certInfo == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bc1\u4e66\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u8bc1\u4e66\u5bc6\u7801\u662f\u5426\u6b63\u786e\u3002", (String)"CertParsePlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (certInfo.getExpireTime() == null) {
                certInfo.setExpireTime(LocalDateTime.of(2099, 12, 30, 23, 59, 59));
            }
            this.showCertContent(certInfo, false);
            this.getPageCache().put(EB_CERTINFO, JSONObject.toJSONString((Object)certInfo));
        }
    }

    private void showCertContent(CertInfo certInfo, boolean isFromDB) {
        String expireTime = "";
        int alertDays = 7;
        boolean isAlert = true;
        String ciph = "";
        if (isFromDB) {
            QFilter[] filters;
            String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
            if (CertType.PLATEFORM_CER.getType().equals(type)) {
                String bankVersionID = (String)this.getView().getFormShowParameter().getCustomParam("bankVersionID");
                String bankConfigID = (String)this.getView().getFormShowParameter().getCustomParam("bank_config_id");
                filters = new QFilter[]{new QFilter("bank_version_id", "=", (Object)bankVersionID), new QFilter("bank_config_id", "=", (Object)bankConfigID), new QFilter("type", "=", (Object)CertType.PLATEFORM_CER.getType())};
            } else {
                filters = new QFilter[]{QFilter.of((String)"custom_id=?", (Object[])new Object[]{RequestContext.get().getTenantId()})};
            }
            DynamicObjectCollection collections = QueryServiceHelper.query((String)this.CERT_ENTITY, (String)"expire_time, alert_day, is_alert, cert_password", (QFilter[])filters);
            if (collections.size() == 1) {
                expireTime = ((DynamicObject)collections.get(0)).getString("expire_time");
                alertDays = ((DynamicObject)collections.get(0)).getInt("alert_day");
                isAlert = Boolean.parseBoolean(((DynamicObject)collections.get(0)).getString("is_alert"));
                ciph = ((DynamicObject)collections.get(0)).getString("cert_password");
            }
            this.getModel().setValue(this.KEY_CHECKDAY, (Object)alertDays);
            this.getModel().setValue(this.KEY_CHECKSWITCH, (Object)isAlert);
            this.getModel().setValue(this.KEY_PD, (Object)ciph);
        } else {
            LocalDateTime dateTime = LocalDateTime.parse(certInfo.getExpireTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss")), DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"));
            expireTime = DateUtil.transTimeZoneSystemToUser((LocalDateTime)dateTime);
        }
        this.getModel().setValue(this.KEY_EXPIRETIME, (Object)expireTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CertInfo loadCertFile(String fileUrl) {
        CertInfo certInfo = null;
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream inStream = null;
        try {
            String password;
            String[] queryParams = new URL(fileUrl).getQuery().split("&");
            HashMap<String, String> downloadFileParams = new HashMap<String, String>(16);
            for (String queryParam : queryParams) {
                String[] p = queryParam.split("=");
                downloadFileParams.put(p[0], p[1]);
            }
            TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
            inStream = content.getInputStream();
            String fileName = content.getFilename();
            String bankVersionID = (String)this.getView().getFormShowParameter().getCustomParam("bankVersionID");
            String signType = "";
            if ("ICBC_OPA".equals(bankVersionID)) {
                signType = (String)this.getView().getParentView().getModel().getValue("signType");
            }
            if (fileName.endsWith(".txt") || fileName.endsWith(".asc") || fileName.endsWith(".key") || fileName.endsWith(".sm2")) {
                password = (String)this.getModel().getValue(this.KEY_PD);
                certInfo = new CertInfo();
                certInfo.setExpireTime(LocalDateTime.of(2099, 12, 30, 23, 59, 59));
                if (StringUtils.isNotEmpty((CharSequence)password)) {
                    certInfo.setCertPassword(password);
                }
            } else {
                password = (String)this.getModel().getValue(this.KEY_PD);
                if ("ICBC_OPA".equals(bankVersionID) && "SM".equals(signType)) {
                    certInfo = new CertInfo();
                    certInfo.setExpireTime(LocalDateTime.of(2099, 12, 30, 23, 59, 59));
                    certInfo.setCertPassword(password);
                } else if ("CMBC_OPA".equalsIgnoreCase(bankVersionID) || "CIB_OPA".equalsIgnoreCase(bankVersionID)) {
                    if (this.isPublicKey()) {
                        certInfo = CertUtil.getPublicKeyInfo4CMbc(inStream);
                    } else {
                        certInfo = new CertInfo();
                        certInfo.setExpireTime(LocalDateTime.of(2099, 12, 30, 23, 59, 59));
                        certInfo.setCertPassword(password);
                    }
                } else {
                    certInfo = CertUtil.getCertExpireTimeInfo(inStream, password, fileName, bankVersionID);
                }
                content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
                inStream = content.getInputStream();
            }
            byte[] byteArray = StringUtil.isNullOrEmpty(certInfo.getFileContent()) ? CertParsePlugin.input2byte(inStream) : certInfo.getFileContent().getBytes();
            try {
                if (fileName.endsWith(".asc")) {
                    String myContent = new String(byteArray).replaceAll("-----BEGIN PGP PUBLIC KEY BLOCK-----\r\n", "").replaceAll("\r\n-----END PGP PUBLIC KEY BLOCK-----\r\n", "").replaceAll("\r\n-----END PGP PUBLIC KEY BLOCK-----", "").replaceAll("-----BEGIN PGP PRIVATE KEY BLOCK-----\r\n", "").replaceAll("\r\n-----END PGP PRIVATE KEY BLOCK-----\r\n", "").replaceAll("\r\n-----END PGP PRIVATE KEY BLOCK-----", "").replaceAll("Version: GnuPG v2\r\n\r\n", "").replaceAll("Version: GnuPG v2\r\n", "");
                    byteArray = myContent.getBytes();
                }
                String fileContent = DesUtil.encryptProxyCert((byte[])byteArray, (String)RequestContext.get().getTenantId());
                certInfo.setFileContent(fileContent);
            }
            catch (Exception ex) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0a\u4f20\u8bc1\u4e66\u5f02\u5e38\u3002", (String)"CertParsePlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            }
            certInfo.setFileName(fileName);
            certInfo.setCustomID(RequestContext.get().getTenantId());
            if ("JXNSB_CMP".equals(bankVersionID)) {
                FileHandler.copyPublicFile(certInfo);
            }
            if ("JXNSB_CMP".equals(bankVersionID)) {
                FileHandler.copyPublicFile(certInfo);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return certInfo;
    }

    public static final byte[] input2byte(InputStream inStream) throws IOException {
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[100];
        int rc = 0;
        while ((rc = inStream.read(buff, 0, 100)) > 0) {
            swapStream.write(buff, 0, rc);
        }
        byte[] in2b = swapStream.toByteArray();
        return in2b;
    }

    public void afterUpload(UploadEvent evt) {
        this.getPageCache().put(this.EB_UPLOAD, "true");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String tenantId = RequestContext.get().getTenantId();
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)formOperate.getOperateKey())) {
            if (!Boolean.parseBoolean(this.getPageCache().get(this.EB_UPLOAD))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6210\u4e0a\u4f20\u8bc1\u4e66\u540e\uff0c\u518d\u8fdb\u884c\u4fdd\u5b58\u3002", (String)"CertParsePlugin_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                return;
            }
            String dateTimeStr = this.getModel().getValue(this.KEY_EXPIRETIME).toString();
            if (StringUtil.isNil(dateTimeStr)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u8bc1\u4e66\u8fc7\u671f\u65f6\u95f4\u4e0d\u5b58\u5728\u3002", (String)"CertParsePlugin_3", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                return;
            }
            LocalDateTime expireTime = DTFactoryUtil.parseDateTime((String)dateTimeStr);
            if (LocalDateTime.now().isAfter(expireTime)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u8bc1\u4e66\u5df2\u7ecf\u8d85\u8fc7\u6709\u6548\u65e5\u671f\u3002", (String)"CertParsePlugin_4", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put(this.EB_SAVE, "true");
            String checkDays = this.getModel().getValue(this.KEY_CHECKDAY).toString();
            boolean isCheck = Boolean.parseBoolean(this.getModel().getValue(this.KEY_CHECKSWITCH).toString());
            CertInfo certInfo = (CertInfo)JSONObject.parseObject((String)this.getPageCache().get(EB_CERTINFO), CertInfo.class);
            certInfo.setCustomID(RequestContext.get().getTenantId());
            certInfo.setAlert(isCheck);
            certInfo.setAlertDay(checkDays);
            if (StringUtils.isBlank((CharSequence)certInfo.getCertPassword())) {
                String password = (String)this.getModel().getValue(this.KEY_PD);
                certInfo.setCertPassword(password);
            }
            this.getPageCache().put(EB_CERTINFO, JSONObject.toJSONString((Object)certInfo));
            this.getView().showSuccessNotification(MultiLang.getSaveSuccessTip());
            this.getView().invokeOperation("close");
        }
    }

    public void remove(UploadEvent evt) {
        this.getPageCache().put(this.EB_UPLOAD, "false");
        this.getPageCache().put(this.EB_SAVE, "false");
        this.showCertContent(null, true);
    }

    boolean isPrivateKey() {
        String fieldKey = (String)this.getView().getFormShowParameter().getCustomParam("fieldKey");
        if (StringUtil.isNullOrEmpty(fieldKey)) {
            return false;
        }
        return "private_key".equalsIgnoreCase(fieldKey);
    }

    boolean isPublicKey() {
        String fieldKey = (String)this.getView().getFormShowParameter().getCustomParam("fieldKey");
        if (StringUtil.isNullOrEmpty(fieldKey)) {
            return false;
        }
        return "public_key".equalsIgnoreCase(fieldKey);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if ("true".equalsIgnoreCase(this.getPageCache().get(this.EB_SAVE))) {
            this.getView().returnDataToParent((Object)this.getPageCache().get(EB_CERTINFO));
        }
    }
}

