/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.detail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.common.model.DetailSyncRecord;
import kd.ebg.aqap.common.model.repository.DetailSyncRecordRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.plugin.baseplugin.EBGBasePlugin;
import kd.ebg.aqap.formplugin.plugin.util.ShowPageUtil;
import kd.ebg.aqap.formplugin.repository.EbcBankAcntRepository;
import kd.ebg.aqap.formplugin.service.biz.BizService;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.egf.common.cache.CosmicConstants;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.data.Page;
import kd.ebg.egf.common.model.data.PageRequest;
import kd.ebg.egf.common.model.data.Pageable;
import kd.ebg.egf.common.model.data.Sort;
import kd.ebg.egf.common.repository.bank.BankVersionRepository;
import kd.ebg.egf.common.utils.collect.CollectionUtil;

public class DetailCompletionStatListPlugin
extends EBGBasePlugin {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailCompletionStatListPlugin.class);
    private DetailSyncRecordRepository repository = (DetailSyncRecordRepository)SpringContextUtil.getBean(DetailSyncRecordRepository.class);
    private BizService bizService = (BizService)SpringContextUtil.getBean(BizService.class);
    private EbcBankAcntRepository bankAcntRepository = (EbcBankAcntRepository)SpringContextUtil.getBean(EbcBankAcntRepository.class);
    private BankVersionRepository bankVersionRepository = (BankVersionRepository)SpringContextUtil.getBean(BankVersionRepository.class);
    private List<QFilter> rowQFilter = new ArrayList<QFilter>(16);

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        this.rowQFilter.clear();
        if (CollectionUtil.isNotEmpty((Collection)qFilters)) {
            for (QFilter qFilter : qFilters) {
                List QFilterNests;
                if ("is_completed".equalsIgnoreCase(qFilter.getProperty())) {
                    this.buildIsCompletedQFilter(qFilter);
                } else {
                    String property = qFilter.getProperty();
                    if (StringUtil.isNotNil(property) && !property.startsWith("bank_version.") && !property.startsWith("bank_acnt.")) {
                        this.rowQFilter.add(new QFilter(qFilter.getProperty(), qFilter.getCP(), qFilter.getValue()));
                    }
                }
                if ((QFilterNests = qFilter.getNests(false)) == null || QFilterNests.size() <= 0) continue;
                this.getMergeQfilters(QFilterNests);
            }
        }
    }

    public void getMergeQfilters(List<QFilter.QFilterNest> qFilterNests) {
        for (QFilter.QFilterNest qFilterNest : qFilterNests) {
            List childQFilterNests;
            QFilter qFilter = qFilterNest.getFilter();
            if ("is_completed".equalsIgnoreCase(qFilter.getProperty())) {
                this.buildIsCompletedQFilter(qFilter);
            } else if (!StringUtil.isNumber(qFilter.getProperty())) {
                this.rowQFilter.add(new QFilter(qFilter.getProperty(), qFilter.getCP(), qFilter.getValue()));
            }
            if ((childQFilterNests = qFilter.getNests(false)) == null || childQFilterNests.size() <= 0) continue;
            this.getMergeQfilters(childQFilterNests);
        }
    }

    public void buildIsCompletedQFilter(QFilter qFilter) {
        if ("=".equals(qFilter.getCP())) {
            this.rowQFilter.add(new QFilter("is_completed", "=", (Object)Integer.valueOf((String)qFilter.getValue())));
        } else if ("in".equals(qFilter.getCP())) {
            List list = (List)qFilter.getValue();
            ArrayList<Integer> integers = new ArrayList<Integer>(16);
            for (String str : list) {
                integers.add(Integer.parseInt(str));
            }
            this.rowQFilter.add(new QFilter("is_completed", "in", integers));
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        ListSelectedRowCollection listSelectedRows;
        String bankVersionId = this.getPageCache().get("selectedBankId");
        String selectedAcntIdStr = this.getPageCache().get("selectedAcntId");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(QFilter.of((String)"custom_id=?", (Object[])new Object[]{RequestContext.get().getTenantId()}));
        qFilters.add(QFilter.of((String)"is_completed != 0", (Object[])new Object[0]));
        ArrayList<Long> ids = new ArrayList<Long>(16);
        final IPageCache iPageCache = this.getPageCache();
        String operation = iPageCache.get("my_operation");
        if ("is_export".equals(operation) && !(listSelectedRows = this.getSelectedRows()).isEmpty()) {
            for (int i = 0; i < listSelectedRows.size(); ++i) {
                ids.add((Long)listSelectedRows.get(i).getPrimaryKeyValue());
            }
            qFilters.add(new QFilter("id ", "in", ids));
        }
        String bankName = "";
        if (StringUtils.isNotBlank((CharSequence)selectedAcntIdStr)) {
            DynamicObject acnt = this.bankAcntRepository.getAcntByID(Long.valueOf(selectedAcntIdStr));
            qFilters.add(QFilter.of((String)"acc_no = ?", (Object[])new Object[]{acnt.getString("number")}));
            bankName = acnt.getString("group.bank_name");
        } else if (StringUtils.isNotBlank((CharSequence)bankVersionId)) {
            DynamicObject bankVersion = this.bankVersionRepository.loadDynamicObjectByID(Long.valueOf(bankVersionId));
            bankName = bankVersion.getString("bank_name");
            DynamicObject[] dynamicObjects = this.bankAcntRepository.selectByBankVersionIdAndCustomId(Long.valueOf(bankVersionId), RequestContext.get().getTenantId());
            ArrayList<String> accnos = new ArrayList<String>(16);
            if (dynamicObjects != null && dynamicObjects.length > 0) {
                for (DynamicObject dynamicObject : dynamicObjects) {
                    accnos.add(dynamicObject.getString("number"));
                }
            }
            qFilters.add(new QFilter("acc_no", "in", accnos));
        }
        final String sortInfo = ((BillList)this.getView().getControl("billlistap")).getEntryState().getSortInfo();
        final String dataCountCacheKey = "page_data_data_count";
        final ArrayList<QFilter> finalQFilters = qFilters;
        final IFormView myView = this.getView();
        final String finalBankName = bankName;
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public int getRealCount() {
                return Integer.parseInt(iPageCache.get(dataCountCacheKey));
            }

            public DynamicObjectCollection getData(int start, int limit) {
                int currentPage = start / limit + 1;
                int pageSize = limit;
                Sort sort = StringUtil.isNotNil(sortInfo) ? Sort.by((String[])new String[]{sortInfo}) : Sort.by((String[])new String[]{"id"});
                String operation = iPageCache.get("my_operation");
                finalQFilters.addAll(DetailCompletionStatListPlugin.this.rowQFilter);
                PageRequest pageRequest = PageRequest.of((int)(currentPage - 1), (int)pageSize, (Sort)sort);
                Page result = DetailCompletionStatListPlugin.this.repository.findByQFilters(finalQFilters, (Pageable)pageRequest);
                int dataCount = (int)result.getTotalElements();
                HashMap<String, String> bankNameMap = new HashMap<String, String>(16);
                HashSet accSet = new HashSet();
                if (StringUtil.isNullOrEmpty(finalBankName) && !Lang.get().name().equalsIgnoreCase("zh_CN")) {
                    DynamicObject[] acntByAccnoList;
                    result.getContent().stream().forEach(detail -> accSet.add(detail.getString("acc_no")));
                    for (DynamicObject dynamicObject : acntByAccnoList = DetailCompletionStatListPlugin.this.bankAcntRepository.getAcntByAccnoList(accSet.stream().collect(Collectors.toList()))) {
                        String accNo = dynamicObject.getString("number");
                        String bankName = dynamicObject.getString("group.bank_name");
                        bankNameMap.put(accNo, bankName);
                    }
                }
                DynamicObjectCollection dObjectCollection = this.getCollection(result.getContent(), finalBankName, bankNameMap);
                this.getQueryResult().setCollection(dObjectCollection);
                this.getQueryResult().setDataCount(dataCount);
                iPageCache.put(dataCountCacheKey, dataCount + "");
                if ("is_export".equals(operation)) {
                    myView.invokeOperation("refresh");
                }
                return dObjectCollection;
            }

            private DynamicObjectCollection getCollection(List<DynamicObject> dynamicObjects, String bankName, Map<String, String> bankNameMap) {
                String selectFields = "id, acc_no, bank_name,sync_date,currency,compensation_count,is_completed,modifytime,compensation_detail";
                DynamicObjectCollection dCollection = QueryServiceHelper.query((String)"aqap_detail_completion", (String)selectFields, null);
                if (CollectionUtil.isEmpty(dynamicObjects)) {
                    return dCollection;
                }
                dynamicObjects.stream().forEach(detail -> {
                    DynamicObject data = dCollection.addNew();
                    data.set("id", (Object)detail.getString("id"));
                    String accNo = detail.getString("acc_no");
                    data.set("acc_no", (Object)accNo);
                    data.set("currency", (Object)detail.getString("currency"));
                    data.set("compensation_count", (Object)detail.getInt("compensation_count"));
                    data.set("is_completed", (Object)detail.getInt("is_completed"));
                    if (Lang.get().getLangTag().equalsIgnoreCase("zh_CN")) {
                        data.set("bank_name", (Object)detail.getString("bank_name"));
                    } else if (StringUtil.isNullOrEmpty(bankName)) {
                        data.set("bank_name", bankNameMap.get(accNo));
                    } else {
                        data.set("bank_name", (Object)bankName);
                    }
                    data.set("sync_date", (Object)detail.getDate("sync_date"));
                    data.set("modifytime", (Object)detail.getDate("modifytime"));
                });
                return dCollection;
            }
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        this.getPageCache().put("my_operation", "");
        if (StringUtils.equals((CharSequence)"setting", (CharSequence)formOperate.getOperateKey())) {
            ShowPageUtil.showFormPage("aqap_detail_setting", null, this.getView());
        } else if (StringUtils.equals((CharSequence)"exportlistbyselectfields", (CharSequence)formOperate.getOperateKey())) {
            if (this.getSelectedRows() == null || this.getSelectedRows().size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5f15\u51fa\u7684\u6570\u636e\u3002", (String)"DetailCompletionStatListPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.getPageCache().put("my_operation", "is_export");
        } else if (StringUtils.equals((CharSequence)"download_from_bank", (CharSequence)formOperate.getOperateKey())) {
            ListSelectedRowCollection listSelectedRowCollection = args.getListSelectedData();
            StringBuilder ids = new StringBuilder();
            if (listSelectedRowCollection != null) {
                for (ListSelectedRow row : listSelectedRowCollection) {
                    ids.append(row.getPrimaryKeyValue()).append(",");
                }
                this.getPageCache().put("searchIds", ids.toString());
                if (listSelectedRowCollection.size() > 500) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5355\u6b21\u6700\u591a\u5141\u8bb8\u8054\u673a\u67e5\u8be2500\u6761\u3002", (String)"DetailCompletionStatListPlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (listSelectedRowCollection.size() > 10) {
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5df2\u52fe\u9009%s\u884c\u8054\u673a\u4e0b\u8f7d\u4ea4\u6613\u660e\u7ec6\uff0c\u53ef\u80fd\u5bf9\u6027\u80fd\u6709\u4e00\u5b9a\u5f71\u54cd\uff0c\u5efa\u8bae\u975e\u9ad8\u5cf0\u671f\u8fdb\u884c\u64cd\u4f5c\uff0c\u662f\u5426\u9700\u8981\u7ee7\u7eed\u4e0b\u8f7d\uff1f", (String)"DetailCompletionStatListPlugin_7", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), listSelectedRowCollection.size()), MessageBoxOptions.YesNo, ConfirmTypes.Wait, new ConfirmCallBackListener("download_from_bank_id", (IFormPlugin)this));
                } else {
                    this.downLoadFromBank();
                }
                args.setCancel(true);
                this.getView().invokeOperation("refresh");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("Yes".equals(messageBoxClosedEvent.getResultValue())) {
            this.downLoadFromBank();
        }
    }

    public void downLoadFromBank() {
        String ids = this.getPageCache().get("searchIds");
        String[] idArray = ids.split(",");
        ArrayList<Long> idList = new ArrayList<Long>(16);
        for (String id : idArray) {
            if (!StringUtil.isNotNil(id)) continue;
            idList.add(Long.valueOf(id));
        }
        List records = this.repository.findByIdIn(idList);
        if (CollectionUtil.isNotEmpty((Collection)records)) {
            int successCount = 0;
            int failCount = 0;
            for (DetailSyncRecord record : records) {
                if (CosmicConstants.DETAIL_RECORD_NOT_COMPLETED.equals(record.getIsCompleted())) {
                    if (this.downLoadFromBank(record)) {
                        ++successCount;
                        continue;
                    }
                    ++failCount;
                    continue;
                }
                ++successCount;
            }
            if (idList.size() == successCount) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u5f00\u59cb\u8054\u673a\u4e0b\u8f7d\u4ea4\u6613\u660e\u7ec6\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u3002", (String)"DetailCompletionStatListPlugin_8", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u52fe\u9009\u8bb0\u5f55%1$s\u6761\uff0c\u8054\u673a\u67e5\u8be2\u6210\u529f%2$s\u6761\uff0c\u8054\u673a\u67e5\u8be2\u5931\u8d25%3$s\u6761\u3002", (String)"DetailCompletionStatListPlugin_9", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), idList.size(), successCount, failCount));
            }
        }
    }

    public boolean downLoadFromBank(DetailSyncRecord record) {
        try {
            this.bizService.detail(record.getCustomID(), record.getAccNo(), record.getSyncDate(), record.getSyncDate(), record.getCurrency(), 0, 1, 20, true);
            return true;
        }
        catch (Exception ex) {
            this.logger.info("\u8d26\u53f7{}\u8054\u673a\u67e5\u8be2\u65e5\u671f{}\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", new Object[]{record.getAccNo(), record.getSyncDate(), ex});
            return false;
        }
    }
}

