/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.index;

import java.lang.constant.Constable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Position;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.lang.MultiLang;
import kd.ebg.aqap.formplugin.pojo.BusinessAmountGroup;
import kd.ebg.egf.common.framework.service.bank.BankVersionService;
import kd.ebg.egf.common.model.bank.BankListEntity;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;

public class BusinessAmountStatisticsPlugin
extends AbstractFormPlugin {
    private BankVersionService bankVersionService = (BankVersionService)SpringContextUtil.getBean(BankVersionService.class);

    public void afterCreateNewData(EventObject e) {
        this.fillDefaultValue();
        this.drawChart();
    }

    public void customEvent(CustomEventArgs e) {
        if ("refreshFromGridContainer".equalsIgnoreCase(e.getKey())) {
            this.fillDefaultValue();
            this.drawChart();
        }
    }

    private void fillDefaultValue() {
        Date defaultEndDate = new Date();
        Date defaultStartDate = DateUtil.getLastDay((Date)defaultEndDate, (int)1);
        this.getModel().setValue("start_date", (Object)defaultStartDate);
        this.getModel().setValue("end_date", (Object)defaultEndDate);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("end_date".equalsIgnoreCase(key)) {
            if (DateUtil.getDayDiff((Date)((Date)this.getModel().getValue("start_date")), (Date)((Date)this.getModel().getValue("end_date"))) > 6L) {
                this.getView().showTipNotification(MultiLang.getOverSevenDaysTip());
                return;
            }
            this.drawChart();
        }
    }

    private void drawChart() {
        HistogramChart customchart = (HistogramChart)this.getControl("histogramchartap");
        customchart.clearData();
        Axis categoryAxis = this.createCategoryAxis(MultiLang.getDateTip(), true);
        this.createValueAxis(MultiLang.getTransAmountTip(), false);
        List<Date> dates = this.getDateList();
        ArrayList categories = new ArrayList();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        dates.forEach(monthStartDate -> categories.add(format.format((Date)monthStartDate)));
        categoryAxis.setCategorys(categories);
        Map<BusinessAmountGroup, List<Number>> sortedData = this.getData(dates);
        sortedData.forEach((group, data) -> this.createBarSeries(group.groupName, (List<Number>)data, group.color));
        customchart.setMargin(Position.right, "50px");
        customchart.setMargin(Position.top, "30px");
        customchart.refresh();
    }

    private Map<BusinessAmountGroup, List<Number>> getData(List<Date> dates) {
        QFilter[] qFilters = new QFilter[3];
        String customID = RequestContext.get().getTenantId();
        qFilters[0] = new QFilter("custom_id", "=", (Object)customID);
        List<Long> bankVersionIdList = this.getAllEnableBankVersionIds(customID);
        qFilters[1] = new QFilter("bank_version.id", "in", bankVersionIdList);
        List<BusinessAmountGroup> groups = this.getBusinessAmountGroups();
        LinkedHashMap<BusinessAmountGroup, List<Number>> summaryResult = new LinkedHashMap<BusinessAmountGroup, List<Number>>(16);
        for (BusinessAmountGroup group : groups) {
            ArrayList initialBillCountList = new ArrayList(16);
            summaryResult.put(group, initialBillCountList);
        }
        int successStatus = PaymentState.SUCCESS.getId();
        int failStatus = PaymentState.FAIL.getId();
        for (Date date : dates) {
            qFilters[2] = QFilter.of((String)"SUBSTRING(insert_time,1,10) = ?", (Object[])new Object[]{DateUtil.formatDate((Date)date, (String)"yyyy-MM-dd")});
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"aqap_bd_paymentinfo", (String)("sum(case when status_id=" + successStatus + " then amount else 0 end) as success_count, sum(case when status_id=" + failStatus + " then amount else 0 end) as fail_count, sum(case when (status_id!=" + successStatus + " and status_id!=" + failStatus + ") then amount else 0 end) as other_count "), (QFilter[])qFilters);
            for (BusinessAmountGroup group : groups) {
                ((List)summaryResult.get(group)).add(dynamicObject != null ? (Number)BusinessAmountStatisticsPlugin.getResult(dynamicObject.getLong(group.fieldName)) : (Number)0);
            }
        }
        return summaryResult;
    }

    public static Number getResult(Long val) {
        String result = String.format("%.2f", (double)val.longValue() / 1000.0);
        try {
            return NumberFormat.getInstance().parse(result);
        }
        catch (ParseException parseException) {
            return 0;
        }
    }

    private List<Long> getAllEnableBankVersionIds(String customId) {
        List bankVersionList = this.bankVersionService.findByCustomId(customId);
        if (CollectionUtil.isEmpty((Collection)bankVersionList)) {
            return null;
        }
        ArrayList<Long> bankVersionIdList = new ArrayList<Long>(1);
        for (BankListEntity bankListEntity : bankVersionList) {
            bankVersionIdList.add(Long.valueOf(bankListEntity.getId()));
        }
        return bankVersionIdList;
    }

    private List<BusinessAmountGroup> getBusinessAmountGroups() {
        return BusinessAmountGroup.getDefaultGroups();
    }

    private List<Date> getDateList() {
        Date startDate = (Date)this.getModel().getValue("start_date");
        Date endDate = (Date)this.getModel().getValue("end_date");
        if (startDate == null || endDate == null) {
            endDate = new Date();
            startDate = DateUtil.getLastDay((Date)endDate, (int)1);
        }
        ArrayList<Date> dates = new ArrayList<Date>(16);
        Date date = startDate;
        while (date.getTime() <= endDate.getTime()) {
            dates.add(date);
            date = DateUtil.getNextDay((Date)date, (int)1);
        }
        return dates;
    }

    private HistogramChart getMainChart() {
        return (HistogramChart)this.getControl("histogramchartap");
    }

    private Axis createCategoryAxis(String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.category) : this.getMainChart().createYAxis(name, AxisType.category);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        this.setLineColor(axis, "#999999");
        return axis;
    }

    private Axis createValueAxis(String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.value) : this.getMainChart().createYAxis(name, AxisType.value);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        this.setLineColor(axis, "#999999");
        this.getMainChart().setShowTooltip(true);
        return axis;
    }

    private void createBarSeries(String name, List<Number> values, String color) {
        BarSeries barSeries = this.getMainChart().createBarSeries(name);
        barSeries.setBarWidth("20px");
        barSeries.setColor(color);
        barSeries.setAnimationDuration(2000);
        barSeries.setData(values.toArray(new Number[0]));
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }
}

