/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.index;

import java.lang.constant.Constable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.lang.MultiLang;
import kd.ebg.aqap.formplugin.plugin.util.ShowPageUtil;
import kd.ebg.aqap.formplugin.pojo.BusinessAmountGroup;
import kd.ebg.egf.common.framework.service.bank.BankVersionService;
import kd.ebg.egf.common.model.bank.BankListEntity;
import kd.ebg.egf.common.utils.collect.CollectionUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;

public class BusinessStatusStatisticsPlugin
extends AbstractFormPlugin {
    private BankVersionService bankVersionService = (BankVersionService)SpringContextUtil.getBean(BankVersionService.class);
    private int packaged_num = 0;
    private int submitting_num = 0;
    private int submited_num = 0;
    private int success_num = 0;
    private int fail_num = 0;
    private int unknown_num = 0;
    private int all_num_count = 0;

    public void registerListener(EventObject e) {
        Label label = (Label)this.getView().getControl("packaged_num");
        label.addClickListener((ClickListener)this);
        Label label2 = (Label)this.getView().getControl("submitting_num");
        label2.addClickListener((ClickListener)this);
        Label label3 = (Label)this.getView().getControl("submited_num");
        label3.addClickListener((ClickListener)this);
        Label label4 = (Label)this.getView().getControl("success_num");
        label4.addClickListener((ClickListener)this);
        Label label5 = (Label)this.getView().getControl("fail_num");
        label5.addClickListener((ClickListener)this);
        Label label6 = (Label)this.getView().getControl("unknown_num");
        label6.addClickListener((ClickListener)this);
        Label label7 = (Label)this.getView().getControl("all_num_count");
        label7.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Label) {
            Date startDate;
            Date endDate;
            HashMap<String, Object> customParams = new HashMap<String, Object>(16);
            if (this.getModel().getValue("start_date") == null) {
                endDate = new Date();
                startDate = this.getDefaultStartDate(endDate);
            } else {
                endDate = (Date)this.getModel().getValue("end_date");
                startDate = (Date)this.getModel().getValue("start_date");
            }
            customParams.put("trans_date_start", startDate);
            customParams.put("trans_date_end", endDate);
            Label label = (Label)evt.getSource();
            if (StringUtils.equals((CharSequence)"show_query_pay", (CharSequence)label.getOperationKey())) {
                Integer status_id = null;
                switch (label.getKey()) {
                    case "packaged_num": {
                        status_id = PaymentState.PACKAGED.getId();
                        break;
                    }
                    case "submitting_num": {
                        status_id = PaymentState.SUBMITTING.getId();
                        break;
                    }
                    case "submited_num": {
                        status_id = PaymentState.SUBMITED.getId();
                        break;
                    }
                    case "success_num": {
                        status_id = PaymentState.SUCCESS.getId();
                        break;
                    }
                    case "fail_num": {
                        status_id = PaymentState.FAIL.getId();
                        break;
                    }
                    case "unknown_num": {
                        status_id = PaymentState.UNKNOWN.getId();
                    }
                }
                if (status_id != null) {
                    customParams.put("status_msg", String.valueOf(status_id));
                }
                ShowPageUtil.showListPage("aqap_query_pay", customParams, this.getView());
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.fillDefaultValue();
        this.showData();
    }

    public void customEvent(CustomEventArgs e) {
        if ("refreshFromGridContainer".equalsIgnoreCase(e.getKey())) {
            this.fillDefaultValue();
            this.showData();
        }
    }

    private void fillDefaultValue() {
        Date defaultEndDate = new Date();
        Date defaultStartDate = this.getDefaultStartDate(defaultEndDate);
        this.getModel().setValue("start_date", (Object)defaultStartDate);
        this.getModel().setValue("end_date", (Object)defaultEndDate);
    }

    Date getDefaultStartDate(Date endDate) {
        Date defaultStartDate = DateUtil.getLastDay((Date)endDate, (int)1);
        String defaultStartStr = DateUtil.formatDate((Date)defaultStartDate, (String)"yyyy-MM-dd");
        defaultStartStr = defaultStartStr + " 00:00:00";
        defaultStartDate = DateUtil.string2Date((String)defaultStartStr, (String)"yyyy-MM-dd HH:mm:ss");
        return defaultStartDate;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("end_date".equalsIgnoreCase(key)) {
            String endStartStr = DateUtil.formatDate((Date)((Date)this.getModel().getValue("end_date")), (String)"yyyy-MM-dd");
            endStartStr = endStartStr + " 23:59:59";
            this.getModel().setValue("end_date", (Object)DateUtil.string2Date((String)endStartStr, (String)"yyyy-MM-dd HH:mm:ss"));
            if (DateUtil.getDayDiff((Date)((Date)this.getModel().getValue("start_date")), (Date)((Date)this.getModel().getValue("end_date"))) > 7L && this.getModel().getContextVariable("showTips") == null) {
                this.getView().showTipNotification(MultiLang.getOverSevenDaysTip());
                this.getModel().putContextVariable("showTips", (Object)Boolean.TRUE);
                return;
            }
            this.showData();
        }
    }

    private void drawChart() {
        HistogramChart customchart = (HistogramChart)this.getControl("histogramchartap");
        customchart.clearData();
        Axis categoryAxis = this.createCategoryAxis(MultiLang.getDateTip(), true);
        this.createValueAxis(MultiLang.getTransAmountTip(), false);
        List<Date> dates = this.getDateList();
        ArrayList categories = new ArrayList();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        dates.forEach(monthStartDate -> categories.add(format.format((Date)monthStartDate)));
        categoryAxis.setCategorys(categories);
        Map<BusinessAmountGroup, List<Number>> sortedData = this.getData(dates);
        sortedData.forEach((group, data) -> this.createBarSeries(group.groupName, (List<Number>)data, group.color));
        customchart.setMargin(Position.right, "50px");
        customchart.setMargin(Position.top, "30px");
        customchart.refresh();
    }

    private Map<BusinessAmountGroup, List<Number>> getData(List<Date> dates) {
        QFilter[] qFilters = new QFilter[3];
        String customID = RequestContext.get().getTenantId();
        qFilters[0] = new QFilter("custom_id", "=", (Object)customID);
        List<String> bankVersionIdList = this.getAllEnableBankVersionIds(customID);
        qFilters[1] = new QFilter("bank_version_id", "in", bankVersionIdList);
        List<BusinessAmountGroup> groups = this.getBusinessAmountGroups();
        LinkedHashMap<BusinessAmountGroup, List<Number>> summaryResult = new LinkedHashMap<BusinessAmountGroup, List<Number>>(16);
        for (BusinessAmountGroup group : groups) {
            ArrayList initialBillCountList = new ArrayList(16);
            summaryResult.put(group, initialBillCountList);
        }
        int successStatus = PaymentState.SUCCESS.getId();
        int failStatus = PaymentState.FAIL.getId();
        for (Date date : dates) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String startDate = DateUtil.formatDate((Date)date, (String)"yyyy-MM-dd") + " 00:00:00";
            LocalDateTime startDateTime = LocalDateTime.parse(startDate, formatter);
            String endDate = DateUtil.formatDate((Date)date, (String)"yyyy-MM-dd") + " 23:59:59";
            LocalDateTime endDateTime = LocalDateTime.parse(endDate, formatter);
            qFilters[2] = QFilter.of((String)"insert_time >= ? and insert_time <= ?", (Object[])new Object[]{startDateTime, endDateTime});
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"aqap_bd_paymentinfo", (String)("sum(case when status_id=" + successStatus + " then amount else 0 end) as success_count, sum(case when status_id=" + failStatus + " then amount else 0 end) as fail_count, sum(case when (status_id!=" + successStatus + " and status_id!=" + failStatus + ") then amount else 0 end) as other_count "), (QFilter[])qFilters);
            if (dynamicObjectCollection.size() <= 0) continue;
            for (BusinessAmountGroup group : groups) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(0);
                ((List)summaryResult.get(group)).add(dynamicObject != null ? (Number)BusinessStatusStatisticsPlugin.getResult(dynamicObject.getLong(group.fieldName)) : (Number)0);
            }
        }
        return summaryResult;
    }

    private void showData() {
        this.loadData();
        Label label1 = (Label)this.getControl("packaged_num");
        label1.setText(this.packaged_num + "");
        Label label2 = (Label)this.getControl("submitting_num");
        label2.setText(this.submitting_num + "");
        Label label3 = (Label)this.getControl("submited_num");
        label3.setText(this.submited_num + "");
        Label label4 = (Label)this.getControl("success_num");
        label4.setText(this.success_num + "");
        Label label5 = (Label)this.getControl("fail_num");
        label5.setText(this.fail_num + "");
        Label label7 = (Label)this.getControl("unknown_num");
        label7.setText(this.unknown_num + "");
        Label label8 = (Label)this.getControl("all_num_count");
        label8.setText(this.all_num_count + "");
    }

    private void loadData() {
        String customId;
        List<String> bankVersionIds;
        Date startDate = (Date)this.getModel().getValue("start_date");
        Date endDate = (Date)this.getModel().getValue("end_date");
        if (endDate == null) {
            endDate = new Date();
            startDate = this.getDefaultStartDate(endDate);
        }
        if (CollectionUtil.isEmpty(bankVersionIds = this.getAllEnableBankVersionIds(customId = RequestContext.get().getTenantId()))) {
            return;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("custom_id", "=", (Object)customId), QFilter.of((String)"insert_time >= ? and insert_time <= ?", (Object[])new Object[]{startDate, endDate}), new QFilter("bank_version_id", "in", bankVersionIds)};
        int packageStatus = PaymentState.PACKAGED.getId();
        int submittingStatus = PaymentState.SUBMITTING.getId();
        int submitedStatus = PaymentState.SUBMITED.getId();
        int unknownStatus = PaymentState.UNKNOWN.getId();
        int successStatus = PaymentState.SUCCESS.getId();
        int failStatus = PaymentState.FAIL.getId();
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"aqap_bd_paymentinfo", (String)("sum(case when status_id=" + packageStatus + " then 1 else 0 end) as packaged_num,  sum(case when status_id=" + submittingStatus + "  then 1 else 0 end) as submitting_num,  sum(case when status_id=" + submitedStatus + "  then 1 else 0 end) as submited_num,  sum(case when status_id=" + unknownStatus + "  then 1 else 0 end) as unknown_num,  sum(case when status_id=" + successStatus + "  then 1 else 0 end) as success_num,  sum(case when status_id=" + failStatus + "  then 1 else 0 end) as fail_num,  sum(1) as all_num_count"), (QFilter[])qFilters);
        if (dynamicObjectCollection.size() > 0) {
            DynamicObject statusNumResult = (DynamicObject)dynamicObjectCollection.get(0);
            this.packaged_num = statusNumResult.getInt("packaged_num");
            this.submitting_num = statusNumResult.getInt("submitting_num");
            this.submited_num = statusNumResult.getInt("submited_num");
            this.unknown_num = statusNumResult.getInt("unknown_num");
            this.success_num = statusNumResult.getInt("success_num");
            this.fail_num = statusNumResult.getInt("fail_num");
            this.all_num_count = statusNumResult.getInt("all_num_count");
        }
    }

    public static Number getResult(Long val) {
        String result = String.format("%.2f", (double)val.longValue() / 1000.0);
        try {
            return NumberFormat.getInstance().parse(result);
        }
        catch (ParseException parseException) {
            return 0;
        }
    }

    private List<String> getAllEnableBankVersionIds(String customId) {
        List bankVersionList = this.bankVersionService.findByCustomId(customId);
        if (CollectionUtil.isEmpty((Collection)bankVersionList)) {
            return null;
        }
        ArrayList<String> bankVersionIdList = new ArrayList<String>(1);
        for (BankListEntity bankListEntity : bankVersionList) {
            bankVersionIdList.add(bankListEntity.getNumber());
        }
        return bankVersionIdList;
    }

    private List<BusinessAmountGroup> getBusinessAmountGroups() {
        return BusinessAmountGroup.getDefaultGroups();
    }

    private List<Date> getDateList() {
        Date startDate = (Date)this.getModel().getValue("start_date");
        Date endDate = (Date)this.getModel().getValue("end_date");
        if (startDate == null || endDate == null) {
            endDate = new Date();
            startDate = DateUtil.getLastDay((Date)endDate, (int)1);
        }
        ArrayList<Date> dates = new ArrayList<Date>(16);
        Date date = startDate;
        while (date.getTime() <= endDate.getTime()) {
            dates.add(date);
            date = DateUtil.getNextDay((Date)date, (int)1);
        }
        return dates;
    }

    private HistogramChart getMainChart() {
        return (HistogramChart)this.getControl("histogramchartap");
    }

    private Axis createCategoryAxis(String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.category) : this.getMainChart().createYAxis(name, AxisType.category);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        this.setLineColor(axis, "#999999");
        return axis;
    }

    private Axis createValueAxis(String name, boolean isX) {
        Axis axis = null;
        axis = isX ? this.getMainChart().createXAxis(name, AxisType.value) : this.getMainChart().createYAxis(name, AxisType.value);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        axis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        axis.setPropValue("splitLine", splitLine);
        this.setLineColor(axis, "#999999");
        this.getMainChart().setShowTooltip(true);
        return axis;
    }

    private void createBarSeries(String name, List<Number> values, String color) {
        BarSeries barSeries = this.getMainChart().createBarSeries(name);
        barSeries.setBarWidth("20px");
        barSeries.setColor(color);
        barSeries.setAnimationDuration(2000);
        barSeries.setData(values.toArray(new Number[0]));
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }
}

