/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.paramsconfig;

import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.ebg.aqap.formplugin.plugin.common.EbcAddBankListPlugin;
import kd.ebg.egf.common.log.EBGLogger;
import org.apache.commons.lang3.StringUtils;

public class DetailNoteRuleConfigListPlugin
extends EbcAddBankListPlugin {
    public static List<String> TENANT_LIST = Arrays.asList("tenant_feature_sit_fi_test", "tenant_devfi_dev");
    EBGLogger log = EBGLogger.getInstance().getLogger(DetailNoteRuleConfigListPlugin.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String tenantID = RequestContext.get().getTenantId();
        boolean isHide = TENANT_LIST.contains(tenantID);
        this.getView().setVisible(Boolean.valueOf(isHide), new String[]{"tblnew", "baritemap1", "tbldel", "tblnamehistory"});
        this.getView().setVisible(Boolean.valueOf("tenant_devfi_dev".equals(tenantID)), new String[]{"export_ksql"});
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.isCancel()) {
            return;
        }
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("new".equals(operateKey) || "modify".equals(operateKey) || "enable".equals(operateKey) || "disable".equalsIgnoreCase(operateKey)) {
            this.log.monitorFeature("sk_2024_037_013", "aqap_detail_note_config", operateKey, "DetailNoteRuleConfigListPlugin");
        }
        if ("modify".equalsIgnoreCase(formOperate.getOperateKey())) {
            ListSelectedRow s = args.getListSelectedData().get(0);
            Object pk = s.getPrimaryKeyValue();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"aqap_detail_note_config");
            if (dynamicObject != null) {
                dynamicObject.set("status", (Object)"A");
                SaveServiceHelper.update((DynamicObject)dynamicObject);
            }
        } else if ("disable".equalsIgnoreCase(formOperate.getOperateKey()) || "enable".equalsIgnoreCase(formOperate.getOperateKey()) || "delete".equalsIgnoreCase(formOperate.getOperateKey())) {
            ListSelectedRow s = args.getListSelectedData().get(0);
            Object pk = s.getPrimaryKeyValue();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"aqap_detail_note_config");
            if (dynamicObject != null) {
                dynamicObject.set("status", (Object)("disable".equalsIgnoreCase(formOperate.getOperateKey()) ? "C" : "A"));
                SaveServiceHelper.update((DynamicObject)dynamicObject);
            }
        } else if ("export_ksql".equalsIgnoreCase(operateKey)) {
            if (listSelectedData.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5bfc\u51fa\u591a\u6761\u8bb0\u5f55", (String)"", (String)"", (Object[])new Object[0]));
                return;
            }
            ListSelectedRow listSelectedRow = listSelectedData.get(0);
            String billStatus = listSelectedRow.getBillStatus();
            Object[] pkids = listSelectedData.getPrimaryKeyValues();
            Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((Object[])pkids, (String)"aqap_detail_note_config");
            ArrayList<String> bankVersionList = new ArrayList<String>(16);
            for (DynamicObject dynamicObject : objectDynamicObjectMap.values()) {
                long group = dynamicObject.getLong("group.id");
                bankVersionList.add(String.valueOf(group));
            }
            StringBuilder sql = new StringBuilder();
            Map collection = BusinessDataServiceHelper.loadFromCache((String)"aqap_custom_note", (String)"ID", (QFilter[])QFilter.of((String)"BANK_VERSION = ?", (Object[])new Object[]{Long.parseLong((String)bankVersionList.get(0))}).toArray());
            ArrayList<String> customIdList = new ArrayList<String>(16);
            for (DynamicObject dynamicObject : collection.values()) {
                customIdList.add(String.valueOf(dynamicObject.getLong("id")));
            }
            String costomNoteSelect = "FID,FNUMBER,FNAME,FSTATUS,FCREATORID,FMODIFIERID,FENABLE,FCREATETIME,FMODIFYTIME,FMASTERID,FBANK_VERSION";
            String costomNoteWhere = "FBANK_VERSION IN (" + String.join((CharSequence)",", bankVersionList) + ")";
            PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
            Map customMap = builder.genInsertSQLScript(new DBRoute("ebg"), "T_AQAP_CUSTOM_NOTE", costomNoteSelect, costomNoteWhere, null, null);
            sql.append(customMap.get("sql"));
            sql.append("\r\n");
            String costomNoteLSelect = "FPKID,FID,FLOCALEID,FNAME";
            String costomNoteLWhere = "FID IN (" + String.join((CharSequence)",", customIdList) + ") AND FLOCALEID = 'zh_CN'";
            Map customLMap = builder.genInsertSQLScript(new DBRoute("ebg"), "T_AQAP_CUSTOM_NOTE_L", costomNoteLSelect, costomNoteLWhere, null, null);
            sql.append(customLMap.get("sql"));
            sql.append("\r\n");
            String detailNoteConfigSelect = "FID,FNUMBER,FNAME,FSTATUS,FCREATORID,FMODIFIERID,FENABLE,FCREATETIME,FMODIFYTIME,FMASTERID,FGROUPID,FDETAIL_INTERFACE,FBANK_VERSION,FFIELD_NAME";
            String detailNoteConfigSelectWhere = "FID IN (" + listSelectedRow.getPrimaryKeyValue() + ")";
            Map detailNoteMap = builder.genInsertSQLScript(new DBRoute("ebg"), "T_AQAP_DETAIL_NOTE_CONFIG", detailNoteConfigSelect, detailNoteConfigSelectWhere, null, null);
            sql.append(detailNoteMap.get("sql"));
            sql.append("\r\n");
            String detailNoteRuleSelect = "FID,FENTRYID,FSEQ,FDETAIL_FIELD,FLOGIC";
            String detailNoteRuleWhere = "FID IN (" + listSelectedRow.getPrimaryKeyValue() + ")";
            Map detailNoteRuleMap = builder.genInsertSQLScript(new DBRoute("ebg"), "T_AQAP_DETAIL_NOTE_RULE", detailNoteRuleSelect, detailNoteRuleWhere, null, null);
            sql.append(detailNoteRuleMap.get("sql"));
            sql.append("\r\n");
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl("kd_X.X.X_detail_note_config.sql", sql.toString().getBytes(StandardCharsets.UTF_8), 5000);
            this.getView().openUrl(url);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        HashSet bankVersion = new HashSet();
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"aqap_detail_note_config", (String)"bank_version", null);
        dynamicObjectCollection.forEach(aqap_detail_note_config -> bankVersion.add(aqap_detail_note_config.getString("bank_version")));
        DynamicObjectCollection detailNoteConfigs = this.getDetailNoteConfig();
        ArrayList bankList = Lists.newArrayList();
        detailNoteConfigs.forEach(detailNoteConfig -> bankList.add(detailNoteConfig.getString("object_id")));
        DynamicObjectCollection detailNoteDetailConfigs = this.getDetailNoteDetailConfig(bankList);
        detailNoteDetailConfigs.forEach(detailNoteDetailConfig -> {
            String attr_value = detailNoteDetailConfig.getString("attr_value");
            String object_id = detailNoteDetailConfig.getString("object_id");
            if (!bankVersion.contains(object_id)) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"aqap_detail_note_config");
                DynamicObjectCollection aqap_detail_note_rule = dynamicObject.getDynamicObjectCollection("aqap_detail_note_rule");
                DynamicObjectType dynamicObjectType = aqap_detail_note_rule.getDynamicObjectType();
                long fid = ID.genLongId();
                dynamicObject.set("id", (Object)fid);
                dynamicObject.set("status", (Object)"C");
                dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
                dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
                dynamicObject.set("enable", (Object)"1");
                Date insertTime = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
                dynamicObject.set("createtime", (Object)insertTime);
                dynamicObject.set("modifytime", (Object)insertTime);
                dynamicObject.set("masterid", (Object)fid);
                DynamicObject data = BusinessDataServiceHelper.loadSingle((String)"aqap_bank", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)object_id)});
                if (data != null) {
                    dynamicObject.set("group", (Object)data.getLong("id"));
                }
                dynamicObject.set("bank_version", (Object)object_id);
                List lists = Lists.newArrayList();
                if (StringUtils.isNotBlank((CharSequence)attr_value)) {
                    lists = SerializationUtils.fromJsonStringToList((String)attr_value, Map.class);
                }
                StringBuilder fieldName = new StringBuilder();
                for (int i = 0; i < lists.size(); ++i) {
                    Map configMap = (Map)lists.get(i);
                    String field = (String)configMap.get("field");
                    String id = (String)configMap.get("id");
                    String logic = (String)configMap.get("logic");
                    String append = ",";
                    if (logic.equalsIgnoreCase("or")) {
                        append = "/";
                    }
                    fieldName.append(field).append(append);
                    DynamicObject entity = new DynamicObject(dynamicObjectType);
                    entity.set("id", (Object)ID.genLongId());
                    entity.set("detail_field", (Object)fid);
                    entity.set("seq", (Object)(i + 1));
                    entity.set("detail_field", (Object)id);
                    entity.set("logic", (Object)logic);
                    aqap_detail_note_rule.add(i, entity);
                }
                if (StringUtils.isNotBlank((CharSequence)fieldName.toString())) {
                    dynamicObject.set("field_name", (Object)fieldName.substring(0, fieldName.length() - 1));
                } else {
                    dynamicObject.set("field_name", (Object)" ");
                }
                String number = object_id + "_" + ID.genStringId();
                dynamicObject.set("number", (Object)number);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            }
        });
        super.beforeCreateListDataProvider(args);
    }

    private DynamicObjectCollection getDetailNoteDetailConfig(List<String> bankList) {
        QFilter qFilter = QFilter.of((String)"attr_key=?", (Object[])new Object[]{"detail_note_select_detail"});
        qFilter.and(new QFilter("object_id", "in", bankList));
        return QueryServiceHelper.query((String)"aqap_object_properties", (String)"id, attr_key, attr_value, object_id", (QFilter[])qFilter.toArray());
    }

    DynamicObjectCollection getDetailNoteConfig() {
        QFilter qFilter = QFilter.of((String)"attr_key=?", (Object[])new Object[]{"detail_note_select"});
        return QueryServiceHelper.query((String)"aqap_object_properties", (String)"id, attr_key, attr_value, object_id", (QFilter[])qFilter.toArray());
    }

    DynamicObjectCollection getAvailableBankVersionDatas() {
        QFilter qFilter = QFilter.of((String)"status=? and enable=?", (Object[])new Object[]{"C", "1"});
        return QueryServiceHelper.query((String)"aqap_bank", (String)"id, number, name, bank_name, status, enable,note_status", (QFilter[])qFilter.toArray());
    }
}

