/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.pay;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.route.PayRoute;
import kd.ebg.aqap.business.payment.route.PayRouteCollection;
import kd.ebg.aqap.business.payment.route.PayRouteEnum;
import kd.ebg.aqap.business.payment.route.PayRouteTNode;
import kd.ebg.aqap.business.payment.route.PayRouteUtil;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.aqap.formplugin.plugin.pay.PayRouteNode;
import kd.ebg.aqap.formplugin.pojo.bizinfo.PropertyConfigInfo;
import kd.ebg.aqap.formplugin.pojo.bizinfo.PropertyConfigItemInfo;
import kd.ebg.aqap.formplugin.service.info.InfoService;
import kd.ebg.aqap.formplugin.util.JsonUtil;
import kd.ebg.aqap.formplugin.util.StringUtil;
import kd.ebg.aqap.formplugin.util.StringUtils;
import kd.ebg.aqap.proxy.oversea.bank.AbstractOverseaPayImpl;

public class PayRoutePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeQueryListener,
BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String KEY_TREEVIEW = "ebc_treeviewap";
    private static final String ROUTE_SEARCH = "show_route";
    private static final String KEY_SEARCH_INFO = "ebc_search_info";
    private static final String EB = "eb_payRoutePlugin_";
    private static final String EB_BANK_VERSION = "eb_payRouteBank_";
    private static final String entity = "aqap_bd_pay_route";
    private static final String properties = "id,node_id,parent_id,node_name,node_data,bank_version,node_level";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = this.getTreeView();
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        BasedataEdit bankVersionFieldEdit = (BasedataEdit)this.getView().getControl("bank_version");
        if (bankVersionFieldEdit != null) {
            bankVersionFieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            bankVersionFieldEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        BasedataEdit bankVersion = (BasedataEdit)this.getControl("bank_version");
        String bankVersionID = bankVersion.getModel().getDataEntity().getString("bank_version.number");
        this.getPageCache().put("eb_payRoutePlugin_bankVersionID", bankVersionID);
        if (StringUtil.equals(ROUTE_SEARCH, formOperate.getOperateKey())) {
            if (StringUtils.isEmpty(bankVersionID)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u53d6\u94f6\u884c\u7248\u672c\u3002", (String)"PayRoutePlugin_0", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            } else {
                TreeView treeView = this.getTreeView();
                treeView.setMulti(false);
                treeView.setRootVisible(true);
                treeView.setDraggable(false);
                treeView.setDroppable(false);
                this.init(treeView, bankVersionID);
                String searchInfo = (String)this.getView().getModel().getValue(KEY_SEARCH_INFO);
                if (StringUtils.isEmpty(searchInfo.replaceAll(" ", ""))) {
                    this.updateTreeBillAP(new HashMap<Integer, List<PayRouteNode>>(1));
                } else {
                    this.updateTreeBillAP(this.searchPayRoute(bankVersionID, searchInfo));
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5b8c\u6210\u3002", (String)"PayRoutePlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private TreeView getTreeView() {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        return treeView;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initBankVersionList();
    }

    private void initBankVersionList() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(16);
        String entityName = "aqap_pay_route_bank";
        QFilter filter = QFilter.of((String)"enable='1'", (Object[])new Object[0]);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)entityName, (String)"number,name", (QFilter[])filter.toArray());
        if (dynamicObjects != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(dynamicObject.getString("name")));
                comboItem.setValue(dynamicObject.getString("number"));
                comboItems.add(comboItem);
            }
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("combo_bank");
        comboEdit.setComboItems(comboItems);
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String bankVersionID = this.getPageCache().get("eb_payRoutePlugin_bankVersionID");
        List<PayRouteTNode> payRouteTNodeList = this.getTreeNodeListFromCache(bankVersionID);
        for (PayRouteTNode payRouteTNode : payRouteTNodeList) {
            if (!payRouteTNode.getNodeId().equalsIgnoreCase(evt.getNodeId().toString()) || payRouteTNode.getPayRouteEnum() != PayRouteEnum.IMPL) continue;
            this.getView().getModel().setValue(KEY_SEARCH_INFO, (Object)payRouteTNode.getData());
            break;
        }
        TreeView treeView = this.getTreeView();
        treeView.expand(evt.getNodeId().toString());
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        TreeView treeView = this.getTreeView();
        treeView.collapse(evt.getNodeId().toString());
    }

    private void saveNode(TreeNode treeNode, int level) {
        String nodeId = treeNode.getId();
        String parentId = treeNode.getParentid();
        String name = treeNode.getText();
        String data = (String)treeNode.getData();
        String bankVersion = treeNode.getType();
        QFilter filter = QFilter.of((String)"node_id=? and bank_version=?", (Object[])new Object[]{nodeId, bankVersion});
        boolean isExist = QueryServiceHelper.exists((String)entity, (QFilter[])filter.toArray());
        if (isExist) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)entity, (String)properties, (QFilter[])filter.toArray());
            dynamicObject.set("node_name", (Object)name);
            dynamicObject.set("node_data", (Object)data);
            dynamicObject.set("node_level", (Object)level);
            SaveServiceHelper.update((DynamicObject)dynamicObject);
        } else {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)entity);
            dynamicObject.set("node_id", (Object)nodeId);
            dynamicObject.set("parent_id", (Object)parentId);
            dynamicObject.set("node_name", (Object)name);
            dynamicObject.set("node_data", (Object)data);
            dynamicObject.set("bank_version", (Object)bankVersion);
            dynamicObject.set("node_level", (Object)level);
            dynamicObject.set("status", (Object)"A");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    public Map<Integer, Map<String, PayRouteTNode>> loadTNodesFromDB(String bankVersionID) {
        PayRouteCollection collection = new PayRouteCollection();
        QFilter filter = QFilter.of((String)"bank_version = ?", (Object[])new Object[]{bankVersionID});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"aqap_pay_route_rec", (String)"bank_version,sub_biz_type,individual,use_cn,same_bank,merge,currency,single,busconf,accprop,impl,source,urgent", (QFilter[])filter.toArray());
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                PayRoute payRoute = PayRouteUtil.transFormat((DynamicObject)dynamicObject);
                payRoute.setBankVersionID(bankVersionID);
                collection.addPayRoute(payRoute);
            }
        }
        return collection.transTNodes();
    }

    public void init(TreeView treeView, String bankVersionID) {
        if (StringUtils.isEmpty(bankVersionID)) {
            return;
        }
        treeView.deleteAllNodes();
        Map<Integer, Map<String, PayRouteTNode>> collections = this.loadTNodesFromDB(bankVersionID);
        if (collections.size() > 0) {
            ArrayList<PayRouteTNode> treeNodeList = new ArrayList<PayRouteTNode>(16);
            for (Map.Entry<Integer, Map<String, PayRouteTNode>> entry : collections.entrySet()) {
                Map<String, PayRouteTNode> payRouteNodeMap = entry.getValue();
                ArrayList<Map.Entry<String, PayRouteTNode>> list = new ArrayList<Map.Entry<String, PayRouteTNode>>(payRouteNodeMap.entrySet());
                Collections.sort(list, Comparator.comparing(Map.Entry::getKey));
                for (Map.Entry entry2 : list) {
                    PayRouteTNode payRouteNode = (PayRouteTNode)entry2.getValue();
                    payRouteNode.setBankVersionID(bankVersionID);
                    TreeNode treeNode = new TreeNode();
                    treeNode.setId(payRouteNode.getNodeId());
                    treeNode.setParentid(payRouteNode.getParentId());
                    if ("impl".equalsIgnoreCase(payRouteNode.getNodeName())) {
                        treeNode.setChildren(null);
                    } else {
                        treeNode.setChildren(new ArrayList(1));
                    }
                    PayRoutePlugin.setNodeNameCN(payRouteNode);
                    PayRoutePlugin.setTData(payRouteNode);
                    treeNode.setData((Object)this.getNodeText(payRouteNode));
                    treeNode.setText(this.getNodeText(payRouteNode));
                    treeNode.setIsOpened(entry.getKey() < 1);
                    treeNode.setType(payRouteNode.getNodeName());
                    treeView.addNode(treeNode);
                    treeNodeList.add(payRouteNode);
                }
            }
            this.cacheTreeNodeList(bankVersionID, treeNodeList);
        } else {
            TreeNode root = new TreeNode("", "root", ResManager.loadKDString((String)"\u94f6\u884c\u4ed8\u6b3e\u8def\u7531", (String)"PayRoutePlugin_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            root.setType(bankVersionID);
            root.setChildren(new ArrayList(1));
            treeView.addNode(root);
            treeView.expand("root");
            this.saveNode(root, 0);
        }
    }

    public void cacheTreeNodeList(String bankVersionID, List<PayRouteTNode> payRouteTNodeList) {
        this.getPageCache().put(EB_BANK_VERSION + bankVersionID, JsonUtil.toJson(payRouteTNodeList));
    }

    public List<PayRouteTNode> getTreeNodeListFromCache(String bankVersionID) {
        String s = this.getPageCache().get(EB_BANK_VERSION + bankVersionID);
        ArrayList payRouteTNodeList = JSONObject.parseArray((String)s, PayRouteTNode.class);
        if (payRouteTNodeList == null) {
            payRouteTNodeList = new ArrayList(1);
        }
        return payRouteTNodeList;
    }

    public String getNodeText(PayRouteTNode payRouteNode) {
        StringBuilder sb = new StringBuilder();
        sb.append(payRouteNode.getDesc()).append(' ').append(payRouteNode.getNodeNameCN()).append('=').append(payRouteNode.getData());
        return sb.toString();
    }

    public List<PayRouteNode> searchParentRoute(List<PayRouteTNode> payRouteTNodeList, String pid) {
        ArrayList<PayRouteNode> payRouteNodeList = new ArrayList<PayRouteNode>(16);
        for (PayRouteTNode tNode : payRouteTNodeList) {
            if (tNode.getId() == null || !tNode.getNodeId().equalsIgnoreCase(pid)) continue;
            String parentID = tNode.getParentId();
            PayRouteNode payRouteNode = new PayRouteNode();
            payRouteNode.setId(tNode.getNodeId());
            payRouteNode.setParentId(parentID);
            payRouteNode.setBankVerion(tNode.getBankVersionID());
            payRouteNode.setLevel(tNode.getLevel());
            PayRoutePlugin.setNodeNameCN(tNode);
            PayRoutePlugin.setTData(tNode);
            payRouteNode.setData(tNode.getText());
            payRouteNode.setTimestamp(System.currentTimeMillis());
            payRouteNode.setName(tNode.getDesc());
            if (StringUtil.isNotNil(parentID)) {
                payRouteNodeList.addAll(this.searchParentRoute(payRouteTNodeList, parentID));
            }
            payRouteNodeList.add(payRouteNode);
        }
        return payRouteNodeList;
    }

    public Map<Integer, List<PayRouteNode>> searchPayRoute(String bankVersionID, String interfaceName) {
        HashMap<Integer, List<PayRouteNode>> result = new HashMap<Integer, List<PayRouteNode>>(16);
        int i = 1;
        List<PayRouteTNode> payRouteTNodeList = this.getTreeNodeListFromCache(bankVersionID);
        if (payRouteTNodeList != null && payRouteTNodeList.size() > 0) {
            for (PayRouteTNode tNode : payRouteTNodeList) {
                if (tNode.getPayRouteEnum() != PayRouteEnum.IMPL || !tNode.getData().contains(interfaceName)) continue;
                ArrayList<PayRouteNode> payRouteNodeList = new ArrayList<PayRouteNode>(16);
                String parentID = tNode.getParentId();
                PayRouteNode payRouteNode = new PayRouteNode();
                payRouteNode.setId(tNode.getNodeId());
                payRouteNode.setParentId(parentID);
                payRouteNode.setBankVerion(bankVersionID);
                payRouteNode.setLevel(tNode.getLevel());
                payRouteNode.setData(tNode.getText());
                payRouteNode.setTimestamp(System.currentTimeMillis());
                payRouteNode.setName(tNode.getDesc());
                payRouteNodeList.addAll(this.searchParentRoute(payRouteTNodeList, parentID));
                payRouteNodeList.add(payRouteNode);
                result.put(i++, payRouteNodeList);
            }
        }
        return result;
    }

    private void updateTreeBillAP(Map<Integer, List<PayRouteNode>> listMap) {
        IDataModel entryOperate = this.getModel();
        entryOperate.deleteEntryData("ebc_treeentryentity");
        for (Map.Entry<Integer, List<PayRouteNode>> entry : listMap.entrySet()) {
            List<PayRouteNode> payRouteNodeList = entry.getValue();
            PayRouteNode payRouteNode = new PayRouteNode();
            int parentRow = this.addRow(payRouteNode, true, 0, entry.getKey(), 0);
            for (int i = 0; i < payRouteNodeList.size(); ++i) {
                payRouteNode = payRouteNodeList.get(i);
                this.addRow(payRouteNode, false, parentRow, entry.getKey(), i + 1);
            }
        }
    }

    private int addRow(PayRouteNode payRouteNode, boolean isParent, int pRow, int no, int count) {
        String node_name = payRouteNode.getName();
        String node_data = payRouteNode.getData();
        int row = 0;
        IDataModel entryOperate = this.getModel();
        row = isParent ? entryOperate.createNewEntryRow("ebc_treeentryentity") : entryOperate.insertEntryRow("ebc_treeentryentity", pRow);
        this.getModel().setValue("ebc_textfield1", (Object)String.format(ResManager.loadKDString((String)"\u8def\u7531\u65b9\u6848%s", (String)"PayRoutePlugin_6", (String)"ebg-aqap-formplugin", (Object[])new Object[0]), no), row);
        this.getModel().setValue("ebc_integerfield", (Object)count, row);
        this.getModel().setValue("ebc_textfield2", (Object)node_name, row);
        this.getModel().setValue("ebc_textfield3", (Object)node_data, row);
        return row;
    }

    public static void setNodeNameCN(PayRouteTNode tNode) {
        try {
            if (tNode.getPayRouteEnum() == PayRouteEnum.BUS_CONFIG) {
                PropertyConfigInfo propertyConfigInfo = ((InfoService)SpringContextUtil.getBean(InfoService.class)).getBankBusinessConfig(tNode.getBankVersionID());
                List<PropertyConfigItemInfo> propertyConfigItemInfoList = propertyConfigInfo.getConfigItems();
                Optional<PropertyConfigItemInfo> optional = propertyConfigItemInfoList.stream().filter(bankConfig -> bankConfig.getKey().equalsIgnoreCase(tNode.getNodeName())).findFirst();
                if (optional.isPresent()) {
                    PropertyConfigItemInfo bankConfig2 = optional.get();
                    if (bankConfig2 != null) {
                        if (bankConfig2.getName() == null) {
                            tNode.setNodeNameCN(bankConfig2.getMlName().loadKDString());
                        } else {
                            tNode.setNodeNameCN(bankConfig2.getName());
                        }
                    } else {
                        tNode.setNodeNameCN(tNode.getNodeName());
                    }
                } else {
                    tNode.setNodeNameCN(tNode.getNodeName());
                }
            } else {
                tNode.setNodeNameCN("");
            }
        }
        catch (Exception e) {
            tNode.setNodeNameCN("");
        }
    }

    public static void setTData(PayRouteTNode tNode) {
        block18: {
            if (tNode.getPayRouteEnum() == PayRouteEnum.BUS_CONFIG) {
                PropertyConfigInfo propertyConfigInfo = ((InfoService)SpringContextUtil.getBean(InfoService.class)).getBankBusinessConfig(tNode.getBankVersionID());
                List<PropertyConfigItemInfo> propertyConfigItemInfoList = propertyConfigInfo.getConfigItems();
                Optional<PropertyConfigItemInfo> optional = propertyConfigItemInfoList.stream().filter(bankConfig -> bankConfig.getKey().equalsIgnoreCase(tNode.getNodeName())).findFirst();
                if (optional.isPresent()) {
                    PropertyConfigItemInfo bankConfig2 = optional.get();
                    List<String> sourceValues = bankConfig2.getSourceValues();
                    if (sourceValues != null) {
                        for (int i = 0; i < sourceValues.size(); ++i) {
                            if (!sourceValues.get(i).equalsIgnoreCase(tNode.getExpectValue())) continue;
                            if (bankConfig2.getSourceNames() == null) {
                                tNode.setData(bankConfig2.getMlSourceNames().get(i).loadKDString());
                                continue;
                            }
                            tNode.setData(bankConfig2.getSourceNames().get(i));
                        }
                    } else {
                        tNode.setData(tNode.getExceptValueCN());
                    }
                } else {
                    tNode.setData(tNode.getExceptValueCN());
                }
            } else if (tNode.getPayRouteEnum() == PayRouteEnum.IMPL) {
                try {
                    Object obj = Class.forName(tNode.getExpectValue()).newInstance();
                    if (obj instanceof AbstractPayImpl) {
                        AbstractPayImpl pay = (AbstractPayImpl)obj;
                        tNode.setData(pay.getBizCode());
                        break block18;
                    }
                    if (obj instanceof AbstractOverseaPayImpl) {
                        AbstractOverseaPayImpl pay = (AbstractOverseaPayImpl)obj;
                        tNode.setData(pay.getBizCode());
                        break block18;
                    }
                    tNode.setData(tNode.getExpectValue());
                }
                catch (Exception e) {
                    tNode.setData(tNode.getExpectValue());
                }
            } else if ("true".equalsIgnoreCase(tNode.getExpectValue())) {
                tNode.setData(ResManager.loadKDString((String)"\u662f", (String)"PayRoutePlugin_4", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            } else if ("false".equalsIgnoreCase(tNode.getExpectValue())) {
                tNode.setData(ResManager.loadKDString((String)"\u5426", (String)"PayRoutePlugin_5", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
            } else {
                tNode.setData(tNode.getExceptValueCN());
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String entityName = "aqap_pay_route_rec";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)entityName, (String)"bank_version", (QFilter[])new QFilter[0]);
        HashSet<String> bankVersionSet = new HashSet<String>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            bankVersionSet.add(dynamicObject.getString("bank_version"));
        }
        String fieldKey = e.getProperty().getName();
        if ("bank_version".equalsIgnoreCase(fieldKey)) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(1);
            QFilter qFilter = new QFilter("number", "in", bankVersionSet);
            qFilters.add(qFilter);
            QFilter qFilter1 = new QFilter("bank_type", "<>", (Object)"6");
            qFilters.add(qFilter1);
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().setQFilters(qFilters);
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        ListSelectedRowCollection listSelectedRows = afterF7SelectEvent.getListSelectedRowCollection();
        if (listSelectedRows != null && listSelectedRows.size() == 1) {
            String selectedBankVersion = afterF7SelectEvent.getListSelectedRowCollection().get(0).getNumber();
            String bankVersionID = this.getPageCache().get("eb_payRoutePlugin_bankVersionID");
            if (StringUtil.isNotNil(bankVersionID) && !bankVersionID.equals(selectedBankVersion)) {
                this.updateTreeBillAP(new HashMap<Integer, List<PayRouteNode>>(1));
                TreeView treeView = this.getTreeView();
                treeView.deleteAllNodes();
            }
        }
    }
}

