/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.formplugin.plugin.reconciliation;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.ebg.aqap.common.framework.reconciliation.KDProcessorEnum;
import kd.ebg.aqap.formplugin.util.StringUtils;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.db.QueryCacheUtil;

public class HisReconciliationFormPlugin
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener {
    public static final String CONTENT_TYPE = "content_type";
    public static final String SKIP_FIRST_ROW = "is_skip_first_row";
    public static final String RECORD_NUM = "record_num";
    public static String properties = "id,group,number,name,biz_type,interface_code,content_type,node_name,node_path,bank_field_size,kd_flag,kd_size,is_merge,is_bank_ref,state,is_skip_first_row,record_num";

    public void propertyChanged(PropertyChangedArgs e) {
        if (CONTENT_TYPE.equalsIgnoreCase(e.getProperty().getName())) {
            this.showControl();
        }
    }

    public void beforeBindData(EventObject e) {
        this.showControl();
    }

    private void showControl() {
        String type = (String)this.getModel().getValue(CONTENT_TYPE);
        boolean isShow = KDProcessorEnum.XML_DATA_DOMAIN_KD_PROCESSOR.getName().equalsIgnoreCase(type);
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{SKIP_FIRST_ROW, RECORD_NUM});
    }

    public void afterBindData(EventObject e) {
        this.updateNumber();
    }

    private void updateNumber() {
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("group");
        String bankVersion = basedataEdit.getModel().getDataEntity().getString("group.number");
        this.getModel().setValue("bank_version_code", (Object)bankVersion);
        this.getView().updateView("bank_version_code");
        if (StringUtils.isEmpty((String)this.getModel().getValue("number"))) {
            String number = ID.genStringId();
            this.getModel().setValue("number", (Object)number);
            this.getModel().setValue("name", (Object)bankVersion);
            this.getView().updateView("number");
            this.getView().updateView("name");
        }
        String dateTimeStr = DateUtil.transTimeZoneSystemToUser((LocalDateTime)LocalDateTime.now());
        this.getModel().setValue("op_time", (Object)dateTimeStr);
        this.getView().updateView("op_time");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("save".equalsIgnoreCase(operateKey)) {
            boolean isBankRef = Boolean.parseBoolean((String)this.getModel().getValue("is_bank_ref"));
            String state = (String)this.getModel().getValue("state");
            int recordNum = (Integer)this.getModel().getValue(RECORD_NUM);
            if (recordNum == 0) {
                this.getModel().setValue(RECORD_NUM, (Object)1);
            }
            if (isBankRef && "0".equalsIgnoreCase(state)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u8bbe\u6570\u636e\u4e0d\u5141\u8bb8\u7981\u7528\u3002", (String)"ReconciliationFormPlugin_2", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                DynamicObject bankVersionDO;
                Long bankVersion;
                String number = (String)this.getModel().getValue("number");
                String nodeName = (String)this.getModel().getValue("node_name");
                String nodePath = (String)this.getModel().getValue("node_path");
                DynamicObject interfaceDO = (DynamicObject)this.getModel().getValue("interface_code");
                Long interfaceCode = interfaceDO.getLong("id");
                QFilter qFilter = QFilter.of((String)"interface_code=? and group=?", (Object[])new Object[]{interfaceCode, bankVersion = Long.valueOf((bankVersionDO = (DynamicObject)this.getModel().getValue("group")).getLong("id"))});
                List dynamicObjectList = QueryCacheUtil.getDynamicObjectList((String)"aqap_rc_history_rule", (String)properties, (QFilter[])qFilter.toArray());
                if (dynamicObjectList.size() > 0) {
                    for (DynamicObject dynamicObject : dynamicObjectList) {
                        boolean isSame = true;
                        if (status != OperationStatus.ADDNEW && number.equals(dynamicObject.getString("number"))) continue;
                        isSame = isSame && nodeName.equals(dynamicObject.getString("node_name"));
                        if (!(isSame = isSame && nodePath.equals(dynamicObject.getString("node_path")))) continue;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5f53\u524d\u94f6\u884c\u63a5\u53e3\u5bf9\u8d26\u7801\u5b57\u6bb5\u7684\u89c4\u5219\u3002", (String)"ReconciliationFormPlugin_1", (String)"ebg-aqap-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                    }
                }
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("interface_code");
        if (fieldEdit != null) {
            fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String bizType = (String)this.getModel().getValue("biz_type");
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("group");
        String bankVersionID = basedataEdit.getModel().getDataEntity().getString("group.number");
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(1);
        qFilterList.add(new QFilter("number", "=", (Object)bankVersionID));
        showParameter.getTreeFilterParameter().setQFilters(qFilterList);
        showParameter.getListFilterParameter().setFilter(new QFilter("group.number", "=", (Object)bankVersionID));
        showParameter.getListFilterParameter().setFilter(new QFilter("biz_type.number", "=", (Object)bizType));
    }
}

