/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hxb.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hxb.dc.utils.HXB_DC_Constants;
import kd.ebg.aqap.banks.hxb.dc.utils.ResponseStrUtil;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.model.bank.BankAcnt;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance,
HXB_DC_Constants {
    private static final String TRANS_CODE = "xhj0003";

    public String pack(BankBalanceRequest bankBalanceRequest) {
        BankAcnt bankAcnt = bankBalanceRequest.getAcnt();
        StringBuilder sb = new StringBuilder();
        sb.append(TRANS_CODE).append('#').append(bankAcnt.getAccNo()).append('#').append(bankBalanceRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd"))).append('#').append("@@@@");
        return sb.toString();
    }

    public EBBankBalanceResponse parse(BankBalanceRequest rqst, String responseStr) {
        responseStr = ResponseStrUtil.process(responseStr);
        EBBankBalanceResponse bankBalanceResponse = new EBBankBalanceResponse();
        BankAcnt bankAcnt = rqst.getAcnt();
        String cur = rqst.getBankCurrency();
        BalanceInfo balanceInfo = new BalanceInfo();
        this.setBankAcnt(balanceInfo, bankAcnt);
        String[] repInfo = responseStr.split("#");
        String response_code = repInfo[0];
        if ("000000".equals(response_code)) {
            String repAccNo = repInfo[1];
            this.setBankAcnt(balanceInfo, rqst.getBankAcntList(), repAccNo);
            String balanceOrTransDate = repInfo[2];
            String balance = repInfo[3];
            this.setCurrentBalance(balanceInfo, balance);
            this.setBankCurrency(balanceInfo, cur);
            this.setBalanceDateTime(balanceInfo, balanceOrTransDate + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
            bankBalanceResponse.setBalances((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
            return bankBalanceResponse;
        }
        throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)response_code, (String)""));
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return TRANS_CODE;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d\u67e5\u8be2", (String)"HisBalanceImpl_4", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]);
    }

    public int queryDays() {
        return 1;
    }
}

