/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hxb.dc.services.payment.individual.outterBank;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hxb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hxb.dc.services.payment.individual.outterBank.IndividualQueryPayImpl;
import kd.ebg.aqap.banks.hxb.dc.utils.HXBUseConvertor;
import kd.ebg.aqap.banks.hxb.dc.utils.HXB_DC_Constants;
import kd.ebg.aqap.banks.hxb.dc.utils.Packer;
import kd.ebg.aqap.banks.hxb.dc.utils.ResponseStrUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.utils.string.StringUtils;

public class IndividualPayImpl
extends AbstractPayImpl
implements IPay,
HXB_DC_Constants {
    public int getBatchSize() {
        return 1000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return IndividualQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "qiang";
    }

    public String getBizCode() {
        return "xhj2001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8de8\u884c\u5bf9\u516c\u5411\u5bf9\u79c1\u8f6c\u8d26\u3002", (String)"IndividualPayImpl_10", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && paymentInfo.is2Individual() && !paymentInfo.is2SameBank();
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        BigDecimal amout = new BigDecimal("0.00");
        for (PaymentInfo paymentInfo : paymentInfos) {
            amout = amout.add(paymentInfo.getAmount());
        }
        PaymentInfo paymenInfo = paymentInfos[0];
        StringBuilder sb = new StringBuilder();
        sb.append("xhj2001");
        sb.append('#');
        sb.append("9999999999");
        sb.append('#');
        sb.append(paymenInfo.getPackageId());
        sb.append('#');
        sb.append(paymenInfo.getAccNo());
        sb.append('#');
        sb.append(amout.setScale(2, 5).toString());
        sb.append('#');
        sb.append(String.valueOf(paymentInfos.length));
        sb.append('#');
        sb.append(paymenInfo.getExplanation());
        sb.append('#');
        StringBuilder cyc_str = new StringBuilder();
        boolean addKDFlagToPay = BankBusinessConfig.isAddKDFlagToPay();
        for (int i = 0; i < paymentInfos.length; ++i) {
            String busType = HXBUseConvertor.convert2HXBUseCn(paymentInfos[i]);
            String busStyle = "C210";
            if (!"009001".equalsIgnoreCase(busType)) {
                busStyle = "C209";
            }
            cyc_str.append(i + 1);
            cyc_str.append("|");
            cyc_str.append(paymentInfos[i].getIncomeCnaps());
            cyc_str.append("|");
            cyc_str.append(paymentInfos[i].getIncomeAccNo());
            cyc_str.append("|");
            cyc_str.append(paymentInfos[i].getIncomeAccName());
            cyc_str.append("|");
            cyc_str.append(busStyle);
            cyc_str.append("|");
            cyc_str.append(busType);
            cyc_str.append("|");
            if (addKDFlagToPay) {
                if (!StringUtils.isEmpty((String)paymentInfos[i].getExplanation())) {
                    cyc_str.append(Packer.getKDExp(paymentInfos[i]));
                } else {
                    cyc_str.append(Packer.getKDExp(paymentInfos[i], ""));
                }
            } else {
                cyc_str.append(paymentInfos[i].getExplanation());
            }
            cyc_str.append("|");
            cyc_str.append(paymentInfos[i].getAmount().setScale(2, 5).toString());
            cyc_str.append("|");
            cyc_str.append(paymentInfos[i].getExplanation());
            cyc_str.append("|");
            cyc_str.append('#');
        }
        String str = cyc_str.toString();
        sb.append(str);
        sb.append("@@@@");
        return sb.toString();
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        responseStr = ResponseStrUtil.process(responseStr);
        List paymentInfos = request.getPaymentInfos();
        String[] elements = StringUtils.split((String)responseStr, (String)"#");
        try {
            String responseCode = elements[0];
            String responseMsg = "";
            responseMsg = elements.length > 2 ? String.format(ResManager.loadKDString((String)"\u6279\u6b21\u53f7:%1$s;\u5907\u7528\u57df1:%2$s\u3002", (String)"IndividualPayImpl_11", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), elements[1], elements[2]) : String.format(ResManager.loadKDString((String)"\u62a5\u6587\u6807\u8bc6:%s\u3002", (String)"IndividualPayImpl_12", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), elements[0]);
            if ("000000".equalsIgnoreCase(responseCode)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u63a5\u6536", (String)"IndividualPayImpl_5", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)responseCode, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u63a5\u6536", (String)"IndividualPayImpl_5", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]));
            } else if ("EL4114".equalsIgnoreCase(responseCode)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"IndividualPayImpl_6", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)responseCode, (String)ResManager.loadKDString((String)"\u8d26\u53f7\u6216\u5361\u53f7\u65e0\u6548\u3002", (String)"IndividualPayImpl_7", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]));
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"IndividualPayImpl_8", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), (String)responseCode, (String)responseMsg);
            }
        }
        catch (Exception e) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5:%s\u3002", (String)"IndividualPayImpl_13", (String)"ebg-aqap-banks-hxb-dc", (Object[])new Object[0]), e.getMessage()), (String)"", (String)"");
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

