/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ynnx.dc.services.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ynnx.dc.services.Packer;
import kd.ebg.aqap.banks.ynnx.dc.services.Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest bankBalanceRequest) {
        return Packer.packBalance(bankBalanceRequest, this.getBizCode());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String rspStr) {
        Element root = Parser.parseString2Root(rspStr);
        Element head = JDomUtils.getChildElement((Element)root, (String)"Head");
        boolean success = Parser.parseRspHead(head);
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(1);
        if (success) {
            Element body = JDomUtils.getChildElement((Element)root, (String)"Body");
            Element map = JDomUtils.getChildElement((Element)body, (String)"Map");
            String acNo = JDomUtils.getChildText((Element)map, (String)"AcNo");
            String currency = JDomUtils.getChildText((Element)map, (String)"Currency");
            String balance = JDomUtils.getChildText((Element)map, (String)"Balance");
            String availBal = JDomUtils.getChildText((Element)map, (String)"AvailBal");
            BalanceInfo balanceInfo = new BalanceInfo();
            balanceInfos.add(balanceInfo);
            this.setBankAcnt(balanceInfo, bankBalanceRequest.getBankAcntList(), acNo);
            this.setBankCurrency(balanceInfo, bankBalanceRequest.getBankCurrency(), currency);
            this.setCurrentBalance(balanceInfo, balance);
            this.setAvailableBalance(balanceInfo, availBal);
            this.setBalanceDateTime(balanceInfo, LocalDateTime.now());
        }
        return new EBBankBalanceResponse(balanceInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "B2EActBalQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d26\u6237\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-ynnx-dc", (Object[])new Object[0]);
    }
}

