/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ocbc.dc.services.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ocbc.dc.services.OCBC_DC_Parser;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtils;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceParser {
    public static EBBankBalanceResponse parseTodayBalance(BankBalanceRequest rqst, String rsp) throws EBServiceException {
        EBBankBalanceResponse response = new EBBankBalanceResponse();
        Element root = JDomUtils.string2Root((String)rsp, (String)RequestContextUtils.getCharset());
        Element opRep = root.getChild("opRep");
        BankResponse bankRsp = OCBC_DC_Parser.parseHeader(opRep);
        if (!"000000".equalsIgnoreCase(bankRsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankRsp.getResponseCode(), (String)bankRsp.getResponseMessage()));
        }
        Element opResult = opRep.getChild("opResult");
        String ZHHA = opResult.getChildTextTrim("ZHHA");
        String BIZH = opResult.getChildTextTrim("BIZH");
        String ZHYE = opResult.getChildTextTrim("ZHYE");
        String KYYE = opResult.getChildTextTrim("KYYE");
        BalanceInfo balance = new BalanceInfo();
        balance.setBankAcnt(rqst.getAcnt());
        balance.setBankCurrency(BIZH);
        if (!rqst.getAcnt().getAccNo().equalsIgnoreCase(ZHHA)) {
            balance.setError(BalanceUtils.inconsistentAcc());
        }
        if (StringUtils.isNotEmpty((String)ZHYE)) {
            balance.setCurrentBalance(new BigDecimal(ZHYE).divide(new BigDecimal("100.00"), 2, 0));
        } else {
            balance.setError(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u5f53\u524d\u4f59\u989d\u4e3a\u7a7a\u3002", (String)"BalanceUtils_0", (String)"ebg-aqap-banks-ocbc-dc", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)KYYE)) {
            balance.setAvailableBalance(new BigDecimal(KYYE).divide(new BigDecimal("100.00"), 2, 0));
        }
        balance.setBalanceDateTime(LocalDateTime.now());
        response.setBalances((List)Lists.newArrayList((Object[])new BalanceInfo[]{balance}));
        return response;
    }
}

