/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.ocbc.dc.services.detail;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.ocbc.dc.services.OCBC_DC_Parser;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisDetailParser {
    public static List<DetailInfo> parseHisDetail(BankDetailRequest rqst, String rsp) throws EBServiceException {
        ArrayList<DetailInfo> details = new ArrayList<DetailInfo>(16);
        Element root = JDomUtils.string2Root((String)rsp, (String)RequestContextUtils.getCharset());
        Element opRep = root.getChild("opRep");
        BankResponse bankRsp = OCBC_DC_Parser.parseHeader(opRep);
        if (!"000000".equalsIgnoreCase(bankRsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u5386\u53f2\u660e\u7ec6\u67e5\u8be2\u5931\u8d25 :%1$s\u3002", (String)"HisDetailParser_3", (String)"ebg-aqap-banks-ocbc-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{bankRsp.getResponseCode(), bankRsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element resultSet = opRep.getChild("opResultSet");
        List list = resultSet.getChildren("opResult");
        if (null == list || list.size() <= 0) {
            return details;
        }
        for (int i = 0; i < list.size(); ++i) {
            Element listElement = (Element)list.get(i);
            String SZFX = listElement.getChildTextTrim("SZFX");
            String JYBZ = listElement.getChildTextTrim("JYBZ");
            String JFJE = listElement.getChildTextTrim("JFJE");
            String DFJE = listElement.getChildTextTrim("DFJE");
            String DFZH = listElement.getChildTextTrim("DFZH");
            String DFHM = listElement.getChildTextTrim("DFHM");
            String DFWD = listElement.getChildTextTrim("DFWD");
            String ZHYE = listElement.getChildTextTrim("ZHYE");
            String JYRQ = listElement.getChildTextTrim("JYRQ");
            String JYSJ = listElement.getChildTextTrim("JYSJ");
            String BEIZ = listElement.getChildTextTrim("BEIZ");
            DetailInfo detail = new DetailInfo();
            detail.setCurrency(JYBZ);
            if (StringUtils.isNotEmpty((String)ZHYE)) {
                detail.setBalance(new BigDecimal(ZHYE).divide(new BigDecimal("100.00"), 2, 0));
            }
            if (StringUtils.isNotEmpty((String)BEIZ) && BEIZ.indexOf("_KD_") != -1) {
                String id = BizNoUtil.getId((String)BEIZ);
                String msg = BizNoUtil.getMsg((String)BEIZ);
                detail.setPayBankDetailSeqID(id);
                detail.setExplanation(msg);
            } else {
                detail.setExplanation(BEIZ);
            }
            detail.setAccNo(rqst.getAcnt().getAccNo());
            detail.setAccName(rqst.getAcnt().getAccName());
            detail.setBankName(rqst.getAcnt().getBankName());
            detail.setOppAccNo(DFZH);
            detail.setOppAccName(DFHM);
            detail.setOppBankName(DFWD);
            if (StringUtils.isEmpty((String)JYRQ)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684'\u4ea4\u6613\u65e5\u671f'\u4e3a\u7a7a,\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u660e\u7ec6\u7684\u4ea4\u6613\u65f6\u95f4.", (String)"HisDetailParser_1", (String)"ebg-aqap-banks-ocbc-dc", (Object[])new Object[0]));
            }
            try {
                detail.setTransDate(LocalDate.parse(JYRQ, DateTimeFormatter.ofPattern("yyyyMMdd")));
                if (!StringUtils.isEmpty((String)JYSJ)) {
                    detail.setTransTime(LocalDateTime.parse(JYRQ + JYSJ, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                } else {
                    detail.setTransTime(LocalDateTime.parse(JYRQ + "000000", DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                }
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5f53\u65e5\u660e\u7ec6\u67e5\u8be2\uff1a\u4ea4\u6613\u65f6\u95f4\u683c\u5f0f\u5f02\u5e38.%1$s\u3002", (String)"HisDetailParser_4", (String)"ebg-aqap-banks-ocbc-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
            if ("C".equalsIgnoreCase(SZFX)) {
                detail.setCreditAmount(new BigDecimal(DFJE).divide(new BigDecimal("100.00"), 2, 0));
                detail.setDebitAmount(new BigDecimal("0.00"));
            } else if ("D".equalsIgnoreCase(SZFX)) {
                detail.setDebitAmount(new BigDecimal(JFJE).divide(new BigDecimal("100.00"), 2, 0));
                detail.setCreditAmount(new BigDecimal("0.00"));
            }
            String json = MatchRule.getInstance().getDetailJsonWithStructuredData(listElement);
            detail.setJsonMap(json);
            details.add(detail);
        }
        return details;
    }
}

