/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.WaitFlagHelper;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class ABC_DC_QueryParser {
    public static void parsePaymentState(PaymentInfo paymentInfo, String rspStr) {
        if (WaitFlagHelper.isWaitFlag(paymentInfo)) {
            ABC_DC_QueryParser.parse_Paystate_CQRA61(paymentInfo, rspStr);
        } else if (BankBusinessConfig.isUseCQRT71()) {
            ABC_DC_QueryParser.parse_paystate_CQRT71(paymentInfo, rspStr);
        } else {
            ABC_DC_QueryParser.parse_Paystate_CQRT04(paymentInfo, rspStr);
        }
    }

    public static void parse_paystate_CQRT71(PaymentInfo paymentInfo, String rspStr) {
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        String rspCode = rsp.getResponseCode();
        if (!"0000".equalsIgnoreCase(rspCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25", (String)"ABC_DC_QueryParser_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return;
        }
        Element cmp = root.getChild("Cmp");
        Element corp = root.getChild("Corp");
        String Postscript = "";
        if (corp != null) {
            Postscript = ParserUtils.getUnNullElementTextValue((Element)corp, (String)"Postscript", (String)"<Postscript>");
        }
        String transState = JDomUtils.getChildText((Element)cmp, (String)"TransSta");
        String RespPrvData = JDomUtils.getChildText((Element)cmp, (String)"RespPrvData");
        if ("4".equalsIgnoreCase(transState)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"ABC_DC_QueryParser_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)(StringUtils.isNotEmpty((String)Postscript) ? Postscript : RespPrvData));
        } else if ("5".equalsIgnoreCase(transState) || "8".equalsIgnoreCase(transState)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"ABC_DC_QueryParser_2", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)(StringUtils.isNotEmpty((String)Postscript) ? Postscript : RespPrvData));
        } else if ("B".equalsIgnoreCase(transState)) {
            if ("true".equalsIgnoreCase(BankBusinessConfig.cqrt71IsFail())) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"ABC_DC_QueryParser_2", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)(StringUtils.isNotEmpty((String)Postscript) ? Postscript : RespPrvData));
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"ABC_DC_QueryParser_3", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)(StringUtils.isNotEmpty((String)Postscript) ? Postscript : RespPrvData));
            }
        } else if ("9".equalsIgnoreCase(transState)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"ABC_DC_QueryParser_3", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)(StringUtils.isNotEmpty((String)Postscript) ? Postscript : RespPrvData));
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"ABC_DC_QueryParser_4", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)(StringUtils.isNotEmpty((String)Postscript) ? Postscript : RespPrvData));
        }
    }

    private static void parse_Paystate_CQRA61(PaymentInfo paymentInfo, String rspStr) {
        EBGLogger logger = EBGLogger.getInstance().getLogger(ABC_DC_QueryParser.class);
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        String rspCode = rsp.getResponseCode();
        if (!"0000".equalsIgnoreCase(rspCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u7ecf\u843d\u5730\u5904\u7406(\u94f6\u884c\u624b\u52a8\u5904\u7406\u4ed8\u6b3e\u5355\uff0c\u5982\u9700\u786e\u8ba4\u4ed8\u6b3e\u7ed3\u679c\u9700\u8054\u7cfb\u94f6\u884c\u3002)\uff0c\u67e5\u8be2\u843d\u5730\u7ed3\u679c\u672a\u77e5\u3002", (String)"ABC_DC_QueryParser_5", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return;
        }
        Element corp = root.getChild("Corp");
        String BookingDate = corp.getChildText("BookingDate");
        String UseState = corp.getChildText("UseState");
        logger.info("\u843d\u5730\u65e5\u671f(BookingDate):{}", (Object)BookingDate);
        logger.info("\u5904\u7406\u72b6\u6001(UseState):{}", (Object)UseState);
        if (null == UseState) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u672a\u8fd4\u56de\u5904\u7406\u72b6\u6001\u7801(ap/Corp/UseState)\u3002\u8bf7\u5ba2\u6237\u5411\u4ed8\u6b3e\u94f6\u884c\u786e\u8ba4\u8be5\u7b14\u652f\u4ed8\u60c5\u51b5\u3002", (String)"ABC_DC_QueryParser_6", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)UseState, (String)"");
            return;
        }
        if ("1".equalsIgnoreCase(UseState)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)UseState, (String)ResManager.loadKDString((String)"\u5904\u7406\u6210\u529f", (String)"ABC_DC_QueryParser_7", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
        } else if ("0".equalsIgnoreCase(UseState)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u8bf7\u5ba2\u6237\u5411\u4ed8\u6b3e\u94f6\u884c\u786e\u8ba4\u8be5\u7b14\u652f\u4ed8\u60c5\u51b5\u3002\u843d\u5730\u65e5\u671f(BookingDate):%s\u3002", (String)"ABC_DC_QueryParser_12", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), BookingDate), (String)UseState, (String)ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25\u6216\u672a\u5904\u7406\u3002", (String)"ABC_DC_QueryParser_9", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u7684\u5904\u7406\u72b6\u6001\u7801[%s]\u3002\u8bf7\u5ba2\u6237\u5411\u4ed8\u6b3e\u94f6\u884c\u786e\u8ba4\u8be5\u7b14\u652f\u4ed8\u60c5\u51b5\u3002", (String)"ABC_DC_QueryParser_13", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), UseState), (String)UseState, (String)"");
        }
    }

    public static void parse_Paystate_CQRT04(PaymentInfo paymentInfo, String rspStr) {
        EBGLogger logger = EBGLogger.getInstance().getLogger(ABC_DC_QueryParser.class);
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        String rspCode = rsp.getResponseCode();
        if (!"0000".equalsIgnoreCase(rspCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25", (String)"ABC_DC_QueryParser_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return;
        }
        Element cmp = root.getChild("Cmp");
        Element corp = root.getChild("Corp");
        String transState = JDomUtils.getChildText((Element)cmp, (String)"TransSta");
        String data = ParserUtils.checkUnNullableElementUnTrim((Element)cmp, (String)"RespPrvData");
        String Postscript = "";
        if (corp != null) {
            Postscript = ParserUtils.getUnNullElementTextValue((Element)corp, (String)"Postscript", (String)"<Postscript>");
        }
        if (StringUtils.isEmpty((String)transState)) {
            String packageID = data.substring(6, 18);
            String szRespCode = data.substring(18, 22);
            String szAbisRespCode = data.substring(22, 26);
            logger.info("\u6d41\u6c34\u53f7 :{}", (Object)packageID);
            logger.info("\u524d\u7f6e\u8fd4\u56de\u7801 :{}", (Object)szRespCode);
            logger.info("\u540e\u53f0\u8fd4\u56de\u7801:{}", (Object)szAbisRespCode);
            logger.info("\u8fd4\u56de\u4fe1\u606f:{}", (Object)Postscript);
            if ("0000".equalsIgnoreCase(szRespCode)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)szRespCode, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"ABC_DC_QueryParser_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
            } else if (StrUtil.isEmpty((String)szRespCode)) {
                if ("0000".equalsIgnoreCase(szAbisRespCode)) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)"", (String)szAbisRespCode, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"ABC_DC_QueryParser_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
                } else {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)szAbisRespCode, (String)Postscript);
                }
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)szRespCode, (String)Postscript);
            }
        } else if ("4".equalsIgnoreCase(transState)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"ABC_DC_QueryParser_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)Postscript);
        } else if ("5".equalsIgnoreCase(transState) || "8".equalsIgnoreCase(transState)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"ABC_DC_QueryParser_2", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)Postscript);
        } else if ("B".equalsIgnoreCase(transState)) {
            if ("true".equalsIgnoreCase(BankBusinessConfig.cqrt71IsFail())) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"ABC_DC_QueryParser_2", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)Postscript);
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"ABC_DC_QueryParser_3", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)Postscript);
            }
        } else if ("9".equalsIgnoreCase(transState)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"ABC_DC_QueryParser_3", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)Postscript);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"ABC_DC_QueryParser_4", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)Postscript);
        }
    }
}

