/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.balance;

import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtils;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AggregateTodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest rqst) {
        BankAcnt acnt = rqst.getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New("CQRA04", Sequence.genSequence());
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(acnt.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt(acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)rqst.getBankCurrency());
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        BankAcnt acnt = request.getAcnt();
        Element root = ABC_DC_Parser.parseString2Root(responseStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if (!"0000".equals(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rsp.getResponseCode(), (String)rsp.getResponseMessage()));
        }
        Element acc = root.getChild("Acc");
        String availBal = acc.getChildTextTrim("AvailBal");
        String bal = acc.getChildTextTrim("Bal");
        ArrayList<BalanceInfo> resultList = new ArrayList<BalanceInfo>(1);
        BalanceInfo info = new BalanceInfo();
        this.setAvailableBalance(info, availBal);
        this.setCurrentBalance(info, bal);
        info.setBankCurrency(request.getBankCurrency());
        Element cmp = root.getChild("Cmp");
        String RespPrvData1 = cmp.getChildTextTrim("RespPrvData1");
        String[] temp = StringUtils.split((String)RespPrvData1, (String)"|");
        String accNo = temp[1];
        if (accNo.equals(AcntNumberHelper.fixAccNoTo15Or19(acnt.getAccNo()))) {
            info.setBankAcnt(request.getAcnt());
        } else {
            info.setError(BalanceUtils.inconsistentAcc());
        }
        resultList.add(info);
        return new EBBankBalanceResponse(resultList);
    }

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "CQRA04";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f52\u96c6\u6237\u5f53\u65e5\u53ef\u7528\u4f59\u989d\u67e5\u8be2\u3002", (String)"AggregateTodayBalanceImpl_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceRequest request) {
        return BankBusinessConfig.isAggregatorsAcnt(request.getAcnt().getAccNo());
    }
}

