/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.curandfixed.query;

import java.util.Arrays;
import java.util.List;
import kd.ebg.aqap.banks.abc.dc.ext.ResponseFileUtils;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.banks.abc.dc.service.curandfixed.utils.PriCafUtil;
import kd.ebg.aqap.business.currentandfixed.atomic.AbstractQueryCAFImpl;
import kd.ebg.aqap.business.currentandfixed.atomic.IQueryCurAndFixed;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.bank.EBBankCurAndFixedResponse;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CQRA25Impl
extends AbstractQueryCAFImpl
implements IQueryCurAndFixed {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CQRA25Impl.class);

    public String pack(BankCurAndFixedRequest bankCurAndFixedRequest) {
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)bankCurAndFixedRequest.getCafInfos().get(0);
        BankAcnt acnt = bankCurAndFixedRequest.getHeader().getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New("CQRA25", curAndFixedInfo.getDetailSeqId());
        Element acc = JDomUtils.addChild((Element)root, (String)"ACC");
        JDomUtils.addChild((Element)acc, (String)"AccType", (String)"02");
        JDomUtils.addChild((Element)acc, (String)"AccSts", (String)"0");
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt(acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(curAndFixedInfo.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)curAndFixedInfo.getCurrency());
        Element Channel = JDomUtils.addChild((Element)root, (String)"Channel");
        JDomUtils.addChild((Element)Channel, (String)"AssFlag", (String)"0");
        Element Corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)Corp, (String)"DbAccName", (String)curAndFixedInfo.getAccName());
        if ("CNY".equalsIgnoreCase(CurrencyUtils.convert2Iso((String)curAndFixedInfo.getCurrency()))) {
            JDomUtils.addChild((Element)Corp, (String)"IndCshRmt", (String)"0");
        } else {
            JDomUtils.addChild((Element)Corp, (String)"IndCshRmt", (String)"1");
        }
        JDomUtils.addChild((Element)Corp, (String)"PrdSeq", (String)curAndFixedInfo.getReqNbrWithoutTag());
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public EBBankCurAndFixedResponse parse(BankCurAndFixedRequest bankCurAndFixedRequest, String s) {
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
        Element root = ABC_DC_Parser.parseString2Root(s);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            return new EBBankCurAndFixedResponse(cafInfos);
        }
        Element cmp = root.getChild("Cmp");
        String batchFileName = ParserUtils.checkUnNullableElement((Element)cmp, (String)"BatchFileName");
        Element cme = root.getChild("Cme");
        String recordNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"RecordNum");
        String FieldNum = ParserUtils.checkUnNullableElement((Element)cme, (String)"FieldNum");
        int recordNum = Integer.parseInt(recordNumStr);
        int fieldNum = Integer.parseInt(FieldNum);
        if (StringUtils.isEmpty((String)batchFileName)) {
            return new EBBankCurAndFixedResponse(cafInfos);
        }
        if (recordNum != 0) {
            String[] splits = ResponseFileUtils.getDetailRspRecords(batchFileName, "");
            int index = PriCafUtil.indexOf(splits, fieldNum, 9, curAndFixedInfo.getReqNbrWithoutTag());
            if (index == -1) {
                return new EBBankCurAndFixedResponse(cafInfos);
            }
            CharSequence[] qData = Arrays.copyOfRange(splits, index, Math.min(index + fieldNum, splits.length));
            logger.info("\u5b50\u8d26\u6237\u5e8f\u53f7{}\u67e5\u8be2{}\u5bf9\u5e94\u660e\u7ec6\u662f{}", new Object[]{curAndFixedInfo.getReqNbrWithoutTag(), this.getBizCode(), String.join((CharSequence)"|", qData)});
        }
        return new EBBankCurAndFixedResponse(cafInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CQRA25";
    }

    public String getBizDesc() {
        return null;
    }
}

