/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.curandfixed.query;

import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import kd.ebg.aqap.banks.abc.dc.ext.ResponseFileUtils;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.banks.abc.dc.service.curandfixed.utils.PriCafUtil;
import kd.ebg.aqap.business.currentandfixed.atomic.AbstractQueryCAFImpl;
import kd.ebg.aqap.business.currentandfixed.atomic.IQueryCurAndFixed;
import kd.ebg.aqap.business.currentandfixed.bank.BankCurAndFixedRequest;
import kd.ebg.aqap.business.currentandfixed.bank.EBBankCurAndFixedResponse;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.CurAndFixedInfo;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CQRA28Impl
extends AbstractQueryCAFImpl
implements IQueryCurAndFixed {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(CQRA28Impl.class);

    public String pack(BankCurAndFixedRequest bankCurAndFixedRequest) {
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)bankCurAndFixedRequest.getCafInfos().get(0);
        BankAcnt acnt = bankCurAndFixedRequest.getHeader().getAcnt();
        Element root = ABC_DC_Packer.createABCRoot4New("CQRA28", curAndFixedInfo.getDetailSeqId());
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt(acnt));
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(curAndFixedInfo.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)curAndFixedInfo.getCurrency());
        JDomUtils.addChild((Element)cmp, (String)"CrCur", (String)"");
        JDomUtils.addChild((Element)cmp, (String)"CrProv", (String)"");
        JDomUtils.addChild((Element)cmp, (String)"CrAccNo", (String)"");
        JDomUtils.addChild((Element)cmp, (String)"NotesStartDate", (String)curAndFixedInfo.getTranDate().format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)cmp, (String)"NotesEndDate", (String)curAndFixedInfo.getTranDate().plusDays(7L).format(DateTimeFormatter.BASIC_ISO_DATE));
        JDomUtils.addChild((Element)cmp, (String)"BankNo", (String)curAndFixedInfo.getAcntBankNo());
        JDomUtils.addChild((Element)root, (String)"Amt", (String)"");
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"NtcDat", (String)"");
        JDomUtils.addChild((Element)corp, (String)"OpCod", (String)"");
        JDomUtils.addChild((Element)corp, (String)"VoucherType", (String)"");
        JDomUtils.addChild((Element)corp, (String)"VoucherBat", (String)"");
        JDomUtils.addChild((Element)corp, (String)"VoucherNo", (String)"");
        JDomUtils.addChild((Element)corp, (String)"NtcNo", (String)"");
        JDomUtils.addChild((Element)corp, (String)"PrdSeq", (String)curAndFixedInfo.getReqNbrWithoutTag());
        if ("CNY".equalsIgnoreCase(CurrencyUtils.convert2Iso((String)curAndFixedInfo.getCurrency()))) {
            JDomUtils.addChild((Element)corp, (String)"IndCshRmt", (String)"0");
        } else {
            JDomUtils.addChild((Element)corp, (String)"IndCshRmt", (String)"1");
        }
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public EBBankCurAndFixedResponse parse(BankCurAndFixedRequest bankCurAndFixedRequest, String s) {
        List cafInfos = bankCurAndFixedRequest.getCafInfos();
        CurAndFixedInfo curAndFixedInfo = (CurAndFixedInfo)cafInfos.get(0);
        Element root = ABC_DC_Parser.parseString2Root(s);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            return new EBBankCurAndFixedResponse(cafInfos);
        }
        Element cmp = root.getChild("Cmp");
        String batchFileName = ParserUtils.checkUnNullableElement((Element)cmp, (String)"BatchFileName");
        Element cme = root.getChild("Cme");
        String FieldNum = ParserUtils.checkUnNullableElement((Element)cme, (String)"FieldNum");
        String recordNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"RecordNum");
        int fieldNum = Integer.parseInt(FieldNum);
        int recordNum = Integer.parseInt(recordNumStr);
        if (StringUtils.isEmpty((String)batchFileName)) {
            return new EBBankCurAndFixedResponse(cafInfos);
        }
        if (recordNum != 0) {
            String[] splits = ResponseFileUtils.getDetailRspRecords(batchFileName, "");
            int index = PriCafUtil.indexOf(splits, fieldNum, 6, curAndFixedInfo.getNotifyId());
            if (index == -1) {
                return new EBBankCurAndFixedResponse(cafInfos);
            }
            CharSequence[] qData = Arrays.copyOfRange(splits, index, Math.min(index + fieldNum, splits.length));
            logger.info("\u5b50\u8d26\u6237\u5e8f\u53f7{}\u67e5\u8be2{}\u5bf9\u5e94\u660e\u7ec6\u662f{}", new Object[]{curAndFixedInfo.getReqNbrWithoutTag(), this.getBizCode(), String.join((CharSequence)"|", qData)});
            if ("0".equalsIgnoreCase(splits[index + 12].trim())) {
                String endDate = splits[index + 5];
                curAndFixedInfo.setEndDate(endDate);
            }
        }
        return new EBBankCurAndFixedResponse(cafInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CQRA28";
    }

    public String getBizDesc() {
        return null;
    }
}

