/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.financing.redeem;

import java.time.LocalDate;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.ext.ResponseFileUtils;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.business.financing.atomic.AbstractFinancingImpl;
import kd.ebg.aqap.business.financing.atomic.IQueryRedeemFinancing;
import kd.ebg.aqap.business.financing.bank.BankFinancingRequest;
import kd.ebg.aqap.business.financing.bank.EBBankFinancingResponse;
import kd.ebg.aqap.business.financing.util.FinancingUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.FinancingState;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.financing.FinancingInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryRedeemImpl
extends AbstractFinancingImpl
implements IQueryRedeemFinancing {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryRedeemImpl.class);

    public String pack(BankFinancingRequest bankFinancingRequest) {
        List infos = bankFinancingRequest.getInfos();
        BankAcnt acnt = bankFinancingRequest.getAcnt();
        FinancingInfo info = (FinancingInfo)infos.get(0);
        Element root = ABC_DC_Packer.createABCRoot4New("CQLC09", Sequence.genSequence());
        Element Cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)Cmp, (String)"DbAccNo", (String)info.getAccNo());
        JDomUtils.addChild((Element)Cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByAcnt(acnt));
        JDomUtils.addChild((Element)Cmp, (String)"DbCur", (String)info.getCurrency());
        Element pds = JDomUtils.addChild((Element)root, (String)"Pds");
        JDomUtils.addChild((Element)pds, (String)"TracNo", (String)info.getReserved2());
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"StartDate", (String)LocalDateUtil.formatDate((LocalDate)LocalDate.now()));
        JDomUtils.addChild((Element)corp, (String)"EndDate", (String)LocalDateUtil.formatDate((LocalDate)LocalDate.now()));
        JDomUtils.addChild((Element)corp, (String)"ExchangeType", (String)"00");
        Element qry = JDomUtils.addChild((Element)root, (String)"Qry");
        JDomUtils.addChild((Element)qry, (String)"Rge", (String)"1");
        String result = ABC_DC_Packer.covert2ABCMessage(root);
        this.logger.info("\u540c\u6b65\u8d4e\u56de\u8bf7\u6c42\u8fd4\u56de\u62a5\u6587");
        return result;
    }

    public EBBankFinancingResponse parse(BankFinancingRequest bankFinancingRequest, String rspStr) {
        EBBankFinancingResponse result = new EBBankFinancingResponse();
        List infos = bankFinancingRequest.getInfos();
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if (!"0000".equalsIgnoreCase(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u519c\u884c\u7406\u8d22\u8d4e\u56de\u8bf7\u6c42\u5931\u8d25 ,\u94f6\u884c\u8fd4\u56de :%1$s %2$s", (String)"QueryRedeemImpl_4", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        String fileFlag = root.getChildTextTrim("FileFlag");
        Element cmp = root.getChild("Cmp");
        String batchFileName = ParserUtils.checkUnNullableElement((Element)cmp, (String)"BatchFileName");
        if (StringUtils.isEmpty((String)batchFileName)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u540c\u6b65\u7406\u8d22\u8d4e\u56de\u8fd4\u56de\u7684\u6587\u4ef6\u540d\u4e3a\u7a7a\u3002", (String)"QueryRedeemImpl_5", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
        }
        Element cme = root.getChild("Cme");
        String recordNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"RecordNum");
        int recordNum = Integer.parseInt(recordNumStr);
        if (0 == recordNum) {
            String errorMsg = ResManager.loadKDString((String)"\u519c\u884c\u7406\u8d22\u8d4e\u56de\u540c\u6b65\u5931\u8d25 ,\u94f6\u884c\u8fd4\u56de\u6301\u6709\u7406\u8d22\u4fe1\u606f\u4e3a\u7a7a:", (String)"QueryRedeemImpl_7", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        String fieldNumStr = ParserUtils.checkUnNullableElement((Element)cme, (String)"FieldNum");
        String[] splits = ResponseFileUtils.getDetailRspRecords(batchFileName, "");
        int fieldNum = Integer.parseInt(fieldNumStr);
        for (int i = 0; i < recordNum; ++i) {
            String traceStatus = splits[fieldNum * i + 20];
            String contractNo = splits[fieldNum * i + 10];
            for (FinancingInfo message : infos) {
                if (!message.getReserved1().equals(contractNo)) continue;
                if ("20".equals(traceStatus)) {
                    FinancingUtil.setState((FinancingInfo)message, (FinancingState)FinancingState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryRedeemImpl_2", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)traceStatus, (String)rsp.getResponseMessage());
                    continue;
                }
                if ("21".equals(traceStatus) || "23".equals(traceStatus)) {
                    FinancingUtil.setState((FinancingInfo)message, (FinancingState)FinancingState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"ABC_DC_QueryParser_2", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)traceStatus, (String)rsp.getResponseMessage());
                    continue;
                }
                FinancingUtil.setState((FinancingInfo)message, (FinancingState)FinancingState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"ABC_DC_QueryParser_3", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)traceStatus, (String)rsp.getResponseMessage());
            }
        }
        result.setInfos(infos);
        return result;
    }

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "CQLC09";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8d4e\u56de\u67e5\u8be2", (String)"QueryRedeemImpl_6", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(BankFinancingRequest bankFinancingRequest) {
        return true;
    }
}

