/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.BankBusinessConfig;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;

public class PaymentUtil {
    public static String getBankDetailSeqId(String id) {
        String bankDetailSeqID = id;
        if (bankDetailSeqID.contains("KD_")) {
            return bankDetailSeqID;
        }
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            return BizNoUtil.prefix_cont((String)bankDetailSeqID);
        }
        return bankDetailSeqID;
    }

    public static String getBankBatchSeqId(PaymentInfo info, String msg) {
        String bankBatchSeqID = info.getBankBatchSeqID();
        if (bankBatchSeqID.contains("KD_")) {
            return bankBatchSeqID;
        }
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            return BizNoUtil.cont((String)bankBatchSeqID, (String)msg);
        }
        return bankBatchSeqID;
    }

    public static String getSeqIdFromYurref(String yurref) {
        if (yurref.contains("KD_")) {
            return yurref.substring("KD_".length());
        }
        return yurref;
    }

    public static boolean isFTEAcc(String accountNo) {
        if (accountNo.startsWith("FTE")) {
            PaymentUtil.PreCheckFTEAcc(accountNo);
            return true;
        }
        if (accountNo.startsWith("FTN")) {
            PaymentUtil.PreCheckFTEAcc(accountNo);
            return true;
        }
        return false;
    }

    public static void PreCheckFTEAcc(String accountNo) {
        if (accountNo.length() != 20) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"FTE\u8d26\u6237\u4f4d\u6570\u5fc5\u987b\u662f20\u4f4d", (String)"PaymentUtil_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
        }
    }
}

