/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.abc.dc.service.payment.PaymentUtil;
import kd.ebg.aqap.banks.abc.dc.service.payment.agent.AgentPayImpl;
import kd.ebg.aqap.banks.abc.dc.service.payment.allocation.AllocationPayImpl;
import kd.ebg.aqap.banks.abc.dc.service.payment.batch.inner.InnerPayImpl;
import kd.ebg.aqap.banks.abc.dc.service.payment.batch.other.PaymentImpl;
import kd.ebg.aqap.banks.abc.dc.service.payment.batch.salary.SalaryPayImpl;
import kd.ebg.aqap.banks.abc.dc.service.payment.batch.transfer.TransferPayImpl;
import kd.ebg.aqap.banks.abc.dc.service.payment.company.CompanyPayImpl;
import kd.ebg.aqap.banks.abc.dc.service.payment.group.GroupPayImpl;
import kd.ebg.aqap.banks.abc.dc.service.payment.income.IncomePayImpl;
import kd.ebg.aqap.banks.abc.dc.service.payment.individual.IndividualPayImpl;
import kd.ebg.aqap.banks.abc.dc.service.payment.oversea.GFRB10PayImpl;
import kd.ebg.aqap.banks.abc.dc.service.payment.oversea.GFRB13PayImpl;
import kd.ebg.aqap.banks.abc.dc.service.payment.oversea.GFRB15PayImpl;
import kd.ebg.aqap.business.payment.atomic.BusiImplInfo;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.atomic.PretreatmentTrace;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.route.MatchTypeEnum;
import kd.ebg.aqap.business.payment.route.PayRouteEnum;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;

public class PretreatmentImpl
extends PretreatmentTrace
implements IPretreat {
    public void appendData(PaymentInfo paymentInfo) {
        this.getBusiImplInfo(paymentInfo);
        this.setPayRouteTrace(paymentInfo);
    }

    public BusiImplInfo getBusiImplInfo(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = new BusiImplInfo();
        if (PaymentUtil.isFTEAcc(paymentInfo.getAccNo()) || PaymentUtil.isFTEAcc(paymentInfo.getIncomeAccNo())) {
            if (this.isPay_for_overseaPay(paymentInfo)) {
                if ("01".equals(paymentInfo.getCurrency())) {
                    this.setImplClassName(paymentInfo, GFRB15PayImpl.class.getName());
                    return busiImplInfo;
                }
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5f53\u524dFT\u8d26\u6237\u53ea\u652f\u6301\u4eba\u6c11\u5e01\u4ed8\u6b3e", (String)"PretreatmentImpl_4", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
            }
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"FT\u8d26\u6237\u4e0d\u652f\u6301\u7684\u4e1a\u52a1\u7c7b\u578b\uff1a%s", (String)"PretreatmentImpl_5", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), paymentInfo.getSubBizType()));
        }
        if (this.isIncome(paymentInfo)) {
            this.setImplClassName(paymentInfo, IncomePayImpl.class.getName());
        } else if (this.isPay_for_salary(paymentInfo)) {
            this.setSubBizType4Salary(paymentInfo);
        } else if (this.isPay_for_capital_allocation(paymentInfo)) {
            this.setSubBizType4CapitalAllocation(paymentInfo);
        } else if (this.isPay(paymentInfo)) {
            if (this.isGroupAcntPoolTransfer(paymentInfo)) {
                this.setImplClassName(paymentInfo, GroupPayImpl.class.getName());
            } else if (this.isSalaryUseCN(paymentInfo)) {
                this.setSubBizType4Salary(paymentInfo);
            } else if (this.isTransferUseCN(paymentInfo)) {
                this.setSubBizType4CapitalAllocation(paymentInfo);
            } else if (this.isIndividual(paymentInfo)) {
                if (this.isSameBank(paymentInfo)) {
                    this.set2NomalIndividualPay(paymentInfo);
                } else {
                    this.set2NomalCompayPay(paymentInfo);
                }
            } else {
                this.set2NomalCompayPay(paymentInfo);
            }
        } else if (this.isPay_for_linkPay(paymentInfo)) {
            this.setImplClassName(paymentInfo, "");
            if (this.isIndividual(paymentInfo)) {
                this.set2NomalIndividualPay(paymentInfo);
            } else {
                this.set2NomalCompayPay(paymentInfo);
            }
            paymentInfo.setReversed4("linkpayToCompany");
        } else if (this.isPay_for_agentPay(paymentInfo)) {
            this.setImplClassName(paymentInfo, AgentPayImpl.class.getName());
        } else if (this.isPay_for_overseaPay(paymentInfo)) {
            this.setOverseaPayImpl(paymentInfo);
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672a\u5b9e\u73b0\u8be5\u79cd\u4e1a\u52a1\u7c7b\u578b%1$s, \u8bf7\u68c0\u67e5\u8be5\u4e1a\u52a1\u7c7b\u578b\u662f\u5426\u6b63\u786e\u3002", (String)"PretreatmentImpl_3", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), paymentInfo.getSubBizType()));
        }
        return busiImplInfo;
    }

    private void setOverseaPayImpl(PaymentInfo paymentInfo) {
        if (this.assertISOCurrency(paymentInfo.getPayCurrency(), "CNY")) {
            this.setImplClassName(paymentInfo, GFRB13PayImpl.class.getName());
        } else {
            this.setImplClassName(paymentInfo, GFRB10PayImpl.class.getName());
        }
    }

    private void setSubBizType4Salary(PaymentInfo paymentInfo) throws EBServiceException {
        if (this.isSameBank(paymentInfo)) {
            if (this.isMerge(paymentInfo)) {
                if (UseConvertor.isSalary((PaymentInfo)paymentInfo)) {
                    this.setImplClassName(paymentInfo, SalaryPayImpl.class.getName());
                } else {
                    this.setImplClassName(paymentInfo, PaymentImpl.class.getName());
                }
            } else {
                this.set2NomalIndividualPay(paymentInfo);
            }
        } else if (this.isMerge(paymentInfo)) {
            this.setImplClassName(paymentInfo, kd.ebg.aqap.banks.abc.dc.service.payment.batch.outer.PaymentImpl.class.getName());
        } else {
            this.set2NomalCompayPay(paymentInfo);
        }
        paymentInfo.setIndividual(Boolean.TRUE);
    }

    private void set2NomalIndividualPay(PaymentInfo paymentInfo) throws EBServiceException {
        if (this.isTrans2Batch(paymentInfo)) {
            this.set2BatchPay(paymentInfo);
        } else {
            this.setImplClassName(paymentInfo, IndividualPayImpl.class.getName());
        }
    }

    private void set2BatchPay(PaymentInfo paymentInfo) throws EBServiceException {
        if (this.isSameBank(paymentInfo)) {
            this.setImplClassName(paymentInfo, InnerPayImpl.class.getName());
        } else {
            this.setImplClassName(paymentInfo, TransferPayImpl.class.getName());
        }
    }

    private void set2NomalCompayPay(PaymentInfo paymentInfo) throws EBServiceException {
        if (this.isTrans2Batch(paymentInfo)) {
            this.set2BatchPay(paymentInfo);
        } else {
            this.setImplClassName(paymentInfo, CompanyPayImpl.class.getName());
        }
    }

    private void setSubBizType4CapitalAllocation(PaymentInfo paymentInfo) throws EBServiceException {
        if (this.isAllocationToCompanyPay()) {
            if (this.isIndividual(paymentInfo)) {
                paymentInfo.setIndividual(Boolean.TRUE);
                this.setImplClassName(paymentInfo, IndividualPayImpl.class.getName());
            } else {
                this.setImplClassName(paymentInfo, CompanyPayImpl.class.getName());
            }
            paymentInfo.setReversed4("AllocationToCompany");
        } else {
            paymentInfo.setIndividual(Boolean.FALSE);
            if (this.isSameBank(paymentInfo)) {
                this.setImplClassName(paymentInfo, AllocationPayImpl.class.getName());
            } else {
                this.setImplClassName(paymentInfo, CompanyPayImpl.class.getName());
            }
        }
    }

    private boolean isGroupAcntPoolTransfer(PaymentInfo paymentInfo) {
        boolean result = BankBusinessConfig.isGroupAcntPoolTransfer(paymentInfo.getAccNo(), paymentInfo.getIncomeAccNo());
        if (result) {
            this.addRoute(true, "ABC_DC_GroupAcntPool", " ", MatchTypeEnum.MATCH_RULE.getDesc());
        }
        return result;
    }

    private boolean isTrans2Batch(PaymentInfo paymentInfo) {
        if (paymentInfo.getTotalCount() > 1 && this.assertBusinessConfig("abc_dc_istrans2batchpay", "batch")) {
            this.addRoute(false, PayRouteEnum.SINGLE.getDesc(), ">", "1");
            return true;
        }
        return false;
    }

    private boolean isAllocationToCompanyPay() {
        return this.assertBusinessConfig("abc_dc_isAllocationToCompany", "AllocationToCompany");
    }

    public EBBankPayResponse doBiz(BankPayRequest request) {
        return null;
    }

    public String getDeveloper() {
        return "hpf";
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u519c\u884c\u4ed8\u6b3e\u8def\u7531", (String)"PretreatmentImpl_2", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return true;
    }
}

