/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.payment.batch.salary;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.payment.batch.ABCBankResponse;
import kd.ebg.aqap.banks.abc.dc.service.payment.shpaybatch.ABC_DCFileUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(SalaryQueryPayImpl.class);

    public void closeOutputStreamQuietly(OutputStream outputStream) {
        IOUtils.closeOutputStreamQuietly((OutputStream)outputStream);
    }

    public int getBatchSize() {
        return 500;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "CQLT73";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001\u3002", (String)"SalaryQueryPayImpl_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        Element root = ABC_DC_Packer.createABCRoot4New("CQLT73");
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        String bankBatchSeqId = ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId();
        JDomUtils.addChild((Element)corp, (String)"CustomNo", (String)bankBatchSeqId);
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        List infos = request.getPaymentInfos();
        Element root = ABC_DC_Parser.parseString2Root(responseStr);
        BankResponse bankResponse = ABC_DC_Parser.parseHeader(root);
        String fileFlag = JDomUtils.getChildText((Element)root, (String)"FileFlag");
        Element cmp = JDomUtils.getChildElement((Element)root, (String)"Cmp");
        Element cme = JDomUtils.getChildElement((Element)root, (String)"Cme");
        String fileName = JDomUtils.getChildText((Element)cmp, (String)"BatchFileName");
        String rspSource = JDomUtils.getChildText((Element)root, (String)"RespSource");
        if (!StringUtils.isEmpty((String)rspSource) && !"0".equalsIgnoreCase(rspSource) && "0".equalsIgnoreCase(fileFlag)) {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"SalaryQueryPayImpl_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            return new EBBankPayResponse(infos);
        }
        String bizSeqId = request.getHeader().getBizSeqID();
        Element batchPlat = JDomUtils.getChildElement((Element)root, (String)"Tulip");
        String status = "";
        String subStatus = "";
        String desc = "";
        if (null != batchPlat) {
            Element batch = JDomUtils.getChildElement((Element)batchPlat, (String)ResManager.loadKDString((String)"\u6279\u5904\u7406", (String)"SalaryQueryPayImpl_2", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
            status = JDomUtils.getChildText((Element)batch, (String)ResManager.loadKDString((String)"\u4e3b\u673a\u8fd4\u56de\u72b6\u6001", (String)"SalaryQueryPayImpl_3", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
            subStatus = JDomUtils.getChildText((Element)batch, (String)ResManager.loadKDString((String)"\u5904\u7406\u72b6\u6001", (String)"SalaryQueryPayImpl_4", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
            desc = JDomUtils.getChildText((Element)batch, (String)ResManager.loadKDString((String)"\u63cf\u8ff0\u4fe1\u606f", (String)"SalaryQueryPayImpl_5", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
        }
        if ("1".equalsIgnoreCase(status)) {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"SalaryQueryPayImpl_6", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)subStatus, (String)desc);
        } else if ("5".equals(subStatus) || "1".equalsIgnoreCase(fileFlag)) {
            String fileContent = "";
            try {
                this.logger.info("\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0b\u8f7d\u5f00\u59cb:\u6587\u4ef6\u540d=" + fileName);
                fileContent = new ABC_DCFileUtil().downloadFile(fileName, bizSeqId);
                this.logger.info("\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0b\u8f7d\u6210\u529f.\u6587\u4ef6\u5185\u5bb9\uff1a");
                this.logger.info(fileContent);
            }
            catch (Exception e) {
                this.logger.error("\u4e0b\u8f7d\u4ea4\u6613\u7ed3\u679c\u6587\u4ef6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4e0b\u8f7d\u4ea4\u6613\u7ed3\u679c\u6587\u4ef6\u53d1\u751f\u5f02\u5e38\u3002", (String)"SalaryQueryPayImpl_7", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)subStatus, (String)desc);
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u751f\u6210\u652f\u4ed8\u8bf7\u6c42\u6587\u4ef6\u4e0a\u4f20\u6587\u4ef6:%1$s\u5931\u8d25\u3002", (String)"SalaryQueryPayImpl_15", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), fileName), (Throwable)e);
            }
            String[] content = StringUtils.split((String)fileContent, (String)"|");
            Integer recordNum = 0;
            String recordNumsString = JDomUtils.getChildText((Element)cme, (String)"RecordNum");
            if (!StringUtils.isEmpty((String)recordNumsString)) {
                recordNum = Integer.parseInt(recordNumsString);
            }
            Map<String, ABCBankResponse> resultMap = this.getStatusMap(content, recordNum);
            for (PaymentInfo info : infos) {
                ABCBankResponse response = resultMap.get(info.getBankDetailSeqId());
                if (null == response) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u672a\u8fd4\u56de\u672c\u6761\u8bb0\u5f55\uff0c\u72b6\u6001\u672a\u77e5\u3002", (String)"SalaryQueryPayImpl_10", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)"", (String)"");
                    continue;
                }
                if (response.isSuccess() == 1) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SalaryQueryPayImpl_11", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
                    continue;
                }
                if (response.isSuccess() == -1) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"SalaryQueryPayImpl_6", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
                    continue;
                }
                if ("6".equals(response.getStatusCode())) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"SalaryQueryPayImpl_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)ResManager.loadKDString((String)"\u843d\u5730\u5f85\u5904\u7406", (String)"SalaryQueryPayImpl_12", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)info, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"SalaryQueryPayImpl_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
            }
        } else {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"SalaryQueryPayImpl_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)subStatus, (String)desc);
        }
        return new EBBankPayResponse(infos);
    }

    private Map<String, ABCBankResponse> getStatusMap(String[] content, int recordNum) {
        HashMap<String, ABCBankResponse> resultMap = new HashMap<String, ABCBankResponse>(16);
        for (int i = 0; i < recordNum; ++i) {
            String remark = "";
            String status = "";
            String bankCode = "";
            String bankMsg = "";
            int rowNum = 7;
            ABCBankResponse response = null;
            remark = content[i * rowNum + 5];
            status = content[i * rowNum + 1];
            bankCode = content[i * rowNum + 0];
            bankMsg = content[i * rowNum + 6];
            String[] successCodes = new String[]{"S"};
            String[] failedCodes = new String[]{"E"};
            response = new ABCBankResponse(successCodes, failedCodes);
            this.logger.info("line:" + i);
            this.logger.info("remark:" + remark);
            this.logger.info("status:" + status);
            this.logger.info("bankCode:" + bankCode);
            this.logger.info("bankMsg:" + bankMsg);
            response.setSuccess(status);
            response.setResponseCode(bankCode);
            response.setResponseMessage(bankMsg);
            if (StringUtils.isEmpty((String)remark)) continue;
            resultMap.put(remark, response);
        }
        return resultMap;
    }
}

