/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.payment.group;

import java.io.OutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.banks.abc.dc.service.WaitFlagHelper;
import kd.ebg.aqap.banks.abc.dc.service.payment.group.GroupQueryPayImpl;
import kd.ebg.aqap.banks.abc.dc.utils.MessageUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFieldConstants;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class GroupPayImpl
extends AbstractPayImpl
implements IPay {
    public void closeOutputStreamQuietly(OutputStream outputStream) {
        IOUtils.closeOutputStreamQuietly((OutputStream)outputStream);
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return GroupQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "CFRT01";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ed8\u6b3e:6.4\u96c6\u56e2\u5185\u6c47\u5151-\u5355\u7b14 (CFRT01\u4ea4\u6613)\u3002", (String)"GroupPayImpl_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return "pay".equalsIgnoreCase(info.getSubBizType()) && BankBusinessConfig.isGroupAcntPoolTransfer(info.getAccNo(), info.getIncomeAccNo());
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u519c\u884c\u7684\u96c6\u56e2\u5185\u6c47\u5151-\u5355\u7b14 (CFRT01\u4ea4\u6613)\u652f\u4ed8\u4e1a\u52a1\u4e0d\u652f\u6301\u6279\u91cf\u3002", (String)"GroupPayImpl_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
        }
        return GroupPayImpl.createMessage(paymentInfos[0]);
    }

    private static String createMessage(PaymentInfo paymentInfo) {
        Element root = ABC_DC_Packer.createABCRoot4New("CFRT01", paymentInfo.getBankDetailSeqId());
        PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)PaymentInfoSysFieldConstants.BANK_BATCH_SEQ_ID, (String)paymentInfo.getBankDetailSeqId());
        String amout = paymentInfo.getAmount().setScale(2, 4).toString();
        JDomUtils.addChild((Element)root, (String)"Amt", (String)amout);
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByPaymentInfo(paymentInfo, false));
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(paymentInfo.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbLogAccNo", (String)"");
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)paymentInfo.getCurrency());
        if (paymentInfo.getSameBank().booleanValue()) {
            JDomUtils.addChild((Element)cmp, (String)"CrProv", (String)AcntNumberHelper.getAreaCodeByPaymentInfo(paymentInfo, true));
        } else {
            JDomUtils.addChild((Element)cmp, (String)"CrProv", (String)"");
        }
        String incomeAccNo = paymentInfo.getIncomeAccNo();
        if (paymentInfo.getSameBank().booleanValue()) {
            incomeAccNo = AcntNumberHelper.fixAccNoTo15Or19(incomeAccNo);
        }
        JDomUtils.addChild((Element)cmp, (String)"CrAccNo", (String)incomeAccNo);
        JDomUtils.addChild((Element)cmp, (String)"CrLogAccNo", (String)"");
        JDomUtils.addChild((Element)cmp, (String)"CrCur", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)cmp, (String)"ConFlag", (String)"1");
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        boolean flag = BankBusinessConfig.isInnerPoolTransfer(paymentInfo.getAccNo(), paymentInfo.getIncomeAccNo());
        if (paymentInfo.getSameBank().booleanValue() && flag) {
            JDomUtils.addChild((Element)corp, (String)"OthBankFlag", (String)"1");
        } else {
            JDomUtils.addChild((Element)corp, (String)"OthBankFlag", (String)(paymentInfo.getSameBank() != false ? "0" : "1"));
        }
        JDomUtils.addChild((Element)corp, (String)"CrAccName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)corp, (String)"DbAccName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)corp, (String)"WhyUse", (String)paymentInfo.getUseCn());
        String exp = paymentInfo.getExplanation();
        JDomUtils.addChild((Element)corp, (String)"Postscript", (String)MessageUtil.getFixed30PostScript(exp));
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        PaymentInfo paymentInfo = paymentInfos[0];
        Element root = ABC_DC_Parser.parseString2Root(responseStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if (StrUtil.isEmpty((String)rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u62a5\u6587\u4e0d\u5b58\u5728RespCode\u8282\u70b9\u6216\u8be5\u8282\u70b9\u4e3a\u7a7a\u3002", (String)"GroupPayImpl_2", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(request.getPaymentInfos());
        }
        String WaitFlag = ABC_DC_Parser.parseWaitFlagMsg(root);
        if (!StrUtil.isEmpty((String)WaitFlag)) {
            WaitFlagHelper.parseWaitFlag(root, paymentInfo);
        }
        if ("0000".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u519c\u884c\u5df2\u53d7\u7406", (String)"GroupPayImpl_3", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)"", (String)WaitFlag);
        } else if ("9999".equalsIgnoreCase(rsp.getResponseCode()) || "CICS".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u5b9a", (String)"GroupPayImpl_4", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u672a\u77e5\u72b6\u6001\u3002", (String)"GroupPayImpl_5", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

