/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.payment.individual;

import java.io.OutputStream;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.banks.abc.dc.service.WaitFlagHelper;
import kd.ebg.aqap.banks.abc.dc.service.payment.individual.IndividualQueryPayImpl;
import kd.ebg.aqap.banks.abc.dc.service.payment.individual.salary.SalaryParser;
import kd.ebg.aqap.banks.abc.dc.utils.MessageUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.INativeLinkPayable;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFieldConstants;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class IndividualPayImpl
extends AbstractPayImpl
implements IPay,
INativeLinkPayable {
    public void closeOutputStreamQuietly(OutputStream outputStream) {
        IOUtils.closeOutputStreamQuietly((OutputStream)outputStream);
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return IndividualQueryPayImpl.class;
    }

    public String getDeveloper() {
        return "luo lei";
    }

    public String getBizCode() {
        return "CFRT21";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u516c\u5bf9\u79c1\u4ed8\u6b3e(\u975e\u4ee3\u53d1\u5de5\u8d44),\u6c47\u5151-\u5355\u7b14\u5bf9\u79c1 (CFRT21\u4ea4\u6613)", (String)"IndividualPayImpl_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo info) {
        return "pay_for_salary".equalsIgnoreCase(info.getSubBizType()) && info.is2SameBank() && !info.is2Merge() && (info.getTotalCount() <= 1 || !BankBusinessConfig.isTrans2Batch()) || "pay_for_capital_allocation".equalsIgnoreCase(info.getSubBizType()) && BankBusinessConfig.isAllocationToCompanyPay() && info.is2Individual() || "pay".equalsIgnoreCase(info.getSubBizType()) && !BankBusinessConfig.isGroupAcntPoolTransfer(info.getAccNo(), info.getIncomeAccNo()) && UseConvertor.isSalary((PaymentInfo)info) && info.is2SameBank() && !info.is2Merge() && (info.getTotalCount() <= 1 || !BankBusinessConfig.isTrans2Batch()) || "pay".equalsIgnoreCase(info.getSubBizType()) && UseConvertor.isTransfer((PaymentInfo)info) && BankBusinessConfig.isAllocationToCompanyPay() && info.is2Individual() || "pay".equalsIgnoreCase(info.getSubBizType()) && info.is2Individual() && info.is2SameBank() && (info.getTotalCount() <= 1 || !BankBusinessConfig.isTrans2Batch());
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        if (paymentInfos.length == 1) {
            return IndividualPayImpl.createMessage(paymentInfos[0]);
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6c47\u5151-\u5355\u7b14\u5bf9\u79c1 (CFRT21\u4ea4\u6613)\u4e0d\u652f\u6301\u6279\u91cf\u3002", (String)"IndividualPayImpl_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]));
    }

    private static String createMessage(PaymentInfo paymentInfo) {
        Element root = ABC_DC_Packer.createABCRoot4New("CFRT21", paymentInfo.getBankDetailSeqId());
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
        }
        PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)PaymentInfoSysFieldConstants.BANK_BATCH_SEQ_ID, (String)paymentInfo.getBankDetailSeqId());
        String amout = paymentInfo.getAmount().setScale(2, 4).toString();
        JDomUtils.addChild((Element)root, (String)"Amt", (String)amout);
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByPaymentInfo(paymentInfo, false));
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(paymentInfo.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbLogAccNo", (String)"");
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)cmp, (String)"CrProv", (String)IndividualPayImpl.getCrProvForCFRT21(paymentInfo));
        JDomUtils.addChild((Element)cmp, (String)"CrAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(paymentInfo.getIncomeAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"CrLogAccNo", (String)"");
        JDomUtils.addChild((Element)cmp, (String)"CrCur", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)cmp, (String)"ConFlag", (String)"1");
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"PsFlag", (String)"");
        JDomUtils.addChild((Element)corp, (String)"BookingDate", (String)LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)corp, (String)"BookingTime", (String)LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmss")));
        JDomUtils.addChild((Element)corp, (String)"BookingFlag", (String)"0");
        if (paymentInfo.getSameBank().booleanValue()) {
            JDomUtils.addChild((Element)corp, (String)"UrgencyFlag", (String)"Y");
        } else {
            JDomUtils.addChild((Element)corp, (String)"UrgencyFlag", (String)"N");
        }
        boolean flag = BankBusinessConfig.isInnerPoolTransfer(paymentInfo.getAccNo(), paymentInfo.getIncomeAccNo());
        if (paymentInfo.is2SameBank() && flag) {
            JDomUtils.addChild((Element)corp, (String)"OthBankFlag", (String)"1");
        } else {
            JDomUtils.addChild((Element)corp, (String)"OthBankFlag", (String)(paymentInfo.is2SameBank() ? "0" : "1"));
        }
        JDomUtils.addChild((Element)corp, (String)"CrAccName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)corp, (String)"DbAccName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)corp, (String)"WhyUse", (String)paymentInfo.getUseCn());
        String exp = paymentInfo.getExplanation();
        JDomUtils.addChild((Element)corp, (String)"Postscript", (String)(paymentInfo.is2SameBank() ? MessageUtil.getFixed35PostScript(exp) : MessageUtil.getFixed30PostScript(exp)));
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    private static String getCrProvForCFRT21(PaymentInfo paymentInfo) {
        String accNo = paymentInfo.getIncomeAccNo();
        String string = accNo = accNo == null ? "" : accNo.trim();
        if (accNo.length() == 16 || accNo.length() == 19) {
            return "";
        }
        return AcntNumberHelper.getAreaCodeByPaymentInfo(paymentInfo, true);
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        if (paymentInfos.length == 1) {
            PaymentInfo paymentInfo = paymentInfos[0];
            Element root = ABC_DC_Parser.parseString2Root(responseStr);
            BankResponse rsp = ABC_DC_Parser.parseHeader(root);
            if (StrUtil.isEmpty((String)rsp.getResponseCode())) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u62a5\u6587\u4e0d\u5b58\u5728RespCode\u8282\u70b9\u6216\u8be5\u8282\u70b9\u4e3a\u7a7a\u3002", (String)"IndividualPayImpl_2", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            } else if ("0000".equalsIgnoreCase(rsp.getResponseCode())) {
                WaitFlagHelper.parseWaitFlag(root, paymentInfo);
                String WaitFlag = ABC_DC_Parser.parseWaitFlagMsg(root);
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u519c\u884c\u5df2\u63a5\u6536", (String)"IndividualPayImpl_3", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)"", (String)WaitFlag);
            } else if ("9999".equalsIgnoreCase(rsp.getResponseCode()) || "CICS".equalsIgnoreCase(rsp.getResponseCode())) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u5b9a", (String)"IndividualPayImpl_4", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            } else {
                EBGBusinessUtils.setPaymentFailState((PaymentInfo)paymentInfo, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"IndividualPayImpl_5", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            }
        } else {
            new SalaryParser().parsePay(paymentInfos, responseStr);
        }
        return new EBBankPayResponse(request.getPaymentInfos());
    }
}

