/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.payment.individual.salary;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.ext.ABC_DCExtraConfig;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StrUtil;

public class SalaryHelper {
    public static final EBGLogger logger = EBGLogger.getInstance().getLogger(SalaryHelper.class);

    public static String sendAndRecvMessage(String sendMsg) {
        String res = null;
        try {
            ConnectionFactory factory = ConnectionFactory.getInstanceAutoInit();
            IConnection conn = factory.createExchangeConnection();
            conn.openConnection();
            try (OutputStream outputStream = conn.getOutputStream();){
                res = SalaryHelper.sendAndRecvMessage(conn, outputStream, sendMsg);
            }
            catch (Throwable t) {
                throw EBExceiptionUtil.serviceException((Throwable)t);
            }
        }
        catch (Throwable t) {
            throw EBExceiptionUtil.serviceException((Throwable)t);
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sendAndRecvMessage(IConnection conn, OutputStream outputStream, String sendMsg) {
        try {
            IOUtils.sendFully((OutputStream)outputStream, (String)sendMsg);
            try (InputStream inputStream = conn.getInputStream();){
                String rspStr;
                String string = rspStr = IOUtils.readFully((InputStream)inputStream);
                return string;
            }
            catch (Throwable t) {
                throw EBExceiptionUtil.serviceException((Throwable)t);
            }
        }
        catch (Throwable t) {
            throw EBExceiptionUtil.serviceException((Throwable)t);
        }
    }

    public static String getOppAcntnumber(String packageId) {
        int i = SalaryHelper.findIndex(packageId, 95, 2) + 1;
        int j = SalaryHelper.findIndex(packageId, 95, 3);
        return packageId.substring(i, j);
    }

    public static String getOppAmt(String packageId) {
        int i = SalaryHelper.findIndex(packageId, 95, 3) + 1;
        return packageId.substring(i);
    }

    public static int getSepCount(String data, int sep) {
        if (StrUtil.isEmpty((String)data)) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < data.length(); ++i) {
            if (data.charAt(i) != sep) continue;
            ++count;
        }
        return count;
    }

    public static int findIndex(String packageId, int sep, int count) {
        for (int i = 0; i < packageId.length(); ++i) {
            if (packageId.charAt(i) == sep && count == 0) {
                return i;
            }
            --count;
        }
        logger.info("can't find index for:" + packageId + ", " + sep + ", count " + count);
        return -1;
    }

    public static String getSalaryFileName(String packageId) {
        try {
            int i = SalaryHelper.findIndex(packageId, 95, 2);
            String fileName = packageId.substring(0, i);
            logger.info("packageId:" + packageId + ", FileName4Salary:" + fileName);
            return fileName;
        }
        catch (EBServiceException exception) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ece\u6d41\u6c34\u53f7\u4e2d\u83b7\u53d6\u6587\u4ef6\u540d\u79f0\u5931\u8d25.\u6d41\u6c34\u53f7\u4e3a:%1$s\u3002", (String)"SalaryHelper_4", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), packageId), (Throwable)exception);
        }
    }

    public static void createSalaryPaymentFile(PaymentInfo[] paymentInfos) {
        StringBuilder data = new StringBuilder();
        char newLine = '\n';
        String encoding = "GBK";
        String salaryFileName = SalaryHelper.getSalaryFileName(paymentInfos[0].getBankDetailSeqId());
        for (int i = 0; i < paymentInfos.length; ++i) {
            String oppAccName = paymentInfos[i].getIncomeAccName();
            String oppAccNo = paymentInfos[i].getIncomeAccNo();
            String amt = paymentInfos[i].getAmount().setScale(2, 4).toString();
            String usage = paymentInfos[i].getUseCn();
            data.append(SalaryHelper.format2SalaryStyle(oppAccName, 60, true)).append(SalaryHelper.format2SalaryStyle(oppAccNo, 30, true)).append(SalaryHelper.format2SalaryStyle(amt, 18, true)).append(SalaryHelper.format2SalaryStyle(usage, 30, true)).append(newLine);
        }
        String path = ABC_DCExtraConfig.getPath();
        File file = new File(path, salaryFileName);
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(data.toString().getBytes(encoding));
            fos.flush();
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u751f\u6210\u4ee3\u53d1\u5de5\u8d44\u6587\u4ef6\u5f02\u5e38\u3002", (String)"SalaryHelper_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private static String format2SalaryStyle(String paramString, int paramInt, boolean paramBoolean) {
        StringBuilder localStringBuilder = new StringBuilder();
        if (paramString.length() > paramInt) {
            throw EBExceiptionUtil.serviceException((String)(String.format(ResManager.loadKDString((String)"\u6570\u636e\u8d85\u957f.%1$s\u3002", (String)"SalaryHelper_5", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), paramString) + String.format(ResManager.loadKDString((String)"\u8d85\u8fc7\u8981\u6c42\u957f\u5ea6%1$s\u3002", (String)"SalaryHelper_6", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), paramInt)));
        }
        for (int i = 0; i < paramString.length() - paramInt; ++i) {
            localStringBuilder.append(' ');
        }
        String str = null;
        str = paramBoolean ? new String(localStringBuilder.append(paramString)) : paramString + new String(localStringBuilder);
        return str;
    }
}

