/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.abc.dc.service.payment.oversea;

import com.google.common.collect.Lists;
import com.jcraft.jsch.ChannelSftp;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Packer;
import kd.ebg.aqap.banks.abc.dc.service.ABC_DC_Parser;
import kd.ebg.aqap.banks.abc.dc.service.AcntNumberHelper;
import kd.ebg.aqap.business.file.AbstractAttachmentSftpImpl;
import kd.ebg.aqap.common.entity.biz.status.AttachmentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.model.repository.PaymentInfoRepository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.file.PayAttachment;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.file.FileCommonUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class AttachmentUploadImpl
extends AbstractAttachmentSftpImpl {
    private List<String> suffixs = Lists.newArrayList((Object[])new String[]{"pdf", "jpg", "jpeg", "bmp", "png"});
    private EBGLogger logger = EBGLogger.getInstance().getLogger(AttachmentUploadImpl.class);

    protected void attachmentRelatePay(List<PayAttachment> attachments, ChannelSftp channelSftp) {
        StringBuilder sb = new StringBuilder();
        int fileCount = 0;
        PaymentInfoRepository paymentInfoRepository = (PaymentInfoRepository)SpringContextUtil.getBean(PaymentInfoRepository.class);
        PaymentInfo paymentInfo = paymentInfoRepository.findByBankDetailSeqID(attachments.get(0).getBankDetailSeqID());
        for (int i = 0; i < attachments.size(); ++i) {
            PayAttachment payAttachment = attachments.get(i);
            if (StringUtils.isEmpty((String)payAttachment.getFileID())) {
                this.logger.info(String.format("\u9644\u4ef6%s\u4e0a\u4f20\u540e\u672a\u83b7\u53d6\u5230Ufile_ID\uff0c\u8df3\u8fc7\u9644\u4ef6\u5173\u8054", payAttachment.getFileName()));
                continue;
            }
            String fileName = payAttachment.getFileName();
            String suffix = fileName.substring(fileName.lastIndexOf(".") + 1);
            if (!this.suffixs.contains(suffix)) {
                this.logger.info(String.format("\u9644\u4ef6%s\u683c\u5f0f\u4e0d\u5728\u94f6\u884c\u652f\u6301\u8303\u56f4\u5185\uff0c\u8df3\u8fc7\u9644\u4ef6\u5173\u8054", payAttachment.getFileName()));
                continue;
            }
            sb.append(payAttachment.getFileID()).append("|_|").append(suffix).append("|_|").append(fileName).append("|_|").append(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"))).append("|_|").append(paymentInfo.getBankRefID()).append("|_|").append("\r\n");
            ++fileCount;
        }
        if (fileCount > 0) {
            this.logger.info("\u9644\u4ef6\u5173\u8054\u4ea4\u6613\u6587\u4ef6\u4e0a\u4f20\u5185\u5bb9:{}", (Object)sb.toString());
            String filename = attachments.get(0).getBankDetailSeqID() + "_CMRB82_" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) + ".txt";
            String overseaAttachmentPath = super.getOverseaAttachmentPath(attachments.get(0).getBankVersionID());
            String filePath = overseaAttachmentPath + File.separator + filename;
            try (FileOutputStream fileOutputStream = new FileOutputStream(FileCommonUtils.getFileByPath((String)overseaAttachmentPath, (String)filename));
                 OutputStreamWriter out = new OutputStreamWriter((OutputStream)fileOutputStream, "GBK");){
                out.write(sb.toString());
                out.flush();
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u9644\u4ef6\u5173\u8054\u6587\u4ef6\u751f\u6210\u5931\u8d25,%s", (String)"AttachmentUploadImpl_0", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
            boolean success = super.uploadToBankBySFTP(channelSftp, overseaAttachmentPath, filename, RequestContextUtils.getBankParameterValue((String)"upload_sftp_path"));
            if (success) {
                Element root = ABC_DC_Packer.createABCRoot4New("CMRB82", Sequence.genSequence());
                Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
                JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByPaymentInfo(paymentInfo, false));
                JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(paymentInfo.getAccNo()));
                JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)paymentInfo.getCurrency());
                Element tulip = JDomUtils.addChild((Element)root, (String)"Tulip");
                Element its = JDomUtils.addChild((Element)tulip, (String)"ITS");
                JDomUtils.addChild((Element)its, (String)"NUM_SEQ_REQ", (String)paymentInfo.getBankRefID());
                JDomUtils.addChild((Element)its, (String)"NUM_BUS_NO", (String)"");
                JDomUtils.addChild((Element)its, (String)"AMT_UFILE", (String)String.valueOf(fileCount));
                JDomUtils.addChild((Element)its, (String)"COD_MODU_TYP", (String)"RM");
                Map runningParams = EBContext.getContext().getRunningParams();
                if (runningParams != null) {
                    String COD_BUS_TYP = "";
                    String pay_impl = (String)runningParams.get("pay_impl");
                    if ("kd.ebg.aqap.banks.abc.dc.service.payment.oversea.GFRB10PayImpl".equalsIgnoreCase(pay_impl)) {
                        COD_BUS_TYP = "PAN0";
                    } else if ("kd.ebg.aqap.banks.abc.dc.service.payment.oversea.GFRB13PayImpl".equalsIgnoreCase(pay_impl)) {
                        COD_BUS_TYP = "NMN0";
                    }
                    JDomUtils.addChild((Element)its, (String)"COD_BUS_TYP", (String)COD_BUS_TYP);
                }
                JDomUtils.addChild((Element)cmp, (String)"BatchFileName", (String)filename);
                JDomUtils.addChild((Element)root, (String)"FileFlag", (String)"1");
                String rqstStr = ABC_DC_Packer.covert2ABCMessage(root);
                String rspStr = super.sendAndRecvMsg(rqstStr);
                this.paserRelate(attachments, rspStr);
            } else {
                attachments.forEach(attachment -> this.setUploadStatus((PayAttachment)attachment, AttachmentState.FAIL, "", ResManager.loadKDString((String)"\u5173\u8054\u9644\u4ef6\u4e0a\u4f20sftp\u5931\u8d25", (String)"AttachmentUploadImpl_1", (String)"ebg-aqap-banks-abc-dc", (Object[])new Object[0])));
            }
        }
    }

    private void paserRelate(List<PayAttachment> attachments, String rspStr) {
        Element root = ABC_DC_Parser.parseString2Root(rspStr);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if ("0000".equalsIgnoreCase(rsp.getResponseCode())) {
            attachments.forEach(attachment -> this.setUploadStatus((PayAttachment)attachment, AttachmentState.SUCCESS, rsp.getResponseCode(), rsp.getResponseMessage()));
        } else {
            attachments.forEach(attachment -> this.setUploadStatus((PayAttachment)attachment, AttachmentState.FAIL, rsp.getResponseCode(), rsp.getResponseMessage()));
        }
    }

    public String pack(PayAttachment payAttachment) {
        Element root = ABC_DC_Packer.createABCRoot4New(this.getBizCode(), Sequence.genSequence());
        Element cmp = JDomUtils.addChild((Element)root, (String)"Cmp");
        PaymentInfoRepository paymentInfoRepository = (PaymentInfoRepository)SpringContextUtil.getBean(PaymentInfoRepository.class);
        PaymentInfo paymentInfo = paymentInfoRepository.findByBankDetailSeqID(payAttachment.getBankDetailSeqID());
        HashMap<String, String> runningParams = EBContext.getContext().getRunningParams();
        if (runningParams == null) {
            runningParams = new HashMap<String, String>(5);
            EBContext.getContext().setRunningParams(runningParams);
        }
        runningParams.put("pay_impl", paymentInfo.getImplClassName());
        JDomUtils.addChild((Element)cmp, (String)"DbProv", (String)AcntNumberHelper.getAreaCodeByPaymentInfo(paymentInfo, false));
        JDomUtils.addChild((Element)cmp, (String)"DbAccNo", (String)AcntNumberHelper.fixAccNoTo15Or19(paymentInfo.getAccNo()));
        JDomUtils.addChild((Element)cmp, (String)"DbCur", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)cmp, (String)"BatchFileName", (String)payAttachment.getFileName());
        JDomUtils.addChild((Element)root, (String)"FileFlag", (String)"1");
        Element corp = JDomUtils.addChild((Element)root, (String)"Corp");
        JDomUtils.addChild((Element)corp, (String)"FileType", (String)"1");
        return ABC_DC_Packer.covert2ABCMessage(root);
    }

    public void parse(PayAttachment payAttachment, String s) {
        Element root = ABC_DC_Parser.parseString2Root(s);
        BankResponse rsp = ABC_DC_Parser.parseHeader(root);
        if ("0000".equalsIgnoreCase(rsp.getResponseCode())) {
            Element corp = JDomUtils.getChildElement((Element)root, (String)"Corp");
            String uFileId = JDomUtils.getChildText((Element)corp, (String)"UFileId");
            payAttachment.setFileID(uFileId);
            this.setUploadStatus(payAttachment, AttachmentState.SUBMITED, rsp.getResponseCode(), rsp.getResponseMessage());
        } else {
            this.setUploadStatus(payAttachment, AttachmentState.FAIL, rsp.getResponseCode(), rsp.getResponseMessage());
        }
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CMRB81";
    }

    public String getBizDesc() {
        return null;
    }
}

