/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Packer;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Parser;
import kd.ebg.aqap.banks.cib.dc.services.balance.TIMEDEPOSITQUERYTRNRQ;
import kd.ebg.aqap.banks.cib.dc.services.balance.TodayBalancePacker;
import kd.ebg.aqap.banks.cib.dc.services.balance.TodayBalanceParser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.aqap.common.framework.properties.BankAcntPropertyConfig;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final Logger logger = LoggerFactory.getLogger(BalanceImpl.class);

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/online/FOX4Securities");
    }

    public EBBankBalanceResponse doBizWithPage(BankBalanceRequest request) {
        BalanceInfo balanceInfo = null;
        try {
            ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
            do {
                EBBankBalanceResponse response = this.process(request);
                List balanceInfos = response.getBalances();
                balanceInfo = this.mergeBalance(balanceInfo, balanceInfos, request);
                balances = new ArrayList(1);
                balances.add(balanceInfo);
            } while (!this.isLastPage());
            return new EBBankBalanceResponse(balances);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public BalanceInfo mergeBalance(BalanceInfo balanceInfo, List<BalanceInfo> balanceInfos, BankBalanceRequest request) {
        if (balanceInfos.size() > 0) {
            BigDecimal totalBigDecimal = new BigDecimal("0.00");
            BigDecimal totalAvailableBalance = new BigDecimal("0.00");
            boolean isFirstRecord = false;
            if (balanceInfo == null) {
                isFirstRecord = true;
                balanceInfo = balanceInfos.get(0);
            }
            for (int i = 0; i < balanceInfos.size(); ++i) {
                if (isFirstRecord && i == 0) continue;
                BalanceInfo balanceInfoEntry = balanceInfos.get(i);
                BigDecimal balance = balanceInfoEntry.getCurrentBalance();
                if (balance != null) {
                    totalBigDecimal = totalBigDecimal.add(balance);
                }
                if (balanceInfoEntry.getAvailableBalance() == null) continue;
                totalAvailableBalance = totalAvailableBalance.add(balanceInfoEntry.getAvailableBalance());
            }
            balanceInfo.setCurrentBalance(balanceInfo.getCurrentBalance().add(totalBigDecimal));
            if (balanceInfo.getAvailableBalance() != null) {
                balanceInfo.setAvailableBalance(balanceInfo.getAvailableBalance().add(totalAvailableBalance));
            }
        }
        return balanceInfo;
    }

    public String pack(BankBalanceRequest request) {
        if ("fixed".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo()))) {
            return BankBusinessConfig.isDefaultBalInterface() ? this.packFixedBalance(request) : TIMEDEPOSITQUERYTRNRQ.pack(request);
        }
        this.setLastPage(true);
        if (BankBusinessConfig.selectBalanceAPI("SCUSTSTMTTRNRQ")) {
            return new TodayBalancePacker().packTodayBalance(request);
        }
        return new TodayBalancePacker().packCURRACCTQUERYTRNRQTodayBalance(request);
    }

    public String packFixedBalance(BankBalanceRequest request) {
        int beginNumber = Integer.parseInt(this.getCurrentPage()) + 1;
        String pageNo = String.valueOf(beginNumber);
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element in = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element timeQueryTrqElement = JDomUtils.addChild((Element)in, (String)"TIMEQUERYTRNRQ");
        String packageID = RequestContextUtils.getRequestContext().getBankRequestSeq();
        JDomUtils.addChild((Element)timeQueryTrqElement, (String)"TRNUID", (String)packageID);
        Element rQBODYElement = JDomUtils.addChild((Element)timeQueryTrqElement, (String)"RQBODY");
        rQBODYElement.setAttribute("PAGE", pageNo);
        JDomUtils.addChild((Element)rQBODYElement, (String)"ACCTID", (String)request.getAcnt().getAccNo());
        String encoding = RequestContextUtils.getCharset();
        String reqMsg = JDomUtils.root2String((Element)cms, (String)encoding);
        logger.info("\u5174\u4e1a\u94f6\u884c-\u67e5\u8be2\u5b9a\u671f\u6237\u4f59\u989d-\u63a5\u53e3-\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)reqMsg);
        return reqMsg;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        if ("fixed".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo()))) {
            this.setLastPage(true);
            return BankBusinessConfig.isDefaultBalInterface() ? this.parseFixedBalance(request, responseStr) : TIMEDEPOSITQUERYTRNRQ.parse(request, responseStr);
        }
        if (BankBusinessConfig.selectBalanceAPI("SCUSTSTMTTRNRQ")) {
            return new TodayBalanceParser().parseTodayBalance(request, responseStr);
        }
        return new TodayBalanceParser().parseCURRACCTQUERYTRNRQTodayBalance(request, responseStr);
    }

    public EBBankBalanceResponse parseFixedBalance(BankBalanceRequest request, String responseStr) {
        Element root = CIB_DC_Parser.parseString2Root(responseStr);
        Element SIGNONMSGSRSV1 = root.getChild("SIGNONMSGSRSV1");
        if (null != SIGNONMSGSRSV1) {
            String CODE = SIGNONMSGSRSV1.getChild("SONRS").getChild("STATUS").getChildText("CODE");
            String MESSAGE = SIGNONMSGSRSV1.getChild("SONRS").getChild("STATUS").getChildText("MESSAGE");
            if (!"0".equalsIgnoreCase(CODE.trim())) {
                throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)CODE, (String)MESSAGE));
            }
        }
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element timeQueryTrnElement = eb1.getChild("TIMEQUERYTRNRS");
        Element status = timeQueryTrnElement.getChild("STATUS");
        String iRetCode = status.getChildTextTrim("CODE");
        String msg = status.getChildTextTrim("MESSAGE");
        if (!"0".equalsIgnoreCase(iRetCode)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)iRetCode, (String)msg));
        }
        Element rsBodyElement = timeQueryTrnElement.getChild("RSBODY");
        String more = rsBodyElement.getAttributeValue("MORE");
        if ("Y".equalsIgnoreCase(more)) {
            this.setLastPage(false);
            int beginNumber = Integer.parseInt(this.getCurrentPage()) + 1;
            String pageNo = String.valueOf(beginNumber);
            this.setCurrentPage(pageNo);
        } else {
            this.setLastPage(true);
        }
        List contentElementList = rsBodyElement.getChildren("CONTENT");
        BankAcnt acnt = request.getAcnt();
        BalanceInfo balanceInfo = new BalanceInfo();
        balanceInfo.setBankAcnt(acnt);
        BigDecimal totalBalance = new BigDecimal("0.00");
        for (int i = 0; i < contentElementList.size(); ++i) {
            Element contentElement = (Element)contentElementList.get(i);
            String timeAcctId = contentElement.getChildTextTrim("TIMEACCTID");
            if (!acnt.getAccNo().equalsIgnoreCase(timeAcctId)) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u8d26\u53f7[%1$s]\u4e0e\u8bf7\u6c42\u8d26\u53f7[%2$s]\u4e0d\u4e00\u81f4\u3002", (String)"BalanceImpl_9", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), timeAcctId, acnt.getAccNo()));
            }
            String bankCurrency = contentElement.getChildTextTrim("CURRENCY");
            String balanceStr = contentElement.getChildTextTrim("BALAMT");
            if (!StringUtils.isNotEmpty((String)balanceStr) || !request.getBankCurrency().equals(bankCurrency)) continue;
            BigDecimal balance = new BigDecimal(balanceStr);
            totalBalance = totalBalance.add(balance);
        }
        balanceInfo.setBankCurrency(request.getBankCurrency());
        balanceInfo.setCurrentBalance(totalBalance);
        balanceInfo.setBalanceDateTime(LocalDateTime.now());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String getDeveloper() {
        return "zhangyp";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5174\u4e1a\u94f6\u884c-\u4f59\u989d\u67e5\u8be2", (String)"BalanceImpl_6", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean isSupportPage(BankBalanceRequest request) {
        return "fixed".equalsIgnoreCase(BankAcntPropertyConfig.getAccType((String)request.getAcnt().getAccNo()));
    }
}

