/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.detail;

import java.util.ArrayList;
import java.util.Collection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.ebg.aqap.banks.cib.dc.services.detail.DetailPacker;
import kd.ebg.aqap.banks.cib.dc.services.detail.DetailPage;
import kd.ebg.aqap.banks.cib.dc.services.detail.DetailParser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static Logger logger = LoggerFactory.getLogger(DetailImpl.class);

    public String getDeveloper() {
        return "zhangyp";
    }

    public String getBizCode() {
        return "SECURITIES_MSGSRQV1";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5174\u4e1a\u94f6\u884c\u4ea4\u6613\u660e\u7ec6", (String)"DetailImpl_0", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/online/FOX4Securities");
    }

    public EBBankDetailResponse detail(BankDetailRequest request) {
        ArrayList detailInfos = new ArrayList(100);
        String pageTag = DetailPage.getFirstPageTag();
        this.setCurrentPage(pageTag);
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankDetailResponse ebBankDetailResponse = this.doBiz(request);
            logger.info("details\u7684\u6570\u91cf{}", (Object)ebBankDetailResponse.getDetails().size());
            if (ebBankDetailResponse == null || CollectionUtils.isEmpty((Collection)ebBankDetailResponse.getDetails())) continue;
            detailInfos.addAll(ebBankDetailResponse.getDetails());
        }
        logger.info("detailInfos\u7684\u6570\u91cf{}", (Object)detailInfos.size());
        return new EBBankDetailResponse(detailInfos);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        return this.detail(request);
    }

    public String pack(BankDetailRequest request) {
        return new DetailPacker().packTodayDetail(request, this.getCurrentPage());
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        String pageTag = this.getCurrentPage();
        String pageTagNext = DetailPage.getNextPageTag(responseStr, pageTag);
        this.setCurrentPage(pageTagNext);
        boolean lastPage = DetailPage.isLastPage(pageTagNext);
        this.setLastPage(lastPage);
        return new EBBankDetailResponse(new DetailParser().parseDetail(request, responseStr));
    }
}

