/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment.agency;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import kd.ebg.aqap.banks.cib.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Constants;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Packer;
import kd.ebg.aqap.banks.cib.dc.utils.DateHelper;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Attribute;
import org.jdom2.CDATA;
import org.jdom2.Element;

public class PayPacker
implements CIB_DC_Constants {
    public String packPay(PaymentInfo[] paymentInfos) throws EBServiceException {
        Integer length = paymentInfos.length;
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element asyrq = JDomUtils.addChild((Element)msgsv, (String)"ASYNBATCHMRCHAGENTTRNRQ");
        JDomUtils.addChild((Element)asyrq, (String)"TRNUID", (String)paymentInfos[0].getBankBatchSeqId());
        Element bodyrq = JDomUtils.addChild((Element)asyrq, (String)"RQBODY");
        JDomUtils.addChild((Element)bodyrq, (String)"TITLE");
        JDomUtils.addChild((Element)bodyrq, (String)"TOTALCOUNT", (String)(paymentInfos.length + ""));
        JDomUtils.addChild((Element)bodyrq, (String)"TOTALAMOUNT", (String)this.getTotalAmount(paymentInfos));
        String accNo = paymentInfos[0].getAccNo();
        String mrchno = BankBusinessConfig.getMrchnoByAcnt(accNo);
        JDomUtils.addChild((Element)bodyrq, (String)"MRCHNO", (String)mrchno);
        Element acctfrom = JDomUtils.addChild((Element)bodyrq, (String)"ACCTFROM");
        JDomUtils.addChild((Element)acctfrom, (String)"ACCTID", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)acctfrom, (String)"NAME", (String)paymentInfos[0].getAccName());
        JDomUtils.addChild((Element)acctfrom, (String)"BANKDESC", (String)paymentInfos[0].getBankName());
        JDomUtils.addChild((Element)acctfrom, (String)"CITY", (String)paymentInfos[0].getAccCity());
        JDomUtils.addChild((Element)bodyrq, (String)"PURPOSE");
        JDomUtils.addChild((Element)bodyrq, (String)"MEMO", (String)paymentInfos[0].getExplanation());
        JDomUtils.addChild((Element)bodyrq, (String)"EXPECT_DATE", (String)DateHelper.formatDate(paymentInfos[0].getBookingTime().toLocalDate(), "yyyy-MM-dd"));
        PaymentUtil.setBookPayFlag((PaymentInfo[])paymentInfos);
        Attribute attribute = new Attribute("size", length.toString());
        JDomUtils.addChild((Element)bodyrq, (String)"XFERINFOTEXT").setAttribute(attribute).setContent((Collection)Lists.newArrayList((Object[])new CDATA[]{new CDATA(this.getDeatil(paymentInfos))}));
        return JDomUtils.root2String((Element)cms, (String)RequestContextUtils.getCharset());
    }

    private String getTotalAmount(PaymentInfo[] paymentInfos) {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        for (PaymentInfo info : paymentInfos) {
            bigDecimal = bigDecimal.add(info.getAmount());
        }
        return bigDecimal.toString();
    }

    private String getDeatil(PaymentInfo[] paymentInfos) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < paymentInfos.length; ++i) {
            sb.append(i + 1).append("|");
            sb.append(paymentInfos[i].getDetailSeqId()).append("|");
            sb.append("").append("|");
            sb.append(paymentInfos[i].getIncomeAccNo()).append("|");
            sb.append(paymentInfos[i].getIncomeAccName()).append("|");
            sb.append(paymentInfos[i].getIncomeCnaps()).append("|");
            sb.append("0").append("|");
            sb.append(paymentInfos[i].getIncomeBankName()).append("|");
            sb.append(paymentInfos[i].getAmount().toString()).append("|");
            sb.append(paymentInfos[i].getUseCn()).append("|");
            sb.append("\n");
        }
        return sb.toString();
    }
}

