/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment.company;

import java.time.LocalDate;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Packer;
import kd.ebg.aqap.banks.cib.dc.utils.DateHelper;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class Pay_Company_Packer {
    public String packPay(PaymentInfo[] paymentInfos) throws EBServiceException {
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u5174\u4e1a\u94f6\u884c\u4e0d\u652f\u6301\u6279\u91cf\u652f\u4ed8", (String)"Pay_Company_Packer_0", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]));
        }
        String exp = paymentInfos[0].getExplanation();
        String kd = "";
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfos[0]);
            kd = BizNoUtil.cont((String)paymentInfos[0].getBankDetailSeqId(), (String)exp);
        }
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element stmt = JDomUtils.addChild((Element)msgsv, (String)"XFERTRNRQ");
        JDomUtils.addChild((Element)stmt, (String)"TRNUID", (String)paymentInfos[0].getBankDetailSeqId());
        Element rd = JDomUtils.addChild((Element)stmt, (String)"XFERRQ");
        Element xferInfo = JDomUtils.addChild((Element)rd, (String)"XFERINFO");
        Element acctFrom = JDomUtils.addChild((Element)xferInfo, (String)"ACCTFROM");
        JDomUtils.addChild((Element)acctFrom, (String)"ACCTID", (String)paymentInfos[0].getAccNo());
        JDomUtils.addChild((Element)acctFrom, (String)"NAME", (String)paymentInfos[0].getAccName());
        JDomUtils.addChild((Element)acctFrom, (String)"BANKDESC", (String)paymentInfos[0].getBankName());
        JDomUtils.addChild((Element)acctFrom, (String)"CITY", (String)paymentInfos[0].getAccCity());
        Element acctTo = JDomUtils.addChild((Element)xferInfo, (String)"ACCTTO");
        if (paymentInfos[0].is2SameBank()) {
            acctTo.setAttribute("INTERBANK", "Y");
        } else {
            acctTo.setAttribute("INTERBANK", "N");
        }
        if (paymentInfos[0].is2SameCity()) {
            acctTo.setAttribute("LOCAL", "Y");
        } else {
            acctTo.setAttribute("LOCAL", "N");
        }
        JDomUtils.addChild((Element)acctTo, (String)"ACCTID", (String)paymentInfos[0].getIncomeAccNo());
        JDomUtils.addChild((Element)acctTo, (String)"NAME", (String)paymentInfos[0].getIncomeAccName());
        JDomUtils.addChild((Element)acctTo, (String)"BANKDESC", (String)paymentInfos[0].getIncomeBankName());
        JDomUtils.addChild((Element)acctTo, (String)"BANKNUM", (String)paymentInfos[0].getIncomeCnaps());
        JDomUtils.addChild((Element)acctTo, (String)"CITY", (String)paymentInfos[0].getIncomeCity());
        JDomUtils.addChild((Element)xferInfo, (String)"CURSYM", (String)"RMB");
        JDomUtils.addChild((Element)xferInfo, (String)"TRNAMT", (String)paymentInfos[0].getAmount().setScale(2, 1).toString());
        JDomUtils.addChild((Element)xferInfo, (String)"PMTMODE", (String)"REAL_TIME");
        if (StringUtils.isEmpty((String)kd)) {
            JDomUtils.addChild((Element)xferInfo, (String)"PURPOSE", (String)exp);
        } else {
            JDomUtils.addChild((Element)xferInfo, (String)"PURPOSE", (String)kd);
        }
        JDomUtils.addChild((Element)xferInfo, (String)"DTDUE", (String)DateHelper.formatDate(LocalDate.now(), "yyyy-MM-dd"));
        JDomUtils.addChild((Element)xferInfo, (String)"MEMO", (String)exp);
        String encoding = RequestContextUtils.getCharset();
        return JDomUtils.root2String((Element)cms, (String)encoding);
    }
}

