/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment.linkpay;

import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Parser;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.string.StringUtils;
import org.jdom2.Element;

public class LinkPayParser {
    public void parsePay(PaymentInfo[] paymentInfos, String rspStr) throws EBServiceException {
        String bankMsg;
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        Element eb1 = root.getChild("SECURITIES_MSGSRSV1");
        Element eb = eb1.getChild("XPMTTRNRS");
        Element pub = eb.getChild("STATUS");
        String recode = pub.getChildTextTrim("CODE");
        String reMessage = pub.getChildTextTrim("MESSAGE");
        String errorMessage = pub.getChildText("MESSAGE");
        String bankCode = recode;
        String string = bankMsg = StringUtils.isEmpty((String)reMessage) ? errorMessage : reMessage;
        if (!"0".equalsIgnoreCase(recode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankCode, (String)bankMsg);
            return;
        }
        Element er = eb.getChild("XPMTRS");
        Element xferprcsts = er.getChild("XFERPRCSTS");
        String xferprCode = xferprcsts.getChildText("XFERPRCCODE");
        String message = xferprcsts.getChildText("MESSAGE");
        String responseCode = xferprCode;
        String responseMsg = message;
        if (!StringUtils.isEmpty((String)responseMsg)) {
            bankMsg = responseMsg;
        }
        if (!StringUtils.isEmpty((String)xferprCode)) {
            bankCode = xferprCode;
        }
        if ("PAYOUT".equalsIgnoreCase(responseCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUCCESS, (String)"", (String)bankCode, (String)bankMsg);
        } else if ("PENDING".equalsIgnoreCase(responseCode) || "EXPIRED".equalsIgnoreCase(responseCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.UNKNOWN, (String)"", (String)bankCode, (String)bankMsg);
        } else if ("FAIL".equalsIgnoreCase(responseCode) || "CANCEL".equalsIgnoreCase(responseCode)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.FAIL, (String)"", (String)bankCode, (String)bankMsg);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfos[0], (PaymentState)PaymentState.SUBMITED, (String)"", (String)bankCode, (String)bankMsg);
        }
    }
}

