/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment.salary;

import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.bank.info.BankResponse;

public class SalaryCodeUtils {
    private static String[] successCodes = new String[]{"23"};
    private static String[] failedCodes = new String[]{"41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "59"};

    private static boolean isSuccessed(String code) {
        boolean flag = false;
        for (String successCode : successCodes) {
            if (!successCode.equalsIgnoreCase(code)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private static boolean isFailed(String code) {
        boolean flag = false;
        for (String failedCode : failedCodes) {
            if (!failedCode.equalsIgnoreCase(code)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static void setPaymentInfoStatus(Map<String, BankResponse> codeMap, PaymentInfo[] paymentInfos) {
        for (PaymentInfo payInfo : paymentInfos) {
            String bankDetialSeq = payInfo.getBankDetailSeqId();
            if (codeMap.containsKey(bankDetialSeq)) {
                BankResponse bankResponse = codeMap.get(bankDetialSeq);
                if (SalaryCodeUtils.isFailed(bankResponse.getResponseCode())) {
                    EBGBusinessUtils.setPaymentFailState((PaymentInfo)payInfo, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"SalaryCodeUtils_0", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
                    continue;
                }
                if (SalaryCodeUtils.isSuccessed(bankResponse.getResponseCode())) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"SalaryCodeUtils_1", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
                    continue;
                }
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"SalaryCodeUtils_2", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u65e0\u6cd5\u5339\u914d\u94f6\u884c\u8fd4\u56de\u7684\u660e\u7ec6\u6d41\u6c34\uff0c\u4ea4\u6613\u72b6\u6001\u65e0\u6cd5\u786e\u5b9a\u3002", (String)"SalaryCodeUtils_3", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)"", (String)"");
        }
    }

    public static void setPaymentInfoStatus(PaymentInfo paymentInfo, String code, String msg) {
        if (SalaryCodeUtils.isFailed(code)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\u3002", (String)"SalaryCodeUtils_4", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)code, (String)msg);
        } else if (SalaryCodeUtils.isSuccessed(code)) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f\u3002", (String)"SalaryCodeUtils_5", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)code, (String)msg);
        } else {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5\u3002", (String)"SalaryCodeUtils_6", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)code, (String)msg);
        }
    }
}

