/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cib.dc.services.payment.salarynew;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cib.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Packer;
import kd.ebg.aqap.banks.cib.dc.services.CIB_DC_Parser;
import kd.ebg.aqap.banks.cib.dc.services.payment.salarynew.SalaryQueryPayImpl;
import kd.ebg.aqap.banks.cib.dc.utils.BankUtils;
import kd.ebg.aqap.banks.cib.dc.utils.FileUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.file.FileCommonUtils;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class SalaryPaymentImpl
extends AbstractPayImpl
implements IPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(SalaryPaymentImpl.class);
    private static final String SPERATE = "|";

    public int getBatchSize() {
        return 1000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryQueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        StringBuilder build = new StringBuilder();
        for (PaymentInfo paymentInfo : paymentInfos) {
            build.append(paymentInfo.getBankDetailSeqId()).append(SPERATE);
            build.append(paymentInfo.getIncomeAccName()).append(SPERATE);
            build.append(paymentInfo.getIncomeAccNo()).append(SPERATE);
            build.append(paymentInfo.getAmount().toString()).append(SPERATE);
            build.append(paymentInfo.getExplanation()).append(SPERATE);
            build.append(paymentInfo.getIncomeCnaps()).append(SPERATE);
            build.append("\n");
        }
        String filename = ((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId() + ".txt";
        String filePath = BankUtils.getBankVersionConfigPath() + File.separator + filename;
        try (FileOutputStream fileOutputStream = new FileOutputStream(FileCommonUtils.checkPath((String)filePath));
             OutputStreamWriter out = new OutputStreamWriter((OutputStream)fileOutputStream, "GBK");){
            out.write(build.toString());
            out.flush();
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ee3\u53d1\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff0c%s\u3002", (String)"SalaryPaymentImpl_9", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        File upload = new File(FileCommonUtils.checkPath((String)filePath));
        String md5 = BankUtils.getMD5(upload);
        String fileId = null;
        try {
            fileId = FileUtil.getInstance().uploadFileByHttp(upload);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c%s\u3002", (String)"SalaryPaymentImpl_10", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        if (StringUtils.isEmpty((String)fileId)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0a\u4f20\u6587\u4ef6\u94f6\u884c\u8fd4\u56de\u6587\u4ef6ID\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u7ee7\u7eed\u4ed8\u6b3e\u3002", (String)"SalaryPaymentImpl_3", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]));
        }
        Element cms = CIB_DC_Packer.buildHeadMessage();
        Element msgsv = JDomUtils.addChild((Element)cms, (String)"SECURITIES_MSGSRQV1");
        Element reptrnrq = JDomUtils.addChild((Element)msgsv, (String)"ASYNPAYOFFTRNRQ");
        JDomUtils.addChild((Element)reptrnrq, (String)"TRNUID", (String)((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId());
        Element rqbody = JDomUtils.addChild((Element)reptrnrq, (String)"RQBODY");
        JDomUtils.addChild((Element)rqbody, (String)"INTERBANK", (String)"N");
        JDomUtils.addChild((Element)rqbody, (String)"IS_HIDE_DETAIL", (String)"N");
        JDomUtils.addChild((Element)rqbody, (String)"ACCTID", (String)((PaymentInfo)paymentInfos.get(0)).getAccNo());
        JDomUtils.addChild((Element)rqbody, (String)"NAME", (String)((PaymentInfo)paymentInfos.get(0)).getAccName());
        JDomUtils.addChild((Element)rqbody, (String)"TITLE", (String)ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44", (String)"SalaryPaymentImpl_4", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]));
        JDomUtils.addChild((Element)rqbody, (String)"DESCRIPTION", (String)"006");
        JDomUtils.addChild((Element)rqbody, (String)"DTDUE", (String)"");
        JDomUtils.addChild((Element)rqbody, (String)"REMARK", (String)((PaymentInfo)paymentInfos.get(0)).getExplanation());
        JDomUtils.addChild((Element)rqbody, (String)"FILEID", (String)fileId);
        JDomUtils.addChild((Element)rqbody, (String)"FILENAME", (String)filename);
        JDomUtils.addChild((Element)rqbody, (String)"FILE_MD5", (String)md5);
        return JDomUtils.root2String((Element)cms, (String)RequestContextUtils.getCharset());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        Element root = CIB_DC_Parser.parseString2Root(rspStr);
        List paymentInfos = bankPayRequest.getPaymentInfos();
        Element secmsg = root.getChild("SECURITIES_MSGSRSV1");
        Element rpaytrnrs = JDomUtils.getChildElement((Element)secmsg, (String)"ASYNPAYOFFTRNRS");
        String trnuid = JDomUtils.getChildTextNotNull((Element)rpaytrnrs, (String)"TRNUID");
        BankResponse bankResponse = new BankResponse();
        Element status = JDomUtils.getChildElement((Element)rpaytrnrs, (String)"STATUS");
        String code = JDomUtils.getChildText((Element)status, (String)"CODE");
        String result = JDomUtils.getChildText((Element)status, (String)"RESULT");
        String message = JDomUtils.getChildText((Element)status, (String)"MESSAGE");
        bankResponse.setResponseCode(code);
        bankResponse.setResponseMessage(message);
        if (!((PaymentInfo)paymentInfos.get(0)).getBankBatchSeqId().equals(trnuid)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u6279\u6b21\u53f7\u4e0d\u5339\u914d\u3002", (String)"SalaryPaymentImpl_5", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)code, (String)message);
            return new EBBankPayResponse(paymentInfos);
        }
        if (!"0".equals(bankResponse.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"SalaryPaymentImpl_6", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SalaryPaymentImpl_7", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]), (String)code, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"SalaryPaymentImpl_7", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]));
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "ASYNPAYOFFTRNRQ";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f02\u6b65\u4ee3\u53d1\u5de5\u8d44\u8bf7\u6c42ASYNPAYOFFTRNRQ", (String)"SalaryPaymentImpl_8", (String)"ebg-aqap-banks-cib-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        boolean flag = this.isSalary(paymentInfo) || Objects.equals("pay", paymentInfo.getSubBizType());
        return flag && UseConvertor.isSalary((PaymentInfo)paymentInfo) && paymentInfo.is2Individual() && BankBusinessConfig.isChooseNewSalary();
    }
}

