/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.tlyh.dc.services.balance;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.tlyh.dc.services.utils.Helper;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);
    private static final String serviceId = "dpstAcctQueryBCDC";

    public String pack(BankBalanceRequest bankBalanceRequest) {
        BankAcnt bankAcnt = bankBalanceRequest.getAcnt();
        Element root = JDomUtils.createRoot((String)"reqData");
        Element head = JDomUtils.addChild((Element)root, (String)"head");
        JDomUtils.addChild((Element)head, (String)"serviceId", (String)serviceId);
        JDomUtils.addChild((Element)head, (String)"bussSeqNo", (String)"123413241");
        JDomUtils.addChild((Element)head, (String)"txSno", (String)Sequence.gen16Sequence());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"acctName", (String)bankAcnt.getAccName());
        JDomUtils.addChild((Element)body, (String)"clientName", (String)RequestContextUtils.getBankParameterValue((String)"clientName"));
        JDomUtils.addChild((Element)body, (String)"ccy", (String)bankBalanceRequest.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"clientNo", (String)RequestContextUtils.getBankParameterValue((String)"clientNo"));
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)bankAcnt.getAccNo());
        return Helper.element2jsonStr(root);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String respStr) {
        if (StringUtils.isEmpty((String)respStr)) {
            this.logger.info("\u94f6\u884c\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a");
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"BalanceImpl_0", (String)"ebg-aqap-banks-tlyh-dc", (Object[])new Object[0]));
        }
        BalanceInfo balanceInfo = new BalanceInfo();
        JSONObject jsonObject = JSONObject.parseObject((String)respStr);
        JSONObject rspData = jsonObject.getJSONObject("rspData");
        JSONObject head = rspData.getJSONObject("head");
        BankResponse rsp = new BankResponse();
        rsp.setResponseCode(head.getString("errorCode"));
        rsp.setResponseMessage(head.getString("errorMsg"));
        if (!"000000".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u8fd4\u56de\u4e86\u975e\u6b63\u5e38\u7684\u8fd4\u56de\u7801\uff1a%1$s;\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%2$s\u3002", (String)"BalanceImpl_3", (String)"ebg-aqap-banks-tlyh-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        JSONObject body = rspData.getJSONObject("body");
        String acNo = body.getString("dmdAcctNo");
        String lastDayBal = body.getString("lastDayBal");
        String olAcctBal = body.getString("olAcctBal");
        String availBal = body.getString("avlblBal");
        String ccy = body.getString("ccy");
        this.setBankAcnt(balanceInfo, bankBalanceRequest.getBankAcntList(), acNo);
        this.setLastDayAvlBalance(balanceInfo, lastDayBal);
        this.setAvailableBalance(balanceInfo, availBal);
        this.setCurrentBalance(balanceInfo, olAcctBal);
        this.setBankCurrency(balanceInfo, ccy);
        this.setBalanceDateTime(balanceInfo, LocalDateTime.now());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/preSfpPOST");
        factory.setHttpHeader("Content-Type", "application/json");
    }
}

