/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.tlyh.dc.services.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.tlyh.dc.services.detail.DetailPage;
import kd.ebg.aqap.banks.tlyh.dc.services.utils.Helper;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(DetailImpl.class);

    public String pack(BankDetailRequest bankDetailRequest) {
        Element root = JDomUtils.createRoot((String)"reqData");
        Element head = JDomUtils.addChild((Element)root, (String)"head");
        JDomUtils.addChild((Element)head, (String)"serviceId", (String)"dpstAcctTranQryBCDC");
        JDomUtils.addChild((Element)head, (String)"bussSeqNo", (String)"123413241");
        JDomUtils.addChild((Element)head, (String)"txSno", (String)Sequence.gen16Sequence());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        JDomUtils.addChild((Element)body, (String)"cardNo", (String)bankDetailRequest.getAcnt().getAccNo());
        JDomUtils.addChild((Element)body, (String)"ccy", (String)bankDetailRequest.getBankCurrency());
        JDomUtils.addChild((Element)body, (String)"startDate", (String)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"endDate", (String)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)body, (String)"acctName", (String)bankDetailRequest.getAcnt().getAccName());
        JDomUtils.addChild((Element)body, (String)"clientNo", (String)RequestContextUtils.getBankParameterValue((String)"clientNo"));
        JDomUtils.addChild((Element)body, (String)"totalNum", (String)"50");
        if ("0".equalsIgnoreCase(this.getCurrentPage())) {
            this.setCurrentPage("1");
        }
        JDomUtils.addChild((Element)body, (String)"currentNum", (String)this.getCurrentPage());
        return Helper.element2jsonStr(root);
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String responseStr) {
        String pageTagNext = DetailPage.getNextPageTag(this.getCurrentPage());
        this.setCurrentPage(pageTagNext);
        boolean lastPage = DetailPage.isLastPage(responseStr);
        this.setLastPage(lastPage);
        JSONObject jsonObject = JSONObject.parseObject((String)responseStr);
        JSONObject rspData = jsonObject.getJSONObject("rspData");
        JSONObject head = rspData.getJSONObject("head");
        BankResponse rsp = new BankResponse();
        rsp.setResponseCode(head.getString("errorCode"));
        rsp.setResponseMessage(head.getString("errorMsg"));
        if (!"000000".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u8fd4\u56de\u4e86\u975e\u6b63\u5e38\u7684\u8fd4\u56de\u7801\uff1a%1$s;\u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%2$s\u3002", (String)"DetailImpl_3", (String)"ebg-aqap-banks-tlyh-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(16);
        JSONObject body = rspData.getJSONObject("body");
        JSONArray lbyAcctDtlArray = body.getJSONArray("lbyAcctDtlArray");
        HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
        if (lbyAcctDtlArray != null && !lbyAcctDtlArray.isEmpty()) {
            for (int i = 0; i < lbyAcctDtlArray.size(); ++i) {
                try {
                    JSONObject jsonObject1 = lbyAcctDtlArray.getJSONObject(i);
                    DetailInfo info = new DetailInfo();
                    String oriTranDate = jsonObject1.getString("oriTranDate");
                    String oriTxnTime = jsonObject1.getString("oriTxnTime");
                    String ccy = jsonObject1.getString("ccy");
                    String oriTellerSeqNo = jsonObject1.getString("oriTellerSeqNo");
                    String drAmt = jsonObject1.getString("drAmt");
                    String crAmt = jsonObject1.getString("crAmt");
                    String balance = jsonObject1.getString("olAcctBal");
                    String remark = jsonObject1.getString("smmryMsg");
                    String remark1 = jsonObject1.getString("postscript");
                    String acctNo = jsonObject1.getString("acctNo");
                    String acctName = jsonObject1.getString("acctName");
                    String openBankName = jsonObject1.getString("openBankName");
                    info.setOppAccNo(acctNo);
                    info.setOppAccName(acctName);
                    info.setOppBankName(openBankName);
                    info.setDebitAmount(new BigDecimal(drAmt));
                    info.setCreditAmount(new BigDecimal(crAmt));
                    if (!StringUtils.isEmpty((String)balance)) {
                        info.setBalance(new BigDecimal(balance));
                    }
                    info.setCurrency(ccy);
                    info.setExplanation(remark + "," + remark1);
                    String time = oriTranDate + " " + oriTxnTime;
                    info.setTransDate(LocalDate.parse(oriTranDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
                    info.setTransTime(LocalDateTime.parse(time, DateTimeFormatter.ofPattern("yyyyMMdd HHmmssSSS")));
                    info.setBankDetailNo(oriTellerSeqNo);
                    String dcFlag = info.getDebitAmount().compareTo(BigDecimal.ZERO) == 0 ? "C" : "D";
                    jsonObject1.put("drCrFlag", (Object)dcFlag);
                    jsonObject1.put("oriTranAmt", (Object)info.getCreditAmount().add(info.getDebitAmount()).toPlainString());
                    String receiptNo = MatchRule.getInstance().getReceiptNo(bankDetailRequest.getAcnt().getAccNo(), oriTranDate, jsonObject1.toString());
                    if (countMap.containsKey(receiptNo)) {
                        int count = (Integer)countMap.get(receiptNo) + 1;
                        countMap.put(receiptNo, count);
                        receiptNo = receiptNo + "-" + String.format("%04d", count);
                    } else {
                        countMap.put(receiptNo, 0);
                    }
                    info.setReceiptNo(receiptNo);
                    info.setJsonMap(jsonObject1.toString());
                    info.setAccNo(bankDetailRequest.getAcnt().getAccNo());
                    info.setAccName(bankDetailRequest.getAcnt().getAccName());
                    detailInfos.add(info);
                    continue;
                }
                catch (Exception e) {
                    this.logger.info("\u89e3\u6790\u7b2c{}\u660e\u7ec6\u5f02\u5e38", (Object)i);
                }
            }
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "dpstAcctTranQryBCDC";
    }

    public String getBizDesc() {
        return null;
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/preSfpPOST");
        factory.setHttpHeader("Content-Type", "application/json");
    }

    public boolean isSupportPage() {
        return true;
    }
}

