/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.tlyh.dc.services.payment.company;

import com.alibaba.fastjson.JSONObject;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.tlyh.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.tlyh.dc.services.payment.company.QueryPayImpl;
import kd.ebg.aqap.banks.tlyh.dc.services.utils.Helper;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        Element root = JDomUtils.createRoot((String)"reqData");
        Element head = JDomUtils.addChild((Element)root, (String)"head");
        JDomUtils.addChild((Element)head, (String)"serviceId", (String)"singleTransferBCDC");
        JDomUtils.addChild((Element)head, (String)"bussSeqNo", (String)"123413241");
        JDomUtils.addChild((Element)head, (String)"txSno", (String)Sequence.gen16Sequence());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        PaymentInfo paymentInfo = (PaymentInfo)bankPayRequest.getPaymentInfos().get(0);
        String payDate = paymentInfo.getBookingTime() != null ? paymentInfo.getBookingTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")) : LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        PaymentUtil.setBookPayFlag((List)bankPayRequest.getPaymentInfos());
        String realTmFlg = "";
        realTmFlg = paymentInfo.is2SameBank() ? "1" : "2";
        String extPymtAcctNo = paymentInfo.getAccNo();
        String payerAcctNm = paymentInfo.getAccName();
        String tranAmt = paymentInfo.getAmount().toString();
        String remark = paymentInfo.getExplanation();
        String ccy = paymentInfo.getCurrency();
        String pyeeCstmrAcct = paymentInfo.getIncomeAccNo();
        String pyeeAcctNm = paymentInfo.getIncomeAccName();
        String payeeOpenBankInterbankNo = paymentInfo.getIncomeCnaps();
        String aprvOprtFlg = BankBusinessConfig.isSinglePayApproval();
        String clientNo = RequestContextUtils.getParameter().getBankParameter("clientNo");
        JDomUtils.addChild((Element)body, (String)"payDate", (String)payDate);
        JDomUtils.addChild((Element)body, (String)"realTmFlg", (String)realTmFlg);
        JDomUtils.addChild((Element)body, (String)"extPymtAcctNo", (String)extPymtAcctNo);
        JDomUtils.addChild((Element)body, (String)"payerAcctNm", (String)payerAcctNm);
        JDomUtils.addChild((Element)body, (String)"tranAmt", (String)tranAmt);
        JDomUtils.addChild((Element)body, (String)"abstract", (String)remark);
        JDomUtils.addChild((Element)body, (String)"ccy", (String)ccy);
        JDomUtils.addChild((Element)body, (String)"pyeeCstmrAcct", (String)pyeeCstmrAcct);
        JDomUtils.addChild((Element)body, (String)"pyeeAcctNm", (String)pyeeAcctNm);
        JDomUtils.addChild((Element)body, (String)"payeeOpenBankInterbankNo", (String)payeeOpenBankInterbankNo);
        JDomUtils.addChild((Element)body, (String)"clientNo", (String)clientNo);
        JDomUtils.addChild((Element)body, (String)"thirdSeqNo", (String)paymentInfo.getPackageId());
        JDomUtils.addChild((Element)body, (String)"aprvOprtFlg", (String)aprvOprtFlg);
        JDomUtils.addChild((Element)body, (String)"purpose", (String)remark);
        return Helper.element2jsonStr(root);
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        JSONObject body;
        String seqNo;
        List paymentInfos = bankPayRequest.getPaymentInfos();
        JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
        JSONObject rspData = jsonObject.getJSONObject("rspData");
        JSONObject head = rspData.getJSONObject("head");
        String errorCode = head.getString("errorCode");
        String errorMsg = head.getString("errorMsg");
        if (!"000000".equalsIgnoreCase(errorCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u4ee3\u7801\u3002", (String)"PayImpl_0", (String)"ebg-aqap-banks-tlyh-dc", (Object[])new Object[0]), (String)errorCode, (String)errorMsg);
            return new EBBankPayResponse(paymentInfos);
        }
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String seqId = paymentInfo.getPackageId();
        if (!seqId.equalsIgnoreCase(seqNo = (body = rspData.getJSONObject("body")).getString("thirdSeqNo"))) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u5ba2\u6237\u6d41\u6c34\u53f7\u4e0e\u94f6\u884c\u8fd4\u56de\u6d41\u6c34\u53f7\u4e0d\u4e00\u81f4\u3002", (String)"PayImpl_1", (String)"ebg-aqap-banks-tlyh-dc", (Object[])new Object[0]), (String)errorCode, (String)errorMsg);
            return new EBBankPayResponse(paymentInfos);
        }
        String oriRetCode = body.getString("oriRetCode");
        String oriRetMsg = body.getString("oriRetMsg");
        if ("1".equalsIgnoreCase(oriRetCode) || "5".equalsIgnoreCase(oriRetCode) || "6".equalsIgnoreCase(oriRetCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"PayImpl_2", (String)"ebg-aqap-banks-tlyh-dc", (Object[])new Object[0]), (String)oriRetCode, (String)oriRetMsg);
        } else if ("0".equalsIgnoreCase(oriRetCode) || "3".equalsIgnoreCase(oriRetCode) || "4".equalsIgnoreCase(oriRetCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PayImpl_3", (String)"ebg-aqap-banks-tlyh-dc", (Object[])new Object[0]), (String)oriRetCode, (String)oriRetMsg);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"PayImpl_4", (String)"ebg-aqap-banks-tlyh-dc", (Object[])new Object[0]), (String)oriRetCode, (String)oriRetMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return !"pay_for_salary".equalsIgnoreCase(paymentInfo.getSubBizType()) && !"overseaPay".equals(paymentInfo.getSubBizType());
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/preSfpPOST");
        factory.setHttpHeader("Content-Type", "application/json");
    }
}

