/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.tccb.dc.services.payment.outter;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.tccb.dc.utils.TCommon;
import kd.ebg.aqap.banks.tccb.dc.utils.TPacker;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class OutterBankQueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    EBGLogger log = EBGLogger.getInstance().getLogger(OutterBankQueryPayImpl.class);

    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "B2eOuterBankStatusQuery";
    }

    public String getBizDesc() {
        return "";
    }

    public String pack(BankPayRequest request) {
        PaymentInfo[] paymentInfos = request.getPaymentInfoAsArray();
        if (paymentInfos.length > 1) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u4ed8\u6b3e\u72b6\u6001\u540c\u6b65\u3002", (String)"OutterBankQueryPayImpl_0", (String)"ebg-aqap-banks-tccb-dc", (Object[])new Object[0]));
        }
        PaymentInfo paymenInfo = paymentInfos[0];
        String req_no = Sequence.genSequence();
        String tr_code = "B2eOuterBankStatusQuery";
        String userID = RequestContextUtils.getBankParameterValue((String)"userID");
        String userPassword = RequestContextUtils.getBankParameterValue((String)"userPassword");
        String operatorID = RequestContextUtils.getBankParameterValue((String)"operatorID");
        LocalDateTime now = LocalDateTime.now();
        String d = now.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"));
        Element transaction = TPacker.createCommonHead(tr_code, userID, userPassword, operatorID, req_no, "1", d);
        Element RequestBody = JDomUtils.addChild((Element)transaction, (String)"RequestBody");
        Element RequestRecord = JDomUtils.addChild((Element)RequestBody, (String)"RequestRecord");
        JDomUtils.addChild((Element)RequestRecord, (String)"Sendjnlno", (String)paymenInfo.getPackageId());
        LocalDateTime sst = paymenInfo.getSubmitSuccessTime();
        JDomUtils.addChild((Element)RequestRecord, (String)"QueryDate", (String)sst.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2String((Element)transaction, (String)encoding);
        return xmlMsg;
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        List paymentInfos = request.getPaymentInfos();
        Element transaction = JDomUtils.string2Root((String)responseStr, (String)encoding);
        Element RespondHeader = transaction.getChild("RespondHeader");
        BankResponse response = TCommon.parseBankResponse(RespondHeader);
        Element RespondBody = transaction.getChild("RespondBody");
        Element RespondRecord = RespondBody.getChild("RespondRecord");
        String TrsStatus = RespondRecord.getChildTextTrim("Status");
        if (!"RET2000".equals(response.getResponseCode()) && !"0000".equals(response.getResponseCode())) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"OutterBankQueryPayImpl_1", (String)"ebg-aqap-banks-tccb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
        } else if ("a".equals(TrsStatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"OutterBankQueryPayImpl_2", (String)"ebg-aqap-banks-tccb-dc", (Object[])new Object[0]), (String)TrsStatus, (String)"");
        } else if ("b".equals(TrsStatus) || "c".equals(TrsStatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"OutterBankQueryPayImpl_3", (String)"ebg-aqap-banks-tccb-dc", (Object[])new Object[0]), (String)TrsStatus, (String)response.getResponseMessage());
        } else if ("d".equals(TrsStatus)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"OutterBankQueryPayImpl_4", (String)"ebg-aqap-banks-tccb-dc", (Object[])new Object[0]), (String)TrsStatus, (String)"");
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"OutterBankQueryPayImpl_1", (String)"ebg-aqap-banks-tccb-dc", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public void configFactory(ConnectionFactory factory) {
        String encoding = TCommon.getEncoding();
        factory.setUri(TPacker.getHttpUrl("pay"));
        factory.setHttpHeader("content-type", "text/xml; charset=" + encoding);
    }
}

